/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.crosscuts.ast;

import org.aspectj.compiler.base.CodeWriter;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.cst.Name;
import org.aspectj.compiler.crosscuts.ast.NamePattern;

public class NamePatterns
extends ASTObject {
    protected int size;
    public NamePattern[] children;

    public NamePattern pop() {
        NamePattern ret = this.get(this.size() - 1);
        this.remove(this.size() - 1);
        return ret;
    }

    public String toShortString() {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < this.size()) {
            if (i > 0) {
                buf.append(".");
            }
            buf.append(this.get(i).toShortString());
            ++i;
        }
        return buf.toString();
    }

    public String toString() {
        return this.toShortString();
    }

    public void unparse(CodeWriter writer) {
        writer.writeChildren(this);
    }

    public Name makeName() {
        SourceLocation sourceLocation = this.getSourceLocation();
        Name temp = null;
        int i = 0;
        int len = this.size();
        while (i < len) {
            String simpleName = this.get(i).getSimpleName();
            if (simpleName == null) {
                return null;
            }
            temp = new Name(sourceLocation, temp, simpleName, true);
            ++i;
        }
        return temp;
    }

    public NamePatterns(SourceLocation location, NamePattern[] _children) {
        super(location);
        int i = 0;
        while (i < _children.length) {
            if (_children[i] != null) {
                _children[i].setParent(this);
            }
            ++i;
        }
        this.children = _children;
        this.size = _children.length;
    }

    public NamePatterns(SourceLocation location) {
        this(location, new NamePattern[0]);
    }

    public NamePatterns(SourceLocation location, NamePattern child1) {
        this(location, new NamePattern[]{child1});
    }

    public NamePatterns(SourceLocation location, NamePattern child1, NamePattern child2) {
        this(location, new NamePattern[]{child1, child2});
    }

    public NamePatterns(SourceLocation location, NamePattern child1, NamePattern child2, NamePattern child3) {
        this(location, new NamePattern[]{child1, child2, child3});
    }

    public ASTObject copyWalk(CopyWalker walker) {
        int N = this.size;
        NamePattern[] copiedChildren = new NamePattern[N];
        int newIndex = 0;
        int oldIndex = 0;
        while (oldIndex < N) {
            NamePattern newChild = (NamePattern)walker.process(this.children[oldIndex]);
            if (newChild != null) {
                copiedChildren[newIndex++] = newChild;
            }
            ++oldIndex;
        }
        NamePatterns ret = new NamePatterns(this.getSourceLocation(), copiedChildren);
        ret.size = newIndex;
        ret.setSource(this);
        return ret;
    }

    public ASTObject getChildAt(int childIndex) {
        return this.get(childIndex);
    }

    public void setChildAt(int childIndex, ASTObject child) {
        this.set(childIndex, (NamePattern)child);
    }

    public String getChildNameAt(int childIndex) {
        return "name" + childIndex;
    }

    public int getChildCount() {
        return this.size;
    }

    public int size() {
        return this.size;
    }

    public NamePattern get(int index) {
        if (index >= this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.children[index];
    }

    public void set(int index, NamePattern child) {
        if (index >= this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.children[index] = child;
        child.setParent(this);
    }

    public void resize(int newSize) {
        if (newSize > this.children.length) {
            NamePattern[] newChildren = new NamePattern[this.children.length * 2 + 1];
            System.arraycopy(this.children, 0, newChildren, 0, this.children.length);
            this.children = newChildren;
        }
        this.size = newSize;
    }

    public void addAll(NamePatterns collection) {
        this.addAll(this.size, collection);
    }

    public void addAll(int index, NamePatterns collection) {
        int i = 0;
        while (i < collection.size()) {
            this.add(index + i, collection.get(i));
            ++i;
        }
    }

    public void add(NamePattern child) {
        this.add(this.size, child);
    }

    public void add(int index, NamePattern child) {
        if (child == null) {
            return;
        }
        if (index < 0 || index > this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.resize(this.size + 1);
        int moveIndex = this.size - 1;
        while (moveIndex > index) {
            this.children[moveIndex] = this.children[moveIndex - 1];
            --moveIndex;
        }
        this.children[index] = child;
        child.setParent(this);
    }

    public void remove(int index) {
        if (index < 0 || index > this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        --this.size;
        int moveIndex = index;
        while (moveIndex < this.size) {
            this.children[moveIndex] = this.children[moveIndex + 1];
            ++moveIndex;
        }
    }

    public String getDefaultDisplayName() {
        return "NamePatterns()";
    }
}

