/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.crosscuts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.aspectj.compiler.base.JavaCompiler;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.ArrayTypeD;
import org.aspectj.compiler.base.ast.ConstructorDec;
import org.aspectj.compiler.base.ast.Dec;
import org.aspectj.compiler.base.ast.Decs;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.FieldDec;
import org.aspectj.compiler.base.ast.FormalDec;
import org.aspectj.compiler.base.ast.Formals;
import org.aspectj.compiler.base.ast.MethodDec;
import org.aspectj.compiler.base.ast.Modifiers;
import org.aspectj.compiler.base.ast.Stmt;
import org.aspectj.compiler.base.ast.TypeD;
import org.aspectj.compiler.base.ast.TypeDs;
import org.aspectj.compiler.base.cst.Name;
import org.aspectj.compiler.base.cst.UnresolvedNameTypeD;
import org.aspectj.compiler.base.parser.JavaParser;
import org.aspectj.compiler.base.parser.ParseException;
import org.aspectj.compiler.base.parser.Token;
import org.aspectj.compiler.crosscuts.ast.AfterAdviceDec;
import org.aspectj.compiler.crosscuts.ast.AfterReturningAdviceDec;
import org.aspectj.compiler.crosscuts.ast.AfterThrowingAdviceDec;
import org.aspectj.compiler.crosscuts.ast.AndPcd;
import org.aspectj.compiler.crosscuts.ast.AnyName;
import org.aspectj.compiler.crosscuts.ast.ArgsPcd;
import org.aspectj.compiler.crosscuts.ast.AroundAdviceDec;
import org.aspectj.compiler.crosscuts.ast.AspectDec;
import org.aspectj.compiler.crosscuts.ast.BeforeAdviceDec;
import org.aspectj.compiler.crosscuts.ast.CFlowPcd;
import org.aspectj.compiler.crosscuts.ast.CallPcd;
import org.aspectj.compiler.crosscuts.ast.CodePattern;
import org.aspectj.compiler.crosscuts.ast.ComplementTypeName;
import org.aspectj.compiler.crosscuts.ast.ConstructorPattern;
import org.aspectj.compiler.crosscuts.ast.EllipsesFakeNamePattern;
import org.aspectj.compiler.crosscuts.ast.EllipsesFakeTypeName;
import org.aspectj.compiler.crosscuts.ast.EmptyPcd;
import org.aspectj.compiler.crosscuts.ast.ExecutionPcd;
import org.aspectj.compiler.crosscuts.ast.FieldGetPcd;
import org.aspectj.compiler.crosscuts.ast.FieldPattern;
import org.aspectj.compiler.crosscuts.ast.FieldSetPcd;
import org.aspectj.compiler.crosscuts.ast.FormalsPattern;
import org.aspectj.compiler.crosscuts.ast.GenTypeName;
import org.aspectj.compiler.crosscuts.ast.GenTypeNames;
import org.aspectj.compiler.crosscuts.ast.HandlerPcd;
import org.aspectj.compiler.crosscuts.ast.IfPcd;
import org.aspectj.compiler.crosscuts.ast.InitializerPcd;
import org.aspectj.compiler.crosscuts.ast.IntersectTypeName;
import org.aspectj.compiler.crosscuts.ast.IntroducedDec;
import org.aspectj.compiler.crosscuts.ast.IntroducedSuperDec;
import org.aspectj.compiler.crosscuts.ast.MethodPattern;
import org.aspectj.compiler.crosscuts.ast.ModifiersPattern;
import org.aspectj.compiler.crosscuts.ast.NamePattern;
import org.aspectj.compiler.crosscuts.ast.NamePatterns;
import org.aspectj.compiler.crosscuts.ast.NamePcd;
import org.aspectj.compiler.crosscuts.ast.NameTypeDsPattern;
import org.aspectj.compiler.crosscuts.ast.NotPcd;
import org.aspectj.compiler.crosscuts.ast.OrPcd;
import org.aspectj.compiler.crosscuts.ast.PatternTypeName;
import org.aspectj.compiler.crosscuts.ast.Pcd;
import org.aspectj.compiler.crosscuts.ast.PerCFlow;
import org.aspectj.compiler.crosscuts.ast.PerClause;
import org.aspectj.compiler.crosscuts.ast.PerSingleton;
import org.aspectj.compiler.crosscuts.ast.PerThisOrTarget;
import org.aspectj.compiler.crosscuts.ast.PointcutDec;
import org.aspectj.compiler.crosscuts.ast.ShowErrorDec;
import org.aspectj.compiler.crosscuts.ast.SimpleName;
import org.aspectj.compiler.crosscuts.ast.SoftThrowableDec;
import org.aspectj.compiler.crosscuts.ast.StaticInitializerPcd;
import org.aspectj.compiler.crosscuts.ast.TargetPcd;
import org.aspectj.compiler.crosscuts.ast.ThisPcd;
import org.aspectj.compiler.crosscuts.ast.UnionTypeName;
import org.aspectj.compiler.crosscuts.ast.WildName;
import org.aspectj.compiler.crosscuts.ast.WithinCodePcd;
import org.aspectj.compiler.crosscuts.ast.WithinPcd;

public class AspectJParser
extends JavaParser {
    protected Map aspectDecParsers;
    private JavaParser.InfixOperator[] infixPcdOperators;
    private JavaParser.PrefixOperator[] prefixPcdOperators;
    protected JavaParser.ExprParser pointcutParser;
    private JavaParser.InfixOperator[] infixTypeNameOperators;
    private JavaParser.PrefixOperator[] prefixTypeNameOperators;
    protected JavaParser.ExprParser typeNameParser;

    public AspectJParser(JavaCompiler compiler) {
        super(compiler);
        this.decParsers.put("aspect", new AspectDecParser());
        this.decParsers.put("pointcut", new PointcutDecParser());
        JavaParser.modifiers.put("privileged", new Integer(65536));
        this.aspectDecParsers = new HashMap();
        this.aspectDecParsers.put("declare", new DeclareParser());
        this.aspectDecParsers.put("before", new BeforeDecParser());
        this.aspectDecParsers.put("after", new AfterDecParser());
        this.aspectDecParsers.put("around", new AroundDecParser());
        this.aspectDecParsers.put("pointcut", new PointcutDecParser());
        this.infixPcdOperators = new JavaParser.InfixOperator[]{new UnionPcdOperator(500), new IntersectPcdOperator(700)};
        this.prefixPcdOperators = new JavaParser.PrefixOperator[]{new PcdOp(70), new PcdOp(47), new PcdOp(68), new ComplementPcdOperator(3000), new ParenPcdOperator(1)};
        this.pointcutParser = new JavaParser.ExprParser(this.prefixPcdOperators, this.infixPcdOperators, false);
        this.infixTypeNameOperators = new JavaParser.InfixOperator[]{new UnionTypeNameOperator(500), new IntersectTypeNameOperator(700)};
        this.prefixTypeNameOperators = new JavaParser.PrefixOperator[]{new TypeNameOp(70), new TypeNameOp(47), new ComplementTypeNameOperator(3000), new ParenTypeNameOperator(1)};
        this.typeNameParser = new JavaParser.ExprParser(this.prefixTypeNameOperators, this.infixTypeNameOperators, false);
    }

    protected void eatModifiersPattern() {
        while (true) {
            Token token = this.peekToken();
            if (token.kind != 33 && !this.isModifier(token)) break;
            this.eatTopToken();
        }
    }

    public ModifiersPattern parseModifiersPattern(int legalModifiers) {
        int trueValue = 0;
        int falseValue = 0;
        Token beginToken = this.peekToken();
        while (true) {
            Integer ivalue;
            boolean assertion = true;
            if (this.peekToken().kind == 33) {
                if (this.getModifier(this.peekToken(1)) == null) break;
                this.eatTopToken();
                assertion = false;
            }
            if ((ivalue = this.getModifier(this.peekToken())) == null) {
                if (assertion) break;
                this.throwError(null, "! in modifier pattern not followed by modifier");
                break;
            }
            int value = ivalue;
            if ((legalModifiers & value) != value) {
                this.throwError(null, "illegal modifier for this dec");
            }
            this.eatTopToken();
            if (assertion) {
                trueValue |= value;
                continue;
            }
            falseValue |= value;
        }
        ModifiersPattern modifiers = new ModifiersPattern(this.dummySource, trueValue, falseValue);
        this.addContext((ASTObject)modifiers, beginToken);
        return modifiers;
    }

    public NameTypeDsPattern parseNameTypeDsPattern() {
        if (this.peekToken((int)0).kind != 33 && !this.isIdentifier(this.peekToken(0))) {
            return null;
        }
        TypeDs trueNames = new TypeDs(this.dummySource);
        TypeDs falseNames = new TypeDs(this.dummySource);
        while (true) {
            TypeD nameTypeD;
            Token token = this.peekToken(0);
            boolean assertion = true;
            if (token.kind == 33) {
                this.eatTopToken();
                token = this.peekToken(0);
                assertion = false;
            }
            if ((nameTypeD = this.parseNameTypeD()) == null && !assertion) {
                this.throwError(token, "illegal name pattern");
            }
            if (assertion) {
                trueNames.add(nameTypeD);
            } else {
                falseNames.add(nameTypeD);
            }
            if (this.peekToken((int)0).kind != 28) break;
            this.eatTopToken();
        }
        return new NameTypeDsPattern(this.dummySource, trueNames, falseNames);
    }

    public NameTypeDsPattern parseThrowsPattern() {
        if (this.maybeEatKeyword("throws")) {
            return this.parseNameTypeDsPattern();
        }
        return null;
    }

    public GenTypeName parseFormalPattern() {
        Token beginToken = this.peekToken();
        if (beginToken.kind == 29 && this.peekToken((int)1).kind == 29) {
            this.eatTopToken();
            this.eatTopToken();
            return null;
        }
        GenTypeName genTypeName = this.parseGenTypeName();
        this.addContext((ASTObject)genTypeName, beginToken);
        return genTypeName;
    }

    public FormalsPattern parseFormalsPattern() {
        Token beginToken = this.peekToken();
        this.eatTopToken(21);
        GenTypeNames names = new GenTypeNames(this.dummySource);
        FormalsPattern formalsPattern = new FormalsPattern(this.dummySource, names);
        if (this.peekToken().kind != 22) {
            while (true) {
                GenTypeName pattern;
                if ((pattern = this.parseFormalPattern()) == null) {
                    pattern = new EllipsesFakeTypeName(this.dummySource);
                    this.addContext((ASTObject)pattern, this.peekToken(-1));
                }
                names.add(pattern);
                Token t = this.popToken();
                if (t.kind != 22) {
                    if (t.kind == 28) continue;
                    this.throwError(t, "expected ',' or ')'");
                    continue;
                }
                break;
            }
        } else {
            this.eatTopToken();
        }
        this.addContext((ASTObject)names, beginToken);
        this.addContext((ASTObject)formalsPattern, beginToken);
        return formalsPattern;
    }

    public Expr parseVarInitializer() {
        if (this.peekToken((int)0).kind == 30) {
            this.eatTopToken();
            if (this.peekToken((int)0).kind == 23) {
                return this.parseArrayInitializer();
            }
            return this.parseExpr();
        }
        return null;
    }

    public TypeD parseOptionalReturnTypeD() {
        if (!this.maybeEatKeyword("returns")) {
            return null;
        }
        Token beginToken = this.peekToken();
        return this.parseTypeD();
    }

    public boolean isAdjacent(Token t1, Token t2) {
        return t1.endPosition == t2.startPosition;
    }

    String makeNamePatternPiece(Token t) {
        if (t.isIdentifier()) {
            return t.image;
        }
        if (t.kind == 47) {
            return "*";
        }
        if (t.kind == 13) {
            return t.image;
        }
        return null;
    }

    public NamePattern parseNamePattern(Token t1, String firstPiece) {
        String piece;
        ArrayList<String> pieces = new ArrayList<String>();
        pieces.add(firstPiece);
        Token previousToken = t1;
        while (this.isAdjacent(previousToken, this.peekToken())) {
            previousToken = this.peekToken();
            piece = this.makeNamePatternPiece(previousToken);
            if (piece == null) break;
            this.eatTopToken();
            pieces.add(piece);
        }
        if (pieces.size() == 1) {
            piece = (String)pieces.get(0);
            if (piece == "*") {
                return new AnyName(this.makeSourceLocation(t1));
            }
            return new SimpleName(this.makeSourceLocation(t1), piece);
        }
        return new WildName(this.makeSourceLocation(t1), pieces);
    }

    public NamePattern parseNamePattern() {
        Token t1 = this.peekToken();
        String firstPiece = this.makeNamePatternPiece(t1);
        if (firstPiece == null) {
            this.throwError(t1, "identifier pattern expected");
            return null;
        }
        this.eatTopToken();
        return this.parseNamePattern(t1, firstPiece);
    }

    protected boolean inAspect() {
        return this.peekEnclosingTypeDec() != null && this.peekEnclosingTypeDec() instanceof AspectDec;
    }

    protected boolean eatIdentifier(boolean onlyDec) {
        if (!this.inAspect() || !onlyDec) {
            return super.eatIdentifier(onlyDec);
        }
        if (this.eatGenTypeName()) {
            if (this.peekToken().kind == 29) {
                this.eatTopToken();
                this.eatTopToken();
            }
            return true;
        }
        return false;
    }

    public TypeNameAndId parseTypeNameAndId() {
        TypeNameAndId ret = new TypeNameAndId();
        Token beginToken = this.peekToken();
        if (this.peekToken().kind == 21 || this.peekKeyword("subtypes")) {
            ret.typeName = this.parseGenTypeName();
            this.eatTopToken(29);
            ret.namePattern = this.parseNamePattern();
        } else {
            NamePatterns namePatterns = this.parseDottedNamePatterns();
            boolean includeSubTypes = false;
            if (this.peekToken().kind == 45 || this.peekToken().kind == 25) {
                ret.typeName = this.finishParsingPatternTypeName(beginToken, namePatterns);
                this.eatTopToken(29);
                ret.namePattern = this.parseNamePattern();
            } else {
                ret.namePattern = namePatterns.pop();
                if (namePatterns.size() > 0) {
                    ret.typeName = new PatternTypeName(this.dummySource, namePatterns, false, 0);
                    ret.typeName.setSource(namePatterns);
                }
            }
        }
        return ret;
    }

    protected boolean eatGenTypeName() {
        if (this.peekKeyword("import")) {
            return false;
        }
        if (this.peekToken((int)0).kind == 21 && this.peekToken((int)1).kind != 22) {
            this.parseGenTypeName();
            return true;
        }
        if (!this.eatTypeD()) {
            return false;
        }
        this.maybeEatToken(45);
        return true;
    }

    protected Dec noDecFound() {
        Token beginToken = this.peekToken();
        if (this.inAspect()) {
            if (this.lookaheadIntroducedSuperDec()) {
                return this.parseIntroducedSuperDec();
            }
            if (this.lookaheadIntroducedConstructorDec()) {
                return this.parseIntroducedConstructorDec();
            }
        }
        this.throwError(beginToken, "declaration or '}' expected");
        return null;
    }

    protected boolean lookaheadIntroducedSuperDec() {
        this.pushCurrentIndex();
        if (this.eatGenTypeName()) {
            if (this.maybeEatKeyword("implements") || this.maybeEatKeyword("extends")) {
                this.throwError(this.peekToken(-1), "expected +implements or +extends");
                return false;
            }
            if (this.maybeEatToken(45) && (this.maybeEatKeyword("implements") || this.maybeEatKeyword("extends"))) {
                this.popCurrentIndex();
                return true;
            }
        }
        this.popCurrentIndex();
        return false;
    }

    public Dec parseIntroducedSuperDec() {
        boolean isImplements;
        this.getCompiler().warnVersion("1.0alpha1", this.tokenToASTObject(this.peekToken()), "use declare parents instead");
        GenTypeName typeName = this.parseGenTypeName();
        this.eatTopToken(45);
        if (this.maybeEatKeyword("implements")) {
            isImplements = true;
        } else {
            this.eatKeyword("extends");
            isImplements = false;
        }
        TypeDs typeDs = this.parseTypeDs();
        IntroducedSuperDec ret = new IntroducedSuperDec(this.dummySource, typeName, typeDs, isImplements);
        this.eatTopToken(27);
        return ret;
    }

    protected boolean lookaheadIntroducedConstructorDec() {
        this.pushCurrentIndex();
        this.eatModifiers();
        if (this.eatGenTypeName() && this.maybeEatToken(29) && this.maybeEatToken(68)) {
            this.popCurrentIndex();
            return true;
        }
        this.popCurrentIndex();
        return false;
    }

    public Dec parseIntroducedConstructorDec() {
        int legalModifiers = 7;
        Token beginToken = this.peekToken();
        Modifiers modifiers = this.parseModifiers(legalModifiers);
        GenTypeName genTypeName = null;
        if (this.inAspect()) {
            TypeNameAndId gid = this.parseTypeNameAndId();
            genTypeName = gid.typeName;
            String id = gid.getId();
            if (genTypeName != null) {
                if (!id.equals("new")) {
                    this.throwError(beginToken, "bad introduced constructor syntax");
                }
            } else if (!id.equals(this.peekEnclosingTypeDec().getId())) {
                this.throwError(beginToken, "constructor name doesn't match enclosing type " + this.peekEnclosingTypeDec().getId());
            }
        } else {
            this.parseIdMatchingEnclosingTypeName("constructor name");
        }
        Formals formals = this.parseFormals();
        TypeDs _throws = this.parseThrows();
        ConstructorDec ret = new ConstructorDec(this.dummySource, modifiers, formals, _throws, this.parseConstructorBody());
        if (genTypeName != null) {
            return new IntroducedDec(this.dummySource, genTypeName, ret);
        }
        return ret;
    }

    public Dec parseConstructorDec() {
        this.pushCurrentIndex();
        this.eatModifiers();
        if (this.peekKeyword("subtypes")) {
            this.popCurrentIndex();
            return this.parseIntroducedConstructorDec();
        }
        this.popCurrentIndex();
        return super.parseConstructorDec();
    }

    public Dec parseMethodDec() {
        int legalModifiers = this.inInterface ? 1025 : 3391;
        Modifiers modifiers = this.parseModifiers(legalModifiers);
        if (this.inInterface) {
            modifiers.setAbstract(true);
            modifiers.setPublic(true);
        }
        TypeD typeD = this.parseTypeD();
        GenTypeName genTypeName = null;
        String id = null;
        if (this.inAspect()) {
            TypeNameAndId gid = this.parseTypeNameAndId();
            genTypeName = gid.typeName;
            id = gid.getId();
            if (genTypeName == null && id.equals("around")) {
                return this.parseAroundAdviceDec(modifiers, typeD);
            }
        } else {
            id = this.parseId();
        }
        Formals formals = this.parseFormals();
        typeD = this.addBracketsToTypeD(typeD);
        TypeDs _throws = this.parseThrows();
        MethodDec ret = new MethodDec(this.dummySource, modifiers, typeD, id, formals, _throws, this.parseOptionalCodeBody());
        if (genTypeName != null) {
            return new IntroducedDec(this.dummySource, genTypeName, ret);
        }
        return ret;
    }

    public Stmt parseFieldDec() {
        int legalModifiers = this.inInterface ? 25 : 223;
        Token beginToken = this.peekToken();
        Modifiers modifiers = this.parseModifiers(legalModifiers);
        if (this.inInterface) {
            modifiers.setPublic(true);
            modifiers.setStatic(true);
            modifiers.setFinal(true);
        }
        TypeD baseTypeD = this.parseTypeD();
        Decs decs = null;
        Dec dec = null;
        while (true) {
            GenTypeName genTypeName = null;
            String id = null;
            if (this.inAspect()) {
                TypeNameAndId gid = this.parseTypeNameAndId();
                genTypeName = gid.typeName;
                id = gid.getId();
            } else {
                id = this.parseId();
            }
            TypeD typeD = baseTypeD;
            Expr initializer = null;
            typeD = this.addBracketsToTypeD(typeD);
            Token endToken = this.popToken();
            if (endToken.kind == 30) {
                initializer = typeD instanceof ArrayTypeD && this.peekToken().kind == 23 ? this.parseArrayInitializer() : this.parseExpr();
                endToken = this.popToken();
            }
            dec = new FieldDec(this.dummySource, (Modifiers)modifiers.copy(), typeD, id, initializer);
            this.addContext((ASTObject)dec, beginToken);
            if (genTypeName != null) {
                dec = new IntroducedDec(this.dummySource, genTypeName, dec);
            }
            if (endToken.kind == 27) {
                if (decs == null) break;
                decs.add(dec);
                break;
            }
            if (endToken.kind == 28) {
                if (decs == null) {
                    decs = new Decs(this.dummySource, dec);
                } else {
                    decs.add(dec);
                }
                baseTypeD = (TypeD)baseTypeD.copy();
                continue;
            }
            this.throwError(endToken, "expected ',' or ';'");
        }
        if (decs != null) {
            return decs;
        }
        return dec;
    }

    public ConstructorPattern parseConstructorPattern() {
        int legalModifiers = 2055;
        Token beginToken = this.peekToken();
        ModifiersPattern modifiers = this.parseModifiersPattern(legalModifiers);
        TypeNameAndId gid = this.parseTypeNameAndId();
        GenTypeName declaringType = gid.typeName;
        if (!"new".equals(gid.namePattern.getSimpleName())) {
            this.throwError(this.peekToken(-1), "expected new");
        }
        FormalsPattern formals = this.parseFormalsPattern();
        NameTypeDsPattern _throws = this.parseThrowsPattern();
        ConstructorPattern ret = new ConstructorPattern(this.dummySource, modifiers, declaringType, formals, _throws);
        this.addContext((ASTObject)ret, beginToken);
        return ret;
    }

    public MethodPattern parseMethodPattern() {
        int legalModifiers = 3391;
        Token beginToken = this.peekToken();
        ModifiersPattern modifiers = this.parseModifiersPattern(legalModifiers);
        GenTypeName returnType = this.parseGenTypeName();
        TypeNameAndId gid = this.parseTypeNameAndId();
        GenTypeName declaringType = gid.typeName;
        NamePattern id = gid.namePattern;
        if ("new".equals(id.getSimpleName())) {
            this.tokenToASTObject(beginToken).showError("constructor patterns don't have a return type");
        }
        FormalsPattern formals = this.parseFormalsPattern();
        NameTypeDsPattern _throws = this.parseThrowsPattern();
        MethodPattern ret = new MethodPattern(this.dummySource, modifiers, declaringType, returnType, id, formals, _throws);
        this.addContext((ASTObject)ret, beginToken);
        return ret;
    }

    /*
     * WARNING - void declaration
     */
    public CodePattern parseConstructorOrMethodPattern() {
        this.pushCurrentIndex();
        try {
            void pe;
            ConstructorPattern ret = this.parseConstructorPattern();
            return pe;
        }
        catch (ParseException pe) {
            this.popCurrentIndex();
            return this.parseMethodPattern();
        }
    }

    public FieldPattern parseFieldPattern() {
        int legalModifiers = 415;
        Token beginToken = this.peekToken();
        ModifiersPattern modifiers = this.parseModifiersPattern(legalModifiers);
        GenTypeName fieldType = this.parseGenTypeName();
        TypeNameAndId gid = this.parseTypeNameAndId();
        GenTypeName declaringType = gid.typeName;
        NamePattern id = gid.namePattern;
        FieldPattern ret = new FieldPattern(this.dummySource, modifiers, declaringType, fieldType, id);
        this.addContext((ASTObject)ret, beginToken);
        return ret;
    }

    public void skipToMatching(int lparen, int rparen, int depth) {
        do {
            Token t = this.popToken();
            if (t.kind == lparen) {
                ++depth;
            }
            if (t.kind != rparen) continue;
            --depth;
        } while (depth > 0);
    }

    public void skipToMatchingParen() {
        this.skipToMatching(21, 22, 0);
    }

    public void warnNameChange(String name, String newName) {
        if (name.equals(newName)) {
            return;
        }
        this.getCompiler().warnVersion("1.0alpha1", this.tokenToASTObject(this.peekToken(-1)), "change from " + name + " to " + newName + "");
    }

    public Pcd parseFunctionPcd() {
        this.parseNoModifiers();
        Token beginToken = this.peekToken();
        String name = this.parseAnyId();
        if (name.equals("receptions")) {
            this.getCompiler().errorVersion("1.0alpha1", this.tokenToASTObject(this.peekToken(-1)), "replaced by call, see release notes");
            this.skipToMatchingParen();
            return new EmptyPcd(this.dummySource);
        }
        if (name.equals("calls") || name.equals("call")) {
            this.warnNameChange(name, "call");
            this.eatTopToken(21);
            CodePattern codePattern = this.parseConstructorOrMethodPattern();
            this.eatTopToken(22);
            return new CallPcd(this.dummySource, codePattern);
        }
        if (name.equals("gets") || name.equals("get")) {
            this.warnNameChange(name, "get");
            this.eatTopToken(21);
            FieldPattern fieldPattern = this.parseFieldPattern();
            this.eatTopToken(22);
            if (this.maybeEatToken(25)) {
                this.getCompiler().errorVersion("1.0alpha1", this.tokenToASTObject(this.peekToken(-1)), "[oldValue] not supported use field access to get this value");
                this.skipToMatching(25, 26, 1);
            }
            return new FieldGetPcd(this.dummySource, fieldPattern);
        }
        if (name.equals("sets") || name.equals("set")) {
            this.warnNameChange(name, "set");
            this.eatTopToken(21);
            FieldPattern fieldPattern = this.parseFieldPattern();
            this.eatTopToken(22);
            if (this.maybeEatToken(25)) {
                this.getCompiler().errorVersion("1.0alpha1", this.tokenToASTObject(this.peekToken(-1)), "[oldValue][newValue] not supported use field access to get oldValue and args(newValue)");
                this.skipToMatching(25, 26, 1);
                this.skipToMatching(25, 26, 0);
            }
            return new FieldSetPcd(this.dummySource, fieldPattern);
        }
        if (name.equals("executions") || name.equals("execution")) {
            this.warnNameChange(name, "execution");
            this.eatTopToken(21);
            CodePattern codePattern = this.parseConstructorOrMethodPattern();
            this.eatTopToken(22);
            return new ExecutionPcd(this.dummySource, codePattern);
        }
        if (name.equals("initialization")) {
            this.eatTopToken(21);
            ConstructorPattern codePattern = this.parseConstructorPattern();
            this.eatTopToken(22);
            return new InitializerPcd(this.dummySource, codePattern);
        }
        if (name.equals("initializations")) {
            this.getCompiler().errorVersion("1.0alpha1", this.tokenToASTObject(this.peekToken(-1)), "replaced by initialization with different meaning, see release notes");
            this.skipToMatchingParen();
            return new EmptyPcd(this.dummySource);
        }
        if (name.equals("staticinitializations") || name.equals("staticinitialization")) {
            this.warnNameChange(name, "staticinitialization");
            this.eatTopToken(21);
            GenTypeName genTypeName = this.parseGenTypeName();
            this.eatTopToken(22);
            return new StaticInitializerPcd(this.dummySource, genTypeName);
        }
        if (name.equals("handlers") || name.equals("handler")) {
            this.warnNameChange(name, "handler");
            this.eatTopToken(21);
            GenTypeName genTypeName = this.parseGenTypeName();
            this.eatTopToken(22);
            return new HandlerPcd(this.dummySource, genTypeName);
        }
        if (name.equals("hasaspect")) {
            this.getCompiler().errorVersion("1.0alpha1", this.tokenToASTObject(this.peekToken(-1)), "change to if(A.hasAspect(o))");
            this.eatTopToken(21);
            GenTypeName genTypeName = this.parseGenTypeName();
            this.eatTopToken(22);
            return new EmptyPcd(this.dummySource);
        }
        if (name.equals("instanceof") || name.equals("this")) {
            this.warnNameChange(name, "this");
            this.eatTopToken(21);
            GenTypeName genTypeName = this.parseGenTypeName();
            this.eatTopToken(22);
            return new ThisPcd(this.dummySource, genTypeName);
        }
        if (name.equals("within")) {
            this.eatTopToken(21);
            GenTypeName genTypeName = this.parseGenTypeName();
            this.eatTopToken(22);
            return new WithinPcd(this.dummySource, genTypeName);
        }
        if (name.equals("target")) {
            this.eatTopToken(21);
            GenTypeName genTypeName = this.parseGenTypeName();
            this.eatTopToken(22);
            return new TargetPcd(this.dummySource, genTypeName);
        }
        if (name.equals("args")) {
            FormalsPattern genTypeNames = this.parseFormalsPattern();
            return new ArgsPcd(this.dummySource, genTypeNames);
        }
        if (name.equals("withinall")) {
            this.getCompiler().errorVersion("1.0alpha1", this.tokenToASTObject(this.peekToken(-1)), "replaced with with(T+)");
            this.eatTopToken(21);
            GenTypeName genTypeName = this.parseGenTypeName();
            Object codePattern = null;
            this.eatTopToken(22);
            return new EmptyPcd(this.dummySource);
        }
        if (name.equals("withincode")) {
            this.eatTopToken(21);
            CodePattern codePattern = this.parseConstructorOrMethodPattern();
            this.eatTopToken(22);
            return new WithinCodePcd(this.dummySource, codePattern);
        }
        if (name.equals("callsto")) {
            this.getCompiler().errorVersion("1.0alpha1", this.tokenToASTObject(this.peekToken(-1)), "not supported any more due to the removal of reception join points");
            this.skipToMatchingParen();
            return new EmptyPcd(this.dummySource);
        }
        if (name.equals("cflow")) {
            this.eatTopToken(21);
            Pcd pointcut = this.parsePcd();
            this.eatTopToken(22);
            return new CFlowPcd(this.dummySource, pointcut, true);
        }
        if (name.equals("if")) {
            this.eatTopToken(21);
            Expr test = this.parseExpr();
            this.eatTopToken(22);
            return new IfPcd(this.dummySource, test);
        }
        if (name.equals("cflowbelow")) {
            this.eatTopToken(21);
            Pcd pointcut = this.parsePcd();
            this.eatTopToken(22);
            return new CFlowPcd(this.dummySource, pointcut, false);
        }
        if (name.equals("cflowtop")) {
            this.getCompiler().warnVersion("0.8beta3", this.tokenToASTObject(this.peekToken(-1)), "use common idiom cflow(P && !cflowbelow(P))");
            return new EmptyPcd(this.dummySource);
        }
        return new NamePcd(this.dummySource, null, name, this.parseFormalsPattern(), null);
    }

    private TypeD typeDFromName(Name name) {
        UnresolvedNameTypeD ret = new UnresolvedNameTypeD(this.dummySource, name);
        ret.setSource(name);
        return ret;
    }

    private NamePcd parseNamePcd() {
        Token begin = this.peekToken();
        Name name = this.parseExtendedName();
        if (name == null) {
            this.throwError(begin, "expected pcd here");
        }
        String pointcutName = name.getId();
        TypeD inTypeD = null;
        if (name.getParentName() != null) {
            inTypeD = this.typeDFromName(name.getParentName());
        }
        FormalsPattern formals = this.parseFormalsPattern();
        return new NamePcd(this.dummySource, inTypeD, pointcutName, formals, null);
    }

    public Pcd parsePcdTerminal() {
        if (this.peekToken((int)1).kind == 29) {
            return this.parseNamePcd();
        }
        return this.parseFunctionPcd();
    }

    public Pcd parsePcd() {
        Pcd ret = (Pcd)this.pointcutParser.parse();
        if (ret == null) {
            this.throwError(null, "pointcut designator required");
        }
        return ret;
    }

    public GenTypeName parseGenTypeName() {
        GenTypeName ret = (GenTypeName)this.typeNameParser.parse();
        if (ret == null) {
            this.throwError(this.peekToken(), "expected type name");
        }
        return ret;
    }

    public GenTypeName parseTypeNameTerminal() {
        Token beginToken = this.peekToken();
        if (this.maybeEatKeyword("subtypes")) {
            this.getCompiler().errorVersion("1.0alpha1", this.tokenToASTObject(this.peekToken(-1)), "subtypes(T) should be replaced by T+");
            this.skipToMatchingParen();
            return null;
        }
        GenTypeName baseType = this.parsePatternTypeName();
        return baseType;
    }

    public GenTypeName parsePatternTypeName() {
        Token beginToken = this.peekToken();
        NamePatterns names = this.parseDottedNamePatterns();
        return this.finishParsingPatternTypeName(beginToken, names);
    }

    protected PatternTypeName finishParsingPatternTypeName(Token beginToken, NamePatterns names) {
        boolean includeSubTypes = false;
        if (this.maybeEatToken(45)) {
            includeSubTypes = true;
        }
        int dimensions = 0;
        while (this.peekToken().kind == 25 && this.peekToken((int)1).kind == 26) {
            this.eatTopToken();
            this.eatTopToken();
            ++dimensions;
        }
        PatternTypeName ret = new PatternTypeName(this.dummySource, names, includeSubTypes, dimensions);
        this.addContext((ASTObject)ret, beginToken);
        return ret;
    }

    public NamePatterns parseDottedNamePatterns() {
        Token beginToken = this.peekToken();
        NamePatterns ret = new NamePatterns(this.dummySource, this.parseNamePattern());
        String extraName = null;
        while (this.peekToken().kind == 29 || this.peekToken().kind == 17) {
            Token t = this.popToken();
            if (t.kind == 17) {
                String i = t.image;
                int dot = i.indexOf(46);
                NamePattern p = ret.get(ret.size() - 1);
                if (p instanceof AnyName) {
                    ArrayList<String> pieces = new ArrayList<String>();
                    pieces.add("*");
                    pieces.add(i.substring(0, dot));
                    p.replaceWith(new WildName(this.dummySource, pieces));
                } else {
                    ((WildName)p).getPieces().add(i.substring(0, dot));
                }
                if (dot != i.length() - 1) {
                    extraName = i.substring(dot + 1);
                }
            }
            if (extraName == null && this.maybeEatToken(29)) {
                ret.add(new EllipsesFakeNamePattern(this.dummySource));
            }
            if (extraName != null) {
                ret.add(this.parseNamePattern(t, extraName));
                extraName = null;
                continue;
            }
            ret.add(this.parseNamePattern());
        }
        this.addContext((ASTObject)ret, beginToken);
        return ret;
    }

    public PerClause parsePerClause() {
        PerClause ret = null;
        Token beginToken = this.peekToken();
        if (!beginToken.isIdentifier()) {
            return null;
        }
        String name = this.parseAnyId();
        if (name.equals("perthis")) {
            this.eatTopToken(21);
            Pcd pointcut = this.parsePcd();
            this.eatTopToken(22);
            ret = new PerThisOrTarget(this.dummySource, pointcut, true);
        } else if (name.equals("pertarget")) {
            this.eatTopToken(21);
            Pcd pointcut = this.parsePcd();
            this.eatTopToken(22);
            ret = new PerThisOrTarget(this.dummySource, pointcut, false);
        } else if (name.equals("percflow")) {
            this.eatTopToken(21);
            Pcd pointcut = this.parsePcd();
            this.eatTopToken(22);
            ret = new PerCFlow(this.dummySource, pointcut, true);
        } else if (name.equals("percflowbelow")) {
            this.eatTopToken(21);
            Pcd pointcut = this.parsePcd();
            this.eatTopToken(22);
            ret = new PerCFlow(this.dummySource, pointcut, false);
        } else if (name.equals("issingleton")) {
            this.eatTopToken(21);
            this.eatTopToken(22);
            ret = new PerSingleton(this.dummySource);
        } else {
            this.throwError(beginToken, "expected issingleton, pertarget, perthis, percflow or percflowbelow");
        }
        this.addContext((ASTObject)ret, beginToken);
        return ret;
    }

    public PerClause parseOldOfClause() {
        PerClause ret = null;
        Token beginToken = this.peekToken(-1);
        String name = this.parseAnyId();
        if (name.equals("eachobject")) {
            this.getCompiler().errorVersion("1.0alpha1", this.tokenToASTObject(beginToken), "change to perthis or pertarget as appropriate");
            this.eatTopToken(21);
            Pcd pointcut = this.parsePcd();
            this.eatTopToken(22);
            return null;
        }
        if (name.equals("eachcflow")) {
            this.getCompiler().warnVersion("1.0alpha1", this.tokenToASTObject(beginToken), "change 'of eachcflow' to 'percflow'");
            this.eatTopToken(21);
            Pcd pointcut = this.parsePcd();
            this.eatTopToken(22);
            ret = new PerCFlow(this.dummySource, pointcut, true);
        } else if (name.equals("eachcflowbelow")) {
            this.getCompiler().warnVersion("1.0alpha1", this.tokenToASTObject(beginToken), "change 'of eachcflowbelow' to 'percflowbelow'");
            this.eatTopToken(21);
            Pcd pointcut = this.parsePcd();
            this.eatTopToken(22);
            ret = new PerCFlow(this.dummySource, pointcut, false);
        } else if (name.equals("eachJVM")) {
            this.getCompiler().warnVersion("1.0alpha1", this.tokenToASTObject(beginToken), "change 'of eachJVM' to 'issingleton'");
            this.eatTopToken(21);
            this.eatTopToken(22);
            ret = new PerSingleton(this.dummySource);
        } else {
            this.throwError(beginToken, "expected issingleton, pertarget, perthis, percflow or percflowbelow");
        }
        this.addContext(ret, beginToken);
        return ret;
    }

    public AroundAdviceDec parseAroundAdviceDec(Modifiers modifiers, TypeD resultTypeD) {
        Formals formals = this.parseFormals();
        TypeDs _throws = this.parseThrows();
        this.eatTopToken(36);
        Pcd pointcut = this.parsePcd();
        return new AroundAdviceDec(this.dummySource, modifiers, resultTypeD, formals, _throws, pointcut, this.parseCodeBodyFully());
    }

    class AfterDecParser
    extends JavaParser.DecParser {
        AfterDecParser() {
        }

        public Dec parse() {
            Modifiers modifiers = AspectJParser.this.parseModifiers(2056);
            AspectJParser.this.eatKeyword("after");
            Formals formals = AspectJParser.this.parseFormals();
            if (AspectJParser.this.maybeEatKeyword("returning")) {
                FormalDec formal = null;
                if (AspectJParser.this.maybeEatToken(21)) {
                    if (AspectJParser.this.peekToken().kind != 22) {
                        formal = AspectJParser.this.parseFormal();
                    }
                    AspectJParser.this.eatTopToken(22);
                }
                TypeDs _throws = AspectJParser.this.parseThrows();
                AspectJParser.this.eatTopToken(36);
                Pcd pointcut = AspectJParser.this.parsePcd();
                return new AfterReturningAdviceDec(AspectJParser.this.dummySource, modifiers, formals, formal, _throws, pointcut, AspectJParser.this.parseCodeBodyFully());
            }
            if (AspectJParser.this.maybeEatKeyword("throwing")) {
                FormalDec formal = null;
                if (AspectJParser.this.maybeEatToken(21)) {
                    if (AspectJParser.this.peekToken().kind != 22) {
                        formal = AspectJParser.this.parseFormal();
                    }
                    AspectJParser.this.eatTopToken(22);
                }
                TypeDs _throws = AspectJParser.this.parseThrows();
                AspectJParser.this.eatTopToken(36);
                Pcd pointcut = AspectJParser.this.parsePcd();
                return new AfterThrowingAdviceDec(AspectJParser.this.dummySource, modifiers, formals, formal, _throws, pointcut, AspectJParser.this.parseCodeBodyFully());
            }
            TypeDs _throws = AspectJParser.this.parseThrows();
            AspectJParser.this.eatTopToken(36);
            Pcd pointcut = AspectJParser.this.parsePcd();
            return new AfterAdviceDec(AspectJParser.this.dummySource, modifiers, formals, _throws, pointcut, AspectJParser.this.parseCodeBodyFully());
        }
    }

    class AroundDecParser
    extends JavaParser.DecParser {
        AroundDecParser() {
        }

        public Dec parse() {
            Modifiers modifiers = AspectJParser.this.parseModifiers(2056);
            boolean needReturns = false;
            TypeD resultTypeD = null;
            if (AspectJParser.this.maybeEatKeyword("around")) {
                needReturns = true;
                AspectJParser.this.getCompiler().warnVersion("1.0alpha1", AspectJParser.this.tokenToASTObject(AspectJParser.this.peekToken(-1)), "the return type now goes before the around keyword,\ni.e. Object around() instead of around() returns Object");
            } else {
                resultTypeD = AspectJParser.this.parseTypeD();
                AspectJParser.this.eatKeyword("around");
            }
            Formals formals = AspectJParser.this.parseFormals();
            if (needReturns) {
                if (!AspectJParser.this.maybeEatKeyword("returns")) {
                    AspectJParser.this.getCompiler().showError(formals, "return type required for around");
                } else {
                    resultTypeD = AspectJParser.this.parseTypeD();
                }
            }
            TypeDs _throws = AspectJParser.this.parseThrows();
            AspectJParser.this.eatTopToken(36);
            Pcd pointcut = AspectJParser.this.parsePcd();
            return new AroundAdviceDec(AspectJParser.this.dummySource, modifiers, resultTypeD, formals, _throws, pointcut, AspectJParser.this.parseCodeBodyFully());
        }
    }

    class BeforeDecParser
    extends JavaParser.DecParser {
        BeforeDecParser() {
        }

        public Dec parse() {
            Modifiers modifiers = AspectJParser.this.parseModifiers(2056);
            AspectJParser.this.eatKeyword("before");
            Formals formals = AspectJParser.this.parseFormals();
            TypeDs _throws = AspectJParser.this.parseThrows();
            AspectJParser.this.eatTopToken(36);
            Pcd pointcut = AspectJParser.this.parsePcd();
            return new BeforeAdviceDec(AspectJParser.this.dummySource, modifiers, formals, _throws, pointcut, AspectJParser.this.parseCodeBodyFully());
        }
    }

    class DeclareParser
    extends JavaParser.DecParser {
        DeclareParser() {
        }

        public Dec parse() {
            AspectJParser.this.parseNoModifiers();
            AspectJParser.this.eatKeyword("declare");
            String kind = AspectJParser.this.parseId();
            if (kind.equals("parents")) {
                boolean isImplements;
                AspectJParser.this.eatTopToken(36);
                GenTypeName typeName = AspectJParser.this.parseGenTypeName();
                if (AspectJParser.this.maybeEatKeyword("implements")) {
                    isImplements = true;
                } else {
                    AspectJParser.this.eatKeyword("extends");
                    isImplements = false;
                }
                TypeDs typeDs = AspectJParser.this.parseTypeDs();
                IntroducedSuperDec ret = new IntroducedSuperDec(AspectJParser.this.dummySource, typeName, typeDs, isImplements);
                AspectJParser.this.eatTopToken(27);
                return ret;
            }
            if (kind.equals("error") || kind.equals("warning")) {
                boolean isWarning = kind.equals("warning");
                AspectJParser.this.eatTopToken(36);
                Pcd pointcut = AspectJParser.this.parsePcd();
                AspectJParser.this.eatTopToken(36);
                Expr message = AspectJParser.this.parseExpr();
                return new ShowErrorDec(AspectJParser.this.dummySource, pointcut, message, isWarning);
            }
            if (kind.equals("soft")) {
                AspectJParser.this.eatTopToken(36);
                GenTypeName typeName = AspectJParser.this.parseGenTypeName();
                AspectJParser.this.eatTopToken(36);
                Pcd pointcut = AspectJParser.this.parsePcd();
                return new SoftThrowableDec(AspectJParser.this.dummySource, typeName, pointcut);
            }
            AspectJParser.this.throwError(AspectJParser.this.peekToken(-1), "no declare " + kind + " is defined");
            return null;
        }
    }

    class AspectDecParser
    extends JavaParser.DecParser {
        AspectDecParser() {
        }

        public Dec parse() {
            throw new RuntimeException();
        }

        public Dec parse(boolean isNotMethodLocal) {
            int legalModifiers = AspectJParser.this.peekEnclosingTypeDec() == null ? 68625 : (AspectJParser.this.inInterface ? 68633 : 68639);
            Modifiers modifiers = AspectJParser.this.parseModifiers(legalModifiers);
            if (AspectJParser.this.inInterface) {
                modifiers.setPublic(true);
            }
            AspectJParser.this.eatKeyword("aspect");
            String id = AspectJParser.this.parseId();
            TypeD superClass = null;
            if (AspectJParser.this.maybeEatKeyword("extends")) {
                superClass = AspectJParser.this.parseTypeD();
            }
            TypeDs _implements = null;
            if (AspectJParser.this.maybeEatKeyword("implements")) {
                _implements = AspectJParser.this.parseTypeDs();
            }
            GenTypeName _dominates = null;
            if (AspectJParser.this.maybeEatKeyword("dominates")) {
                _dominates = AspectJParser.this.parseGenTypeName();
            }
            PerClause perClause = null;
            perClause = AspectJParser.this.maybeEatKeyword("of") ? AspectJParser.this.parseOldOfClause() : AspectJParser.this.parsePerClause();
            AspectDec ret = new AspectDec(AspectJParser.this.dummySource, modifiers, id, superClass, _implements, _dominates, perClause, null);
            ret.setEnclosingTypeDec(AspectJParser.this.peekEnclosingTypeDec());
            AspectJParser.this.pushEnclosingTypeDec(ret);
            Decs body = null;
            boolean oldInInterface = AspectJParser.this.inInterface;
            boolean oldParseInterfaceOnly = AspectJParser.this.parseInterfaceOnly;
            try {
                AspectJParser.this.inInterface = false;
                AspectJParser.this.parseInterfaceOnly = false;
                body = AspectJParser.this.parseDecs(AspectJParser.this.aspectDecParsers);
                Object var14_13 = null;
            }
            catch (Throwable throwable) {
                Object var14_14 = null;
                AspectJParser.this.inInterface = oldInInterface;
                AspectJParser.this.parseInterfaceOnly = oldParseInterfaceOnly;
                throw throwable;
            }
            AspectJParser.this.inInterface = oldInInterface;
            AspectJParser.this.parseInterfaceOnly = oldParseInterfaceOnly;
            AspectJParser.this.popEnclosingTypeDec();
            ret.setBody(body);
            if (AspectJParser.this.peekEnclosingTypeDec() == null) {
                AspectJParser.this.currentCompilationUnit.addDefinedType(ret);
            }
            return ret;
        }
    }

    class PointcutDecParser
    extends JavaParser.DecParser {
        PointcutDecParser() {
        }

        public Dec parse() {
            Pcd pointcut;
            int legalModifiers = 1055;
            Modifiers modifiers = AspectJParser.this.parseModifiers(1055);
            AspectJParser.this.eatKeyword("pointcut");
            String name = AspectJParser.this.parseId();
            Formals formals = AspectJParser.this.parseFormals();
            TypeD resultTypeD = AspectJParser.this.parseOptionalReturnTypeD();
            if (modifiers.isAbstract()) {
                if (AspectJParser.this.peekToken().kind == 36) {
                    AspectJParser.this.throwError(null, "abstract pointcut can't have body");
                }
                AspectJParser.this.eatTopToken(27);
                return new PointcutDec(AspectJParser.this.dummySource, modifiers, name, resultTypeD, formals, new EmptyPcd(AspectJParser.this.dummySource));
            }
            if (AspectJParser.this.maybeEatToken(36)) {
                pointcut = AspectJParser.this.parsePcd();
                AspectJParser.this.eatTopToken(27);
            } else {
                pointcut = new EmptyPcd(AspectJParser.this.dummySource);
            }
            return new PointcutDec(AspectJParser.this.dummySource, modifiers, name, resultTypeD, formals, pointcut);
        }
    }

    class ParenTypeNameOperator
    extends JavaParser.PrefixOperator {
        public ParenTypeNameOperator(int precedence) {
            super("(", precedence);
        }

        public Expr parse() {
            AspectJParser.this.eatTopToken();
            GenTypeName cc = (GenTypeName)this.parentParse(this.precedence);
            AspectJParser.this.eatTopToken(22);
            return cc;
        }
    }

    class ComplementTypeNameOperator
    extends JavaParser.PrefixOperator {
        public ComplementTypeNameOperator(int precedence) {
            super("!", precedence);
        }

        public Expr parse() {
            AspectJParser.this.eatTopToken();
            return new ComplementTypeName(AspectJParser.this.dummySource, (GenTypeName)this.parentParse(this.precedence));
        }
    }

    class IntersectTypeNameOperator
    extends JavaParser.InfixOperator {
        public IntersectTypeNameOperator(int precedence) {
            super("&&", precedence);
        }

        public Expr parse(Expr lhs) {
            GenTypeName rhsCC = (GenTypeName)this.parentParse(this.precedence);
            return new IntersectTypeName(AspectJParser.this.dummySource, (GenTypeName)lhs, rhsCC);
        }
    }

    class UnionTypeNameOperator
    extends JavaParser.InfixOperator {
        public UnionTypeNameOperator(int precedence) {
            super("||", precedence);
        }

        public Expr parse(Expr lhs) {
            GenTypeName rhsCC = (GenTypeName)this.parentParse(this.precedence);
            return new UnionTypeName(AspectJParser.this.dummySource, (GenTypeName)lhs, rhsCC);
        }
    }

    class TypeNameOp
    extends JavaParser.PrefixOperator {
        public TypeNameOp(int kind) {
            super(kind, -1);
        }

        public Expr parse() {
            return AspectJParser.this.parseTypeNameTerminal();
        }
    }

    class ParenPcdOperator
    extends JavaParser.PrefixOperator {
        public ParenPcdOperator(int precedence) {
            super("(", precedence);
        }

        public Expr parse() {
            AspectJParser.this.eatTopToken();
            Pcd cc = (Pcd)this.parentParse(this.precedence);
            AspectJParser.this.eatTopToken(22);
            return cc;
        }
    }

    class ComplementPcdOperator
    extends JavaParser.PrefixOperator {
        public ComplementPcdOperator(int precedence) {
            super("!", precedence);
        }

        public Expr parse() {
            if (AspectJParser.this.isModifier(AspectJParser.this.peekToken(1))) {
                return AspectJParser.this.parsePcdTerminal();
            }
            AspectJParser.this.eatTopToken();
            return new NotPcd(AspectJParser.this.dummySource, (Pcd)this.parentParse(this.precedence));
        }
    }

    class IntersectPcdOperator
    extends JavaParser.InfixOperator {
        public IntersectPcdOperator(int precedence) {
            super("&&", precedence);
        }

        public Expr parse(Expr lhs) {
            Pcd rhsCC = (Pcd)this.parentParse(this.precedence);
            return new AndPcd(AspectJParser.this.dummySource, (Pcd)lhs, rhsCC);
        }
    }

    class UnionPcdOperator
    extends JavaParser.InfixOperator {
        public UnionPcdOperator(int precedence) {
            super("||", precedence);
        }

        public Expr parse(Expr lhs) {
            Pcd rhsCC = (Pcd)this.parentParse(this.precedence);
            return new OrPcd(AspectJParser.this.dummySource, (Pcd)lhs, rhsCC);
        }
    }

    class PcdOp
    extends JavaParser.PrefixOperator {
        public PcdOp(int kind) {
            super(kind, -1);
        }

        public Expr parse() {
            return AspectJParser.this.parsePcdTerminal();
        }
    }

    static class TypeNameAndId {
        public GenTypeName typeName;
        public NamePattern namePattern;

        TypeNameAndId() {
        }

        public String getId() {
            if (this.namePattern.getSimpleName() == null) {
                this.namePattern.showError("identifier expected");
            }
            return this.namePattern.getSimpleName();
        }
    }
}

