/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.crosscuts;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.aspectj.asm.views.EmacsViewManager;
import org.aspectj.compiler.base.ASTFixerPass;
import org.aspectj.compiler.base.AbstractCompilerPass;
import org.aspectj.compiler.base.AssignmentCheckerPass;
import org.aspectj.compiler.base.ByteCodeCleanupPass;
import org.aspectj.compiler.base.ByteCodeGenerator;
import org.aspectj.compiler.base.CanThrowWalker;
import org.aspectj.compiler.base.ClassExprPass;
import org.aspectj.compiler.base.CodeGenerator;
import org.aspectj.compiler.base.CompilerPass;
import org.aspectj.compiler.base.ErrorHandler;
import org.aspectj.compiler.base.FlowCheckerPass;
import org.aspectj.compiler.base.ForwardReferenceChecker;
import org.aspectj.compiler.base.FrameLocPass;
import org.aspectj.compiler.base.InitializerCollector;
import org.aspectj.compiler.base.InnerAccessFixer;
import org.aspectj.compiler.base.InnerInfoPass;
import org.aspectj.compiler.base.JavaCompiler;
import org.aspectj.compiler.base.LocalClassPass;
import org.aspectj.compiler.base.MemberClassMunger;
import org.aspectj.compiler.base.NameHygienePass;
import org.aspectj.compiler.base.RunJavacPass;
import org.aspectj.compiler.base.SpecChecker;
import org.aspectj.compiler.base.WalkerPass;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CodeDec;
import org.aspectj.compiler.base.ast.CompilationUnit;
import org.aspectj.compiler.base.ast.Decs;
import org.aspectj.compiler.base.ast.ScopeWalker;
import org.aspectj.compiler.base.ast.TypeDec;
import org.aspectj.compiler.base.parser.JavaParser;
import org.aspectj.compiler.base.parser.ParseException;
import org.aspectj.compiler.crosscuts.AdvicePlannerPass;
import org.aspectj.compiler.crosscuts.AdviceWeaver;
import org.aspectj.compiler.crosscuts.AspectJParser;
import org.aspectj.compiler.crosscuts.BuildAdvicePlannersPass;
import org.aspectj.compiler.crosscuts.Correspondences;
import org.aspectj.compiler.crosscuts.JoinPointCollector;
import org.aspectj.compiler.crosscuts.MixinImplementationPass;
import org.aspectj.compiler.crosscuts.PrivilegeFixer;
import org.aspectj.compiler.crosscuts.StaticJpPlannerPass;

public class AspectJCompiler
extends JavaCompiler {
    private Correspondences correspondences = new Correspondences(this);
    static /* synthetic */ Class class$org$aspectj$compiler$crosscuts$AspectJParser;

    public AspectJCompiler(ErrorHandler errorHandler) {
        super(errorHandler);
        this.scanner = class$org$aspectj$compiler$crosscuts$AspectJParser == null ? (class$org$aspectj$compiler$crosscuts$AspectJParser = AspectJCompiler.class$("org.aspectj.compiler.crosscuts.AspectJParser")) : class$org$aspectj$compiler$crosscuts$AspectJParser;
    }

    public AspectJCompiler() {
        this(null);
    }

    public JavaParser makeJavaParser() {
        return new AspectJParser(this);
    }

    public void addPass(CompilerPass pass) {
        this.addPass(pass, false);
    }

    public void addPass(CompilerPass pass, boolean exitOnErrors) {
        this.passes.add(pass);
        this.totalWorkEstimate += pass.getWorkEstimate();
        if (exitOnErrors) {
            this.passes.add(new ExitOnErrorsPass(this));
        }
    }

    protected void addPreSymbolPasses() {
        this.addPass(this.createParserPass(), true);
        this.addPass(new TypeGraphBuilderPass(this.getCompiler()));
        this.addPass(new SignatureBinderPass(this.getCompiler()));
        this.addPass(new BodyBinderPass(this.getCompiler()));
        this.addPass(new ForwardReferenceChecker(this.getCompiler()));
        this.addPass(new InnerInfoPass(this.getCompiler()));
        this.addPass(new AssignmentCheckerPass(this.getCompiler()));
        this.addPass(new SpecChecker(this.getCompiler()), true);
        this.addPass(new BuildAdvicePlannersPass(this.getCompiler()), true);
        this.addPass(new InitializerCollector(this.getCompiler(), false));
        this.addPass(new JoinPointCollectorPass(this.getCompiler()), true);
        this.addPass(new StaticJpPlannerPass(this.getCompiler()));
        this.addPass(new FlowCheckerPass(this.getCompiler()));
        this.addPass(new ThrowCheckerPass(this.getCompiler()));
        this.addPass(new AdvicePlannerPass(this.getCompiler()), true);
        this.addPass(new AdviceWeaver(this.getCompiler()), true);
    }

    protected void addPostSymbolPasses() {
        this.addPass(new AbstractCompilerPass(this.getCompiler()){

            public String getDisplayName() {
                return "emacssym ";
            }

            public void transformWorld() {
                if (super.getCompiler().getOptions().emacssym) {
                    new EmacsViewManager().externalizeStructureView((AspectJCompiler)super.getCompiler());
                }
            }
        });
        this.addPass(new MixinImplementationPass(this.getCompiler()));
        this.addPass(new PrivilegeFixer(this.getCompiler(), true));
        this.addPass(new ASTFixerPass(this.getCompiler()), true);
        this.addPass(new InitializerCollector(this.getCompiler(), true));
        this.addPass(new LocalClassPass(this.getCompiler()), true);
    }

    protected void addSourceGenerationPasses() {
        this.addPass(new NameHygienePass(this.getCompiler()), true);
        this.addPass(new CodeGenerator(this.getCompiler()), true);
        this.addPass(new RunJavacPass(this.getCompiler()));
    }

    protected void addBytecodeGenerationPasses() {
        this.addPass(new MemberClassMunger(this.getCompiler()));
        if (this.getOptions().bcgverbose) {
            this.addPass(new CodeGenerator(this.getCompiler()));
        }
        this.addPass(new ClassExprPass(this.getCompiler()));
        this.addPass(new InnerAccessFixer(this.getCompiler()));
        this.addPass(new NameHygienePass(this.getCompiler()), true);
        this.addPass(new ByteCodeCleanupPass(this.getCompiler()));
        this.addPass(new FrameLocPass(this.getCompiler()));
        this.addPass(new ByteCodeGenerator(this.getCompiler()));
    }

    protected void addPasses() {
        this.passes = new ArrayList();
        this.addPreSymbolPasses();
        this.addPostSymbolPasses();
        if (this.getOptions().usejavac || this.getOptions().preprocess) {
            this.addSourceGenerationPasses();
        } else {
            this.addBytecodeGenerationPasses();
        }
    }

    protected JavaCompiler getCompiler() {
        return this;
    }

    public Correspondences getCorrespondences() {
        return this.correspondences;
    }

    public String getBuildConfigFile() {
        return null;
    }

    protected AbstractCompilerPass createParserPass() {
        return new ParserPass(this.getCompiler());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static class ThrowCheckerPass
    extends WalkerPass {
        public ThrowCheckerPass(JavaCompiler jc) {
            super(jc);
        }

        public String getDisplayName() {
            return "checking throws";
        }

        public ASTObject process(ASTObject node) {
            if (node instanceof CodeDec) {
                CanThrowWalker.checkThrows((CodeDec)node);
            }
            return super.process(node);
        }
    }

    protected static class JoinPointCollectorPass
    extends AbstractCompilerPass {
        public JoinPointCollectorPass(JavaCompiler jc) {
            super(jc);
        }

        public String getDisplayName() {
            return "collect join point shadows";
        }

        public void transform(TypeDec td) {
            new JoinPointCollector(td).collect();
        }
    }

    protected static class BodyBinderPass
    extends AbstractCompilerPass {
        public BodyBinderPass(JavaCompiler jc) {
            super(jc);
        }

        public String getDisplayName() {
            return "bind names in bodies";
        }

        public void transform(CompilationUnit cu) {
            new ScopeWalker(this.getCompiler()).process(cu);
        }
    }

    protected static class SignatureBinderPass
    extends WalkerPass {
        public SignatureBinderPass(JavaCompiler jc) {
            super(jc);
        }

        public String getDisplayName() {
            return "resolve type signatures";
        }

        public void transform(CompilationUnit cu) {
            cu.buildSignatures();
        }

        public void transformWorld() {
            super.transformWorld();
            this.getWorld().collectedTypeDecPlanners = true;
        }
    }

    protected static class TypeGraphBuilderPass
    extends AbstractCompilerPass {
        public TypeGraphBuilderPass(JavaCompiler jc) {
            super(jc);
        }

        public String getDisplayName() {
            return "build type graph";
        }

        public void transform(CompilationUnit cu) {
            cu.addTypesToTypeGraph();
        }
    }

    protected static class ParserPass
    extends AbstractCompilerPass {
        public ParserPass(JavaCompiler jc) {
            super(jc);
        }

        public String getDisplayName() {
            return "parse sources";
        }

        public double getWorkEstimate() {
            return 4.0;
        }

        public void transform(CompilationUnit cu) {
            this.getCompiler().showMessage("    parsing " + cu.getSourceFile());
            try {
                JavaParser parser = this.getCompiler().allocateParser();
                parser.parseInterfaceOnly = false;
                parser.interfaceParse(cu);
                this.getCompiler().freeParser(parser);
            }
            catch (ParseException pe) {
                if (this.getOptions().dumpstack) {
                    pe.printStackTrace();
                }
                this.getCompiler().showError(cu.getSourceFile(), pe.getLine(), pe.getColumn(), pe.getMessage());
            }
            catch (IOException e) {
                this.getCompiler().showError(null, e.toString());
            }
            Iterator j = cu.getDefinedTypes().iterator();
            while (j.hasNext()) {
                TypeDec td = (TypeDec)j.next();
                this.getWorld().addSourceType(td.getType());
                this.addInnerTypes(td);
            }
        }

        private void addInnerTypes(TypeDec typeDec) {
            Decs body = typeDec.getBody();
            int i = 0;
            while (i < body.size()) {
                if (body.get(i) instanceof TypeDec) {
                    TypeDec innerTypeDec = (TypeDec)body.get(i);
                    this.getTypeManager().addType(innerTypeDec.getType());
                    this.addInnerTypes(innerTypeDec);
                }
                ++i;
            }
        }
    }

    protected class ExitOnErrorsPass
    extends AbstractCompilerPass {
        public ExitOnErrorsPass(JavaCompiler jc) {
            super(jc);
        }

        public String getDisplayName() {
            return null;
        }

        public double getWorkEstimate() {
            return 0.0;
        }

        public void transformWorld() {
            AspectJCompiler.this.errorHandler.exitOnErrors();
        }
    }
}

