/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.aspectj.compiler.base.CompilerObject;
import org.aspectj.compiler.base.JavaCompiler;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.ArrayExpr;
import org.aspectj.compiler.base.ast.ArrayInitializer;
import org.aspectj.compiler.base.ast.ArrayTypeD;
import org.aspectj.compiler.base.ast.AssertStmt;
import org.aspectj.compiler.base.ast.AssignExpr;
import org.aspectj.compiler.base.ast.AssignableExpr;
import org.aspectj.compiler.base.ast.BinopExpr;
import org.aspectj.compiler.base.ast.BlockStmt;
import org.aspectj.compiler.base.ast.BooleanLiteralExpr;
import org.aspectj.compiler.base.ast.BreakStmt;
import org.aspectj.compiler.base.ast.CallExpr;
import org.aspectj.compiler.base.ast.CastExpr;
import org.aspectj.compiler.base.ast.CatchClause;
import org.aspectj.compiler.base.ast.CatchClauses;
import org.aspectj.compiler.base.ast.ClassDec;
import org.aspectj.compiler.base.ast.ClassExpr;
import org.aspectj.compiler.base.ast.CodeBody;
import org.aspectj.compiler.base.ast.CompilationUnit;
import org.aspectj.compiler.base.ast.ConstructorBody;
import org.aspectj.compiler.base.ast.ConstructorCallExpr;
import org.aspectj.compiler.base.ast.ConstructorDec;
import org.aspectj.compiler.base.ast.ContinueStmt;
import org.aspectj.compiler.base.ast.Dec;
import org.aspectj.compiler.base.ast.Decs;
import org.aspectj.compiler.base.ast.DoStmt;
import org.aspectj.compiler.base.ast.DummySourceLocation;
import org.aspectj.compiler.base.ast.EmptyExpr;
import org.aspectj.compiler.base.ast.EmptyStmt;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.ExprStmt;
import org.aspectj.compiler.base.ast.Exprs;
import org.aspectj.compiler.base.ast.FieldDec;
import org.aspectj.compiler.base.ast.ForStmt;
import org.aspectj.compiler.base.ast.FormalDec;
import org.aspectj.compiler.base.ast.Formals;
import org.aspectj.compiler.base.ast.IfStmt;
import org.aspectj.compiler.base.ast.Import;
import org.aspectj.compiler.base.ast.Imports;
import org.aspectj.compiler.base.ast.InitializerDec;
import org.aspectj.compiler.base.ast.InstanceofExpr;
import org.aspectj.compiler.base.ast.InterfaceDec;
import org.aspectj.compiler.base.ast.LabeledStmt;
import org.aspectj.compiler.base.ast.MethodDec;
import org.aspectj.compiler.base.ast.MinusOpExpr;
import org.aspectj.compiler.base.ast.Modifiers;
import org.aspectj.compiler.base.ast.NewArrayExpr;
import org.aspectj.compiler.base.ast.NewInnerInstanceExpr;
import org.aspectj.compiler.base.ast.NewInstanceExpr;
import org.aspectj.compiler.base.ast.NullExpr;
import org.aspectj.compiler.base.ast.ParenExpr;
import org.aspectj.compiler.base.ast.PostfixExpr;
import org.aspectj.compiler.base.ast.PrefixExpr;
import org.aspectj.compiler.base.ast.QualifiedSuperExpr;
import org.aspectj.compiler.base.ast.QualifiedThisExpr;
import org.aspectj.compiler.base.ast.ReturnStmt;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Stmt;
import org.aspectj.compiler.base.ast.Stmts;
import org.aspectj.compiler.base.ast.SuperExpr;
import org.aspectj.compiler.base.ast.SwitchClause;
import org.aspectj.compiler.base.ast.SwitchClauses;
import org.aspectj.compiler.base.ast.SwitchStmt;
import org.aspectj.compiler.base.ast.SynchronizedStmt;
import org.aspectj.compiler.base.ast.TextSourceLocation;
import org.aspectj.compiler.base.ast.ThisExpr;
import org.aspectj.compiler.base.ast.ThrowStmt;
import org.aspectj.compiler.base.ast.TriTestExpr;
import org.aspectj.compiler.base.ast.TryCatchStmt;
import org.aspectj.compiler.base.ast.TryFinallyStmt;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.TypeD;
import org.aspectj.compiler.base.ast.TypeDec;
import org.aspectj.compiler.base.ast.TypeDs;
import org.aspectj.compiler.base.ast.TypeExpr;
import org.aspectj.compiler.base.ast.UnopExpr;
import org.aspectj.compiler.base.ast.VarDec;
import org.aspectj.compiler.base.ast.WhileStmt;
import org.aspectj.compiler.base.cst.Name;
import org.aspectj.compiler.base.cst.UnresolvedExpr;
import org.aspectj.compiler.base.cst.UnresolvedFieldAccessExpr;
import org.aspectj.compiler.base.cst.UnresolvedNameTypeD;
import org.aspectj.compiler.base.parser.JavaConstants;
import org.aspectj.compiler.base.parser.JavaTokenizer;
import org.aspectj.compiler.base.parser.ParseException;
import org.aspectj.compiler.base.parser.Token;

public class JavaParser
extends CompilerObject
implements JavaConstants {
    public boolean parseInterfaceOnly = false;
    protected boolean inInterface;
    private JavaTokenizer tokenSource = new JavaTokenizer(this.getCompiler());
    private static final int LOOKAHEAD_BUFFER_SIZE = 256;
    private static final int LOOKAHEAD_MASK = 255;
    private Token[] lookaheadBuffer = new Token[256];
    public int currentIndex = 0;
    private int lastValidIndex = -1;
    private int savedIndex = -1;
    private Stack enclosingTypeDecs = new Stack();
    protected Set keywords = new HashSet<String>(Arrays.asList("abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "intstanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while", "true", "false", "null", "instanceof"));
    private Map primitiveTypeNames = new HashMap();
    protected static Map modifiers = new HashMap();
    protected Map decParsers;
    protected Map stmtDecParsers;
    protected Map stmtParsers;
    protected SourceLocation dummySource;
    private static final int MAX_TOKEN_KINDS = 512;
    private InfixOperator[] infixOperators;
    private PrefixOperator[] prefixOperators;
    protected ExprParser exprParser;
    protected CompilationUnit currentCompilationUnit;
    private boolean inConstructor;

    public JavaParser(JavaCompiler compiler) {
        super(compiler);
        this.primitiveTypeNames.put("int", this.getTypeManager().intType);
        this.primitiveTypeNames.put("byte", this.getTypeManager().byteType);
        this.primitiveTypeNames.put("short", this.getTypeManager().shortType);
        this.primitiveTypeNames.put("long", this.getTypeManager().longType);
        this.primitiveTypeNames.put("double", this.getTypeManager().doubleType);
        this.primitiveTypeNames.put("float", this.getTypeManager().floatType);
        this.primitiveTypeNames.put("char", this.getTypeManager().charType);
        this.primitiveTypeNames.put("boolean", this.getTypeManager().booleanType);
        this.primitiveTypeNames.put("void", this.getTypeManager().voidType);
        this.decParsers = new HashMap();
        this.decParsers.put("class", new ClassDecParser());
        this.decParsers.put("interface", new InterfaceDecParser());
        this.stmtDecParsers = new HashMap();
        this.stmtDecParsers.put("class", new ClassDecParser());
        this.stmtDecParsers.put("interface", new InterfaceDecParser());
        this.stmtParsers = new HashMap();
        this.stmtParsers.put("if", new IfStmtParser());
        this.stmtParsers.put("while", new WhileStmtParser());
        this.stmtParsers.put("do", new DoStmtParser());
        this.stmtParsers.put("for", new ForStmtParser());
        this.stmtParsers.put("synchronized", new SynchronizedStmtParser());
        this.stmtParsers.put("try", new TryStmtParser());
        this.stmtParsers.put("switch", new SwitchStmtParser());
        this.stmtParsers.put("break", new BreakStmtParser());
        this.stmtParsers.put("continue", new ContinueStmtParser());
        this.stmtParsers.put("return", new ReturnStmtParser());
        this.stmtParsers.put("throw", new ThrowStmtParser());
        this.stmtParsers.put("goto", new GotoStmtParser());
        this.dummySource = new DummySourceLocation(this.getCompiler());
        this.infixOperators = new InfixOperator[]{new QuestionOperator(200), new InfixOperator("||", 300), new InfixOperator("&&", 400), new InfixOperator("|", 500), new InfixOperator("^", 600), new InfixOperator("&", 700), new InfixOperator("==", 800), new InfixOperator("!=", 800), new InstanceOfOperator(900), new InfixOperator(">", 1000), new InfixOperator("<", 1000), new InfixOperator("<=", 1000), new InfixOperator(">=", 1000), new InfixOperator("<<", 1100), new InfixOperator(">>", 1100), new InfixOperator(">>>", 1100), new InfixOperator("+", 1200), new InfixOperator("-", 1200), new InfixOperator("*", 1300), new InfixOperator("/", 1300), new InfixOperator("%", 1300), new PostOperator("++", 4000), new PostOperator("--", 4000), new ArrayOperator(5000), new DotOperator(5000), new AssignOperator("=", 100), new AssignOperator("+=", 100), new AssignOperator("-=", 100), new AssignOperator("*=", 100), new AssignOperator("/=", 100), new AssignOperator("&=", 100), new AssignOperator("|=", 100), new AssignOperator("^=", 100), new AssignOperator("%=", 100), new AssignOperator("<<=", 100), new AssignOperator(">>=", 100), new AssignOperator(">>>=", 100)};
        this.prefixOperators = new PrefixOperator[]{new PrefixOperator("+", 2000), new MinusOperator(2000), new PrefixOperator("!", 3000), new PrefixOperator("~", 3000), new PreOperator("++", 2500), new PreOperator("--", 2500), new ParenOperator(1, true), new NewOperator(1), new TrueLiteral(), new FalseLiteral(), new NullLiteral(), new ThisLiteral(), new SuperLiteral(), new IdentifierOp()};
        this.exprParser = new ExprParser(this.prefixOperators, this.infixOperators);
        this.inConstructor = false;
        if (compiler.getOptions().source.equals("1.4")) {
            this.stmtParsers.put("assert", new AssertStmtParser());
            this.keywords.add("assert");
        }
    }

    public CompilationUnit interfaceParse(CompilationUnit cu) throws IOException {
        this.tokenSource.setSourceInfo(cu.getSourceInfo());
        this.currentCompilationUnit = cu;
        this.currentIndex = 0;
        this.lastValidIndex = -1;
        this.parseCompilationUnit();
        this.currentCompilationUnit.setScanned(true);
        return this.currentCompilationUnit;
    }

    private final void initTokenSource(int offset) {
        this.currentIndex = 0;
        this.lastValidIndex = -1;
        this.tokenSource.setOffset(offset);
    }

    public void cleanup(boolean fully) {
        this.tokenSource.cleanup(fully);
        int i = 0;
        while (i < 256) {
            this.lookaheadBuffer[i] = null;
            ++i;
        }
        this.lastValidIndex = -1;
    }

    private final Token getToken(int index) {
        while (index > this.lastValidIndex) {
            Token newToken;
            ++this.lastValidIndex;
            this.lookaheadBuffer[this.lastValidIndex & 0xFF] = newToken = this.tokenSource.getNextToken();
        }
        return this.lookaheadBuffer[index & 0xFF];
    }

    protected final void pushCurrentIndex() {
        this.savedIndex = this.currentIndex;
    }

    protected final void popCurrentIndex() {
        this.currentIndex = this.savedIndex;
    }

    public final void eatTopToken(int kind) {
        if (this.peekToken().kind != kind) {
            this.throwError(this.peekToken(), "expected " + JavaConstants.tokenImage[kind] + ", found " + this.peekToken().image);
        }
        ++this.currentIndex;
    }

    public final boolean maybeEatToken(int kind) {
        if (this.peekToken().kind == kind) {
            ++this.currentIndex;
            return true;
        }
        return false;
    }

    public final void eatTopToken() {
        ++this.currentIndex;
    }

    public final Token popToken(int kind) {
        return this.getToken(this.currentIndex++);
    }

    public final Token popToken() {
        return this.getToken(this.currentIndex++);
    }

    public final Token peekToken() {
        return this.getToken(this.currentIndex);
    }

    public final Token peekToken(int i) {
        return this.getToken(this.currentIndex + i);
    }

    public int scanTillMatched() {
        Token beginToken = this.peekToken();
        int kind = 24;
        if (beginToken.kind != 23) {
            this.throwError(beginToken, "internal error: expected '{'");
        }
        if (this.currentIndex != this.lastValidIndex) {
            this.throwError(beginToken, "internal error: lookahead of '{'");
        }
        this.eatTopToken();
        try {
            Token endToken = this.tokenSource.scanTillMatched(kind);
            ++this.lastValidIndex;
            this.lookaheadBuffer[this.lastValidIndex & 0xFF] = endToken;
            this.eatTopToken();
            return endToken.endPosition;
        }
        catch (Exception e) {
            this.showError(beginToken, "Unexpected end of file while looking matched close brace");
            return beginToken.endPosition;
        }
    }

    public void pushEnclosingTypeDec(TypeDec dec) {
        this.enclosingTypeDecs.push(dec);
    }

    public void popEnclosingTypeDec() {
        this.enclosingTypeDecs.pop();
    }

    public TypeDec peekEnclosingTypeDec() {
        if (this.enclosingTypeDecs.size() == 0) {
            return null;
        }
        return (TypeDec)this.enclosingTypeDecs.peek();
    }

    protected void parseIdMatchingEnclosingTypeName(String where) {
        String id;
        Token beginToken = this.peekToken();
        if (beginToken.kind == 68) {
            id = "new";
            this.popToken();
        } else {
            id = this.parseId();
        }
        if (id.equals(this.peekEnclosingTypeDec().getId())) {
            return;
        }
        this.throwError(beginToken, where + " \"" + id + "\" doesn't match enclosing type name \"" + this.peekEnclosingTypeDec().getId() + "\"");
    }

    public TypeD lookupPrimitiveTypeD(String name) {
        Type type = (Type)this.primitiveTypeNames.get(name);
        if (type == null) {
            return null;
        }
        return type.makeTypeD();
    }

    public final boolean isModifier(Token token) {
        return this.getModifier(token) != null;
    }

    public final Integer getModifier(Token token) {
        if (!this.isIdentifier(token)) {
            return null;
        }
        return (Integer)modifiers.get(token.image);
    }

    TypeDec maybeParseClassBody(TypeD superTypeD) {
        if (this.peekToken().kind == 23) {
            Token beginToken = this.peekToken();
            Modifiers mods = new Modifiers(this.makeSourceLocation(beginToken), 0);
            if (superTypeD != null) {
                superTypeD = (TypeD)superTypeD.copy();
            }
            ClassDec classDec = new ClassDec(this.dummySource, mods, "ANONYMOUS", superTypeD, null, null);
            classDec.setIsAnonymous();
            classDec.setLocal();
            Decs body = null;
            boolean oldInInterface = this.inInterface;
            try {
                this.inInterface = false;
                this.pushEnclosingTypeDec(classDec);
                body = this.parseDecs();
                Object var8_7 = null;
                this.inInterface = oldInInterface;
                this.popEnclosingTypeDec();
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                this.inInterface = oldInInterface;
                this.popEnclosingTypeDec();
                throw throwable;
            }
            classDec.setBody(body);
            classDec.setEnclosingTypeDec(this.peekEnclosingTypeDec());
            this.addContext((ASTObject)classDec, beginToken);
            return classDec;
        }
        return null;
    }

    public Expr parseCallExpr(Name name) {
        String id = name.getId();
        Name parentName = name.getParentName();
        Exprs args = this.parseExprs(22);
        this.eatTopToken(22);
        UnresolvedExpr expr = null;
        if (parentName != null) {
            parentName.clearParent();
            expr = new UnresolvedExpr(this.dummySource, parentName);
            expr.setSource(parentName);
        }
        if (id.equals("this")) {
            if (parentName != null) {
                this.throwError(null, "bad this");
            }
            return new ConstructorCallExpr(this.dummySource, null, false, args, null);
        }
        if (id.equals("super")) {
            if (parentName != null) {
                this.throwError(null, "bad super");
            }
            return new ConstructorCallExpr(this.dummySource, null, true, args, null);
        }
        return new CallExpr(this.dummySource, expr, id, args);
    }

    private Name buildName(Expr expr) {
        if (expr instanceof UnresolvedExpr) {
            return ((UnresolvedExpr)expr).getName();
        }
        return null;
    }

    private TypeD exprToTypeD(Expr lhs) {
        TypeD primTypeD;
        if (lhs instanceof TypeExpr) {
            return ((TypeExpr)lhs).getTypeD();
        }
        Name id = this.buildName(lhs);
        ASTObject ret = null;
        if (id == null) {
            return null;
        }
        if (id.getParentName() == null && (primTypeD = this.lookupPrimitiveTypeD(id.getId())) != null) {
            ret = primTypeD;
        }
        id.clearParent();
        if (ret == null) {
            ret = new UnresolvedNameTypeD(this.dummySource, id);
        }
        ret.setSource(lhs);
        return ret;
    }

    private TypeD exprToTypeD(Expr lhs, String name) {
        TypeD ret = this.exprToTypeD(lhs);
        if (ret == null) {
            this.throwError(this.peekToken(-2), "type required before " + name);
        }
        this.addContext((ASTObject)ret, lhs);
        return ret;
    }

    AssignableExpr checkAssignable(Expr expr) {
        if (expr instanceof AssignableExpr) {
            return (AssignableExpr)expr;
        }
        if (expr instanceof ParenExpr) {
            return this.checkAssignable(((ParenExpr)expr).getExpr());
        }
        expr.showError("invalid lhs for assign: " + expr.getClass().getName());
        return null;
    }

    public final boolean eatKeyword(String keyword, boolean isMaybe) {
        Token topToken = this.peekToken();
        if (topToken.isIdentifier() && topToken.image.equals(keyword)) {
            this.eatTopToken();
            return true;
        }
        if (!isMaybe) {
            this.throwError(topToken, "expected keyword: '" + keyword + "'");
        }
        return false;
    }

    public final boolean peekKeyword(String keyword) {
        Token topToken = this.peekToken();
        return topToken.isIdentifier() && topToken.image.equals(keyword);
    }

    public final boolean eatKeyword(String keyword) {
        return this.eatKeyword(keyword, false);
    }

    public final boolean maybeEatKeyword(String keyword) {
        return this.eatKeyword(keyword, true);
    }

    public final boolean isIdentifier(Token token) {
        return token.isIdentifier() && !token.image.equals("new");
    }

    public final boolean isIdentifierOrNew(Token token) {
        return token.isIdentifier();
    }

    public final boolean isKeyword(Token token) {
        return this.keywords.contains(token.image);
    }

    private CompilationUnit parseCompilationUnit() {
        Token beginToken0 = this.peekToken();
        Decs decs = new Decs(this.dummySource);
        this.currentCompilationUnit.setDecs(decs);
        if (this.maybeEatKeyword("package")) {
            String name = this.parseExtendedString(false);
            if (name != null) {
                this.currentCompilationUnit.setPackageName(name);
            } else {
                this.showError(this.peekToken(), "package name expected");
            }
            this.eatTopToken(27);
        }
        Token beginImportsToken = this.peekToken();
        Imports imports = new Imports(this.dummySource);
        while (this.peekKeyword("import")) {
            imports.add(this.parseImport());
        }
        this.addContext((ASTObject)imports, beginImportsToken);
        while (this.peekToken().kind != 0) {
            if (this.peekToken().kind == 27) {
                this.eatTopToken();
                continue;
            }
            Token beginToken = this.peekToken();
            Dec dec = (Dec)this.parseTopDec(null);
            this.addContext((ASTObject)dec, beginToken);
            if (dec instanceof TypeDec) {
                decs.add(dec);
                continue;
            }
            this.throwError(null, "expected import, package, type or aspect declaration");
        }
        this.addContext((ASTObject)decs, beginToken0);
        this.currentCompilationUnit.setImports(imports);
        this.addContext((ASTObject)this.currentCompilationUnit, beginToken0);
        return this.currentCompilationUnit;
    }

    public Import parseImport() {
        Token beginToken = this.peekToken();
        this.eatKeyword("import");
        Name name = this.parseExtendedName();
        boolean star = false;
        if (this.peekToken((int)0).kind == 29 && this.peekToken((int)1).kind == 47) {
            this.eatTopToken();
            this.eatTopToken();
            star = true;
        }
        this.eatTopToken(27);
        return new Import(this.makeSourceLocation(beginToken), name, star);
    }

    protected boolean eatModifiers() {
        Token token;
        while (this.isModifier(token = this.peekToken())) {
            this.eatTopToken();
        }
        return true;
    }

    public void parseNoModifiers() {
        this.parseModifiers(0);
    }

    public Modifiers parseModifiers(int legalModifiers) {
        Integer ivalue;
        Token beginToken = this.peekToken();
        int modifierValue = 0;
        while ((ivalue = this.getModifier(this.peekToken())) != null) {
            int value = ivalue;
            if ((legalModifiers & value) != value) {
                this.showError(this.peekToken(), "modifier " + this.peekToken().image + " not allowed here");
            } else if ((modifierValue & value) != 0) {
                this.showError(this.peekToken(), "repeated modifier");
            } else {
                modifierValue |= value;
            }
            this.eatTopToken();
        }
        return new Modifiers(this.makeSourceLocation(beginToken), modifierValue);
    }

    /*
     * WARNING - void declaration
     */
    public TypeDs parseTypeDs() {
        TypeD nameTypeD;
        Token beginToken = this.peekToken();
        ArrayList<void> names = null;
        while ((nameTypeD = this.parseTypeD()) != null) {
            void var2_3;
            if (names == null) {
                names = new ArrayList<void>();
            }
            names.add(var2_3);
            if (this.peekToken().kind != 28) break;
            this.eatTopToken();
        }
        if (names == null) {
            return null;
        }
        TypeDs ret = new TypeDs(this.dummySource, names.toArray(new TypeD[0]));
        this.addContext((ASTObject)ret, beginToken);
        return ret;
    }

    public String parseIdPattern() {
        if (this.maybeEatToken(47)) {
            return "*";
        }
        return this.parseId();
    }

    protected boolean eatIdentifier(boolean onlyDec) {
        if (!this.isIdentifier(this.peekToken())) {
            return false;
        }
        this.eatTopToken();
        return true;
    }

    public boolean lookaheadVarDes() {
        this.pushCurrentIndex();
        this.eatModifiers();
        boolean isVarDes = this.eatModifiers() && this.eatTypeD() && this.eatIdentifier(true);
        this.popCurrentIndex();
        return isVarDes;
    }

    public Name parseExtendedName() {
        if (!this.isSimpleIdentifier(this.peekToken())) {
            return null;
        }
        return this.parseExtendedName(null);
    }

    public boolean isSimpleIdentifier(Token t) {
        return t.isIdentifier() && (this.lookupPrimitiveTypeD(t.image) != null || !this.isKeyword(t));
    }

    public boolean inConstructor() {
        return this.inConstructor;
    }

    public Name parseExtendedName(Name parentName) {
        Token beginToken = this.peekToken();
        Name name = new Name(this.dummySource, parentName, this.parseId());
        this.addContext((ASTObject)name, beginToken);
        if (this.peekToken((int)0).kind == 29 && this.isSimpleIdentifier(this.peekToken(1))) {
            this.eatTopToken();
            return this.parseExtendedName(name);
        }
        return name;
    }

    public String parseExtendedString(boolean allowStar) {
        if (!this.isIdentifier(this.peekToken())) {
            return null;
        }
        StringBuffer buf = new StringBuffer(this.parseId());
        while (this.peekToken().kind == 29) {
            this.eatTopToken();
            buf.append(".");
            if (allowStar && this.peekToken().kind == 47) {
                this.eatTopToken();
                buf.append("*");
                continue;
            }
            buf.append(this.parseId());
        }
        return buf.toString();
    }

    public TypeD parseNameTypeD() {
        Token beginToken = this.peekToken();
        Name name = this.parseExtendedName();
        if (name == null) {
            this.throwError(null, "name expected");
        }
        UnresolvedNameTypeD ret = new UnresolvedNameTypeD(this.dummySource, name);
        this.addContext((ASTObject)ret, beginToken);
        return ret;
    }

    public TypeD addBracketsToTypeD(TypeD typeD) {
        while (this.peekToken().kind == 25 && this.peekToken((int)1).kind == 26) {
            this.eatTopToken();
            this.eatTopToken();
            TypeD oldTypeD = typeD;
            typeD = new ArrayTypeD(this.dummySource, typeD);
            this.addContext((ASTObject)typeD, oldTypeD);
        }
        return typeD;
    }

    public TypeD parseTypeD() {
        Token beginToken = this.peekToken();
        TypeD typeD = this.lookupPrimitiveTypeD(beginToken.image);
        if (typeD != null) {
            this.eatTopToken();
        } else {
            typeD = this.parseNameTypeD();
        }
        this.addContext((ASTObject)typeD, beginToken);
        typeD = this.addBracketsToTypeD(typeD);
        return typeD;
    }

    protected boolean eatTypeD() {
        if (!this.isSimpleIdentifier(this.peekToken())) {
            return false;
        }
        this.eatTopToken();
        while (this.peekToken().kind == 29) {
            this.eatTopToken();
            if (this.peekToken().kind == 29) continue;
            if (!this.isSimpleIdentifier(this.peekToken())) {
                --this.currentIndex;
                return true;
            }
            this.eatTopToken();
        }
        while (this.peekToken().kind == 25 && this.peekToken((int)1).kind == 26) {
            this.eatTopToken();
            this.eatTopToken();
        }
        return true;
    }

    public FormalDec parseFormal() {
        Token beginToken = this.peekToken();
        Modifiers modifiers = this.parseModifiers(16);
        TypeD typeD = this.parseTypeD();
        String id = this.parseId();
        typeD = this.addBracketsToTypeD(typeD);
        FormalDec ret = new FormalDec(this.dummySource, modifiers, typeD, id, null);
        this.addContext((ASTObject)ret, beginToken);
        return ret;
    }

    public Formals parseFormals() {
        Token beginToken = this.peekToken();
        this.eatTopToken(21);
        Formals ret = new Formals(this.dummySource);
        if (this.peekToken().kind == 22) {
            this.eatTopToken();
            this.addContext((ASTObject)ret, beginToken);
            return ret;
        }
        while (true) {
            FormalDec formal = this.parseFormal();
            ret.add(formal);
            Token t = this.popToken();
            if (t.kind == 22) break;
            if (t.kind == 28) continue;
            this.throwError(t, "parsing formals");
        }
        this.addContext((ASTObject)ret, beginToken);
        return ret;
    }

    public BlockStmt parseOptionalBlockStmt() {
        if (this.peekToken().kind == 27) {
            this.eatTopToken();
            return null;
        }
        return this.parseBlockStmt();
    }

    public Stmts parseStmts(int endToken) {
        Token beginToken = this.peekToken();
        Stmts stmts = new Stmts(this.dummySource);
        while (this.peekToken().kind != endToken) {
            stmts.add(this.parseStmt());
        }
        this.addContext((ASTObject)stmts, beginToken);
        this.eatTopToken(endToken);
        return stmts;
    }

    public BlockStmt parseBlockStmt() {
        Token beginToken = this.peekToken();
        this.eatTopToken(23);
        Stmts stmts = this.parseStmts(24);
        BlockStmt ret = new BlockStmt(this.dummySource, stmts);
        this.addContext((ASTObject)ret, beginToken);
        return ret;
    }

    public CodeBody parseOptionalCodeBody() {
        Token beginToken = this.peekToken();
        if (this.maybeEatToken(27)) {
            return null;
        }
        return this.parseCodeBody();
    }

    public CodeBody parseCodeBodyFully() {
        boolean oldParseInterfaceOnly = this.parseInterfaceOnly;
        this.parseInterfaceOnly = false;
        CodeBody body = null;
        try {
            body = this.parseCodeBody();
            Object var4_3 = null;
            this.parseInterfaceOnly = oldParseInterfaceOnly;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.parseInterfaceOnly = oldParseInterfaceOnly;
            throw throwable;
        }
        return body;
    }

    public CodeBody parseCodeBody() {
        Token beginToken = this.peekToken();
        this.eatTopToken(23);
        Stmts stmts = this.parseStmts(24);
        CodeBody ret = new CodeBody(this.dummySource, stmts, true);
        ret.setParsed(true);
        this.addContext((ASTObject)ret, beginToken);
        return ret;
    }

    public ConstructorBody parseConstructorBody() {
        Stmt stmt;
        Token beginToken = this.peekToken();
        if (this.maybeEatToken(27)) {
            this.showError(beginToken, "constructor must have a body");
            return null;
        }
        this.eatTopToken(23);
        ConstructorCallExpr constructorCall = null;
        Token firstToken = this.peekToken();
        if (firstToken.image.equals("this") || firstToken.image.equals("super")) {
            boolean isSuper = firstToken.image.equals("super");
            if (this.peekToken((int)1).kind == 21) {
                this.eatTopToken();
                constructorCall = new ConstructorCallExpr(this.dummySource, null, isSuper, this.parseParenExprs(), null);
                this.addContext((ASTObject)constructorCall, firstToken);
            }
        }
        this.inConstructor = true;
        Stmts stmts = this.parseStmts(24);
        this.inConstructor = false;
        if (constructorCall == null && stmts.size() > 0 && (stmt = stmts.get(0)) instanceof ExprStmt && ((ExprStmt)stmt).getExpr() instanceof ConstructorCallExpr) {
            constructorCall = (ConstructorCallExpr)((ExprStmt)stmt).getExpr();
            stmts.remove(0);
        }
        ConstructorBody ret = new ConstructorBody(this.dummySource, stmts, constructorCall, true);
        ret.setParsed(true);
        this.addContext((ASTObject)ret, beginToken);
        return ret;
    }

    public Decs parseDecs() {
        return this.parseDecs(null);
    }

    public Decs parseDecs(Map extraDecParsers) {
        Token beginToken = this.peekToken();
        this.eatTopToken(23);
        Decs decs = new Decs(this.dummySource);
        while (this.peekToken().kind != 24) {
            if (this.peekToken().kind == 27) {
                this.eatTopToken();
                continue;
            }
            Token decBeginToken = this.peekToken();
            Stmt dec = this.parseStmt(extraDecParsers, true, true);
            this.addContext((ASTObject)dec, decBeginToken);
            if (dec instanceof Dec) {
                decs.add((Dec)dec);
                continue;
            }
            if (dec instanceof Decs) {
                decs.addAll((Decs)dec);
                continue;
            }
            this.throwError(decBeginToken, "expected declaration");
            return null;
        }
        this.eatTopToken(24);
        this.addContext((ASTObject)decs, beginToken);
        return decs;
    }

    public TypeDs parseThrows() {
        if (this.maybeEatKeyword("throws")) {
            return this.parseTypeDs();
        }
        return null;
    }

    public InitializerDec parseInitializerDec() {
        int legalModifiers = 8;
        Token beginToken = this.peekToken();
        Modifiers modifiers = this.parseModifiers(legalModifiers);
        Formals formals = new Formals(this.dummySource);
        this.addContext((ASTObject)formals, beginToken);
        TypeDs _throws = new TypeDs(this.dummySource);
        this.addContext((ASTObject)_throws, beginToken);
        return new InitializerDec(this.dummySource, modifiers, formals, _throws, this.parseOptionalCodeBody());
    }

    public Dec parseConstructorDec() {
        int legalModifiers = 7;
        Token beginToken = this.peekToken();
        if (this.inInterface) {
            this.showError(beginToken, "constructor not allowed in interface");
        }
        Modifiers modifiers = this.parseModifiers(legalModifiers);
        this.parseIdMatchingEnclosingTypeName("constructor name");
        Formals formals = this.parseFormals();
        TypeDs _throws = this.parseThrows();
        return new ConstructorDec(this.dummySource, modifiers, formals, _throws, this.parseConstructorBody());
    }

    public Dec parseMethodDec() {
        int legalModifiers = this.inInterface ? 1025 : 3391;
        Modifiers modifiers = this.parseModifiers(legalModifiers);
        if (this.inInterface) {
            modifiers.setAbstract(true);
            modifiers.setPublic(true);
        }
        TypeD typeD = this.parseTypeD();
        String id = this.parseId();
        Formals formals = this.parseFormals();
        typeD = this.addBracketsToTypeD(typeD);
        TypeDs _throws = this.parseThrows();
        return new MethodDec(this.dummySource, modifiers, typeD, id, formals, _throws, this.parseOptionalCodeBody());
    }

    public Stmt parseVarDec() {
        return this.parseVarDec(false);
    }

    public Stmt parseFieldDec() {
        return this.parseVarDec(true);
    }

    public Stmt parseVarDec(boolean isField) {
        int legalModifiers = isField ? (this.inInterface ? 25 : 223) : 16;
        Token beginToken = this.peekToken();
        Modifiers modifiers = this.parseModifiers(legalModifiers);
        if (this.inInterface) {
            modifiers.setPublic(true);
            modifiers.setStatic(true);
        }
        TypeD baseTypeD = this.parseTypeD();
        Decs decs = null;
        VarDec dec = null;
        while (true) {
            String id = this.parseId();
            TypeD typeD = baseTypeD;
            Expr initializer = null;
            typeD = this.addBracketsToTypeD(typeD);
            Token endToken = this.popToken();
            if (endToken.kind == 30) {
                initializer = typeD instanceof ArrayTypeD && this.peekToken().kind == 23 ? this.parseArrayInitializer() : this.parseExpr();
                endToken = this.popToken();
            }
            dec = isField ? new FieldDec(this.dummySource, (Modifiers)modifiers.copy(), typeD, id, initializer) : new VarDec(this.dummySource, (Modifiers)modifiers.copy(), typeD, id, initializer);
            this.addContext((ASTObject)dec, beginToken);
            if (endToken.kind == 27) {
                if (decs == null) break;
                decs.add(dec);
                break;
            }
            if (endToken.kind == 28) {
                if (decs == null) {
                    decs = new Decs(this.dummySource, dec);
                } else {
                    decs.add(dec);
                }
                baseTypeD = (TypeD)baseTypeD.copy();
                continue;
            }
            this.throwError(endToken, "expected ',' or ';'");
        }
        if (decs != null) {
            return decs;
        }
        return dec;
    }

    public String parseAnyId() {
        Token token = this.popToken();
        if (!this.isIdentifier(token)) {
            this.throwError(token, "identifier expected");
        }
        return token.image;
    }

    public String parseId() {
        Token token = this.popToken();
        if (!this.isIdentifier(token) || this.isKeyword(token)) {
            this.throwError(token, "identifier expected");
        }
        return token.image;
    }

    public String parseIdOrKeywords_this_super_class() {
        Token token = this.popToken();
        if (!(this.isIdentifier(token) && !this.isKeyword(token) || token.image.equals("this") || token.image.equals("super") || token.image.equals("class"))) {
            this.throwError(token, "identifier expected");
        }
        return token.image;
    }

    public FormalDec parseParenFormal() {
        this.eatTopToken(21);
        FormalDec formal = this.parseFormal();
        this.eatTopToken(22);
        return formal;
    }

    public Exprs parseExprs(int stopKind) {
        Token beginToken = this.peekToken();
        Exprs exprs = new Exprs(this.dummySource);
        if (beginToken.kind != stopKind) {
            while (true) {
                Expr expr = this.parseExpr();
                exprs.add(expr);
                if (this.peekToken().kind != 28) break;
                this.eatTopToken();
            }
        }
        this.addContext((ASTObject)exprs, beginToken);
        return exprs;
    }

    public Exprs parseParenExprs() {
        this.eatTopToken(21);
        Exprs exprs = this.parseExprs(22);
        this.eatTopToken(22);
        return exprs;
    }

    public ArrayInitializer parseArrayInitializer() {
        this.eatTopToken(23);
        Exprs exprs = new Exprs(this.dummySource);
        if (this.maybeEatToken(24)) {
            return new ArrayInitializer(this.dummySource, exprs);
        }
        do {
            Expr expr;
            if (this.peekToken().kind == 23) {
                expr = this.parseArrayInitializer();
            } else {
                if (this.maybeEatToken(28)) {
                    if (exprs.size() > 0 || !this.getCompiler().getOptions().lenient) {
                        this.showError(this.peekToken(-1), "too many commas");
                    }
                    break;
                }
                expr = this.parseExpr();
            }
            exprs.add(expr);
        } while (this.maybeEatToken(28) && this.peekToken().kind != 24);
        this.eatTopToken(24);
        return new ArrayInitializer(this.dummySource, exprs);
    }

    public Exprs parseArrayDimExprs() {
        Exprs exprs = new Exprs(this.dummySource);
        while (this.peekToken().kind == 25) {
            this.eatTopToken();
            if (this.peekToken().kind == 26) {
                exprs.add(new EmptyExpr(this.dummySource));
            } else {
                exprs.add(this.parseExpr());
            }
            this.eatTopToken(26);
        }
        return exprs;
    }

    public Expr parseParenExpr() {
        this.eatTopToken(21);
        Expr expr = this.parseExpr();
        this.eatTopToken(22);
        return expr;
    }

    public Expr parseExpr() {
        return this.parseExpr(false);
    }

    public Expr parseExpr(boolean allowNulls) {
        Expr ret = this.exprParser.parse();
        if (!allowNulls && ret == null) {
            this.throwError(null, "expression required");
        }
        return ret;
    }

    protected String grabFormalComment(Token token) {
        while ((token = token.specialToken) != null) {
            if (token.kind != 10) continue;
            return token.image;
        }
        return null;
    }

    protected void addComments(ASTObject ast, Token beginToken) {
        String comment;
        if (ast instanceof Dec && (comment = this.grabFormalComment(beginToken)) != null) {
            ast.setFormalComment(comment);
        }
    }

    protected SourceLocation makeSourceLocation(Token beginToken) {
        Token endToken = this.peekToken(-1);
        if (endToken == null) {
            endToken = beginToken;
        }
        TextSourceLocation ret = new TextSourceLocation(this.currentCompilationUnit, beginToken.startPosition, endToken.endPosition);
        return ret;
    }

    protected SourceLocation makeSourceLocation(SourceLocation beginSourceLoc) {
        Token endToken = this.peekToken(-1);
        int startPosition = -1;
        if (beginSourceLoc != null) {
            startPosition = beginSourceLoc.getStartPosition();
        }
        TextSourceLocation ret = new TextSourceLocation(this.currentCompilationUnit, startPosition, endToken.endPosition);
        return ret;
    }

    protected void addContext(ASTObject ast, ASTObject beginAST) {
        if (ast == null) {
            return;
        }
        ast.setSourceLocation(this.makeSourceLocation(beginAST.getSourceLocation()));
    }

    protected void addContext(ASTObject ast, Token beginToken) {
        if (ast == null) {
            return;
        }
        ast.setSourceLocation(this.makeSourceLocation(beginToken));
        this.addComments(ast, beginToken);
    }

    public Stmt parseStmt() {
        Token beginToken = this.peekToken();
        Stmt ret = this.parseStmt(null, false, false);
        this.addContext((ASTObject)ret, beginToken);
        return ret;
    }

    public boolean lookaheadFormals() {
        if (this.peekToken().kind != 21) {
            return false;
        }
        if (this.peekToken((int)1).kind == 22) {
            return true;
        }
        int start = this.currentIndex;
        this.eatTopToken();
        if (this.eatModifiers() && this.eatTypeD() && this.isIdentifier(this.peekToken())) {
            this.currentIndex = start;
            return true;
        }
        this.currentIndex = start;
        return false;
    }

    private Stmt parseStmt(Map extraDecParsers, boolean allowConstructors, boolean onlyDec) {
        String keyword;
        Token topToken = this.peekToken();
        if (!onlyDec && this.isIdentifier(topToken)) {
            keyword = topToken.image;
            StmtParser stmtParser = (StmtParser)this.stmtParsers.get(keyword);
            if (stmtParser != null) {
                this.eatTopToken();
                return stmtParser.parse();
            }
            if (this.peekToken((int)1).kind == 36) {
                if (this.isKeyword(this.popToken())) {
                    this.showError(this.peekToken(-1), "keyword not allowed as label");
                }
                this.eatTopToken();
                Stmt stmt = this.parseStmt(extraDecParsers, allowConstructors, onlyDec);
                return new LabeledStmt(this.dummySource, keyword, stmt);
            }
        }
        this.pushCurrentIndex();
        this.eatModifiers();
        topToken = this.peekToken();
        if (this.isIdentifier(topToken)) {
            keyword = topToken.image;
            DecParser decParser = allowConstructors ? (DecParser)this.decParsers.get(keyword) : (DecParser)this.stmtDecParsers.get(keyword);
            if (extraDecParsers != null && decParser == null) {
                decParser = (DecParser)extraDecParsers.get(keyword);
            }
            if (decParser != null) {
                this.popCurrentIndex();
                return decParser.parse(onlyDec);
            }
        }
        if (allowConstructors) {
            if (this.isIdentifierOrNew(topToken)) {
                this.eatTopToken();
                if (this.lookaheadFormals()) {
                    this.popCurrentIndex();
                    return this.parseConstructorDec();
                }
                --this.currentIndex;
            }
            if (topToken.kind == 23) {
                this.popCurrentIndex();
                return this.parseInitializerDec();
            }
        }
        if (this.eatTypeD() && this.eatIdentifier(onlyDec)) {
            if (this.peekToken().kind == 21) {
                this.popCurrentIndex();
                return this.parseMethodDec();
            }
            this.popCurrentIndex();
            if (onlyDec) {
                return this.parseFieldDec();
            }
            return this.parseVarDec();
        }
        this.popCurrentIndex();
        if (onlyDec) {
            return this.noDecFound();
        }
        if (topToken.kind == 27) {
            this.eatTopToken();
            return new EmptyStmt(this.dummySource);
        }
        if (topToken.kind == 23) {
            return this.parseBlockStmt();
        }
        Expr expr = this.parseExpr();
        this.eatTopToken(27);
        return new ExprStmt(this.dummySource, expr);
    }

    protected Dec noDecFound() {
        this.throwError(this.peekToken(), "declaration or '}' expected");
        return null;
    }

    private Stmt parseTopDec(Map extraDecParsers) {
        Token topToken = this.peekToken();
        this.pushCurrentIndex();
        this.eatModifiers();
        topToken = this.peekToken();
        if (this.isIdentifier(topToken)) {
            String keyword = topToken.image;
            DecParser decParser = (DecParser)this.decParsers.get(keyword);
            if (extraDecParsers != null && decParser == null) {
                decParser = (DecParser)extraDecParsers.get(keyword);
            }
            if (decParser != null) {
                this.popCurrentIndex();
                return decParser.parse(true);
            }
        }
        this.popCurrentIndex();
        this.throwError(topToken, "type declaration expected");
        return null;
    }

    public void throwError(Token t, String message) {
        if (t == null) {
            t = this.peekToken();
        }
        throw new ParseException(t, this.tokenSource.sourceInfo, message);
    }

    public void warnVersion(String version, Token t, String message) {
        this.getCompiler().warnVersion(version, this.tokenToASTObject(t), message);
    }

    public void showError(Token t, String message) {
        this.getCompiler().showError(this.tokenToASTObject(t), message);
    }

    public ASTObject tokenToASTObject(Token t) {
        FakeASTObject fake = new FakeASTObject(this.makeSourceLocation(t));
        return fake;
    }

    static {
        modifiers.put("public", new Integer(1));
        modifiers.put("protected", new Integer(4));
        modifiers.put("private", new Integer(2));
        modifiers.put("static", new Integer(8));
        modifiers.put("final", new Integer(16));
        modifiers.put("abstract", new Integer(1024));
        modifiers.put("native", new Integer(256));
        modifiers.put("synchronized", new Integer(32));
        modifiers.put("transient", new Integer(128));
        modifiers.put("volatile", new Integer(64));
        modifiers.put("strictfp", new Integer(2048));
    }

    class WhileStmtParser
    extends StmtParser {
        WhileStmtParser() {
        }

        public Stmt parse() {
            Expr test = JavaParser.this.parseParenExpr();
            Stmt body = JavaParser.this.parseStmt();
            return new WhileStmt(JavaParser.this.dummySource, test, body);
        }
    }

    class TryStmtParser
    extends StmtParser {
        TryStmtParser() {
        }

        public Stmt parse() {
            Stmt body = JavaParser.this.parseStmt();
            CatchClauses catches = new CatchClauses(JavaParser.this.dummySource);
            Token beginToken = JavaParser.this.peekToken();
            while (JavaParser.this.maybeEatKeyword("catch")) {
                FormalDec formal = JavaParser.this.parseParenFormal();
                Stmt catchBody = JavaParser.this.parseStmt();
                CatchClause clause = new CatchClause(JavaParser.this.dummySource, formal, catchBody);
                JavaParser.this.addContext((ASTObject)clause, beginToken);
                catches.add(clause);
                beginToken = JavaParser.this.peekToken();
            }
            Stmt _finally = null;
            if (JavaParser.this.maybeEatKeyword("finally")) {
                _finally = JavaParser.this.parseStmt();
            }
            if (catches.size() == 0) {
                return new TryFinallyStmt(JavaParser.this.dummySource, body, _finally);
            }
            if (_finally == null) {
                return new TryCatchStmt(JavaParser.this.dummySource, body, catches);
            }
            TryFinallyStmt s = new TryFinallyStmt(JavaParser.this.dummySource, null, _finally);
            TryCatchStmt b = new TryCatchStmt(JavaParser.this.dummySource, body, catches);
            b.setSyntheticSource(s);
            s.setBody(b);
            return s;
        }
    }

    class GotoStmtParser
    extends StmtParser {
        GotoStmtParser() {
        }

        public Stmt parse() {
            JavaParser.this.showError(JavaParser.this.peekToken(), "'goto' is java reserved keyword");
            return null;
        }
    }

    class ThrowStmtParser
    extends StmtParser {
        ThrowStmtParser() {
        }

        public Stmt parse() {
            Expr expr = JavaParser.this.parseExpr();
            JavaParser.this.eatTopToken(27);
            return new ThrowStmt(JavaParser.this.dummySource, expr);
        }
    }

    class SynchronizedStmtParser
    extends StmtParser {
        SynchronizedStmtParser() {
        }

        public Stmt parse() {
            Expr expr = JavaParser.this.parseParenExpr();
            Stmt body = JavaParser.this.parseStmt();
            return new SynchronizedStmt(JavaParser.this.dummySource, expr, body);
        }
    }

    class SwitchStmtParser
    extends StmtParser {
        SwitchStmtParser() {
        }

        public Stmt parse() {
            Expr expr = JavaParser.this.parseParenExpr();
            JavaParser.this.eatTopToken(23);
            SwitchClauses clauses = new SwitchClauses(JavaParser.this.dummySource);
            Expr label = null;
            Stmts stmts = null;
            SwitchClause switchClause = null;
            while (true) {
                if (JavaParser.this.maybeEatKeyword("case")) {
                    label = JavaParser.this.parseExpr();
                    JavaParser.this.eatTopToken(36);
                    if (switchClause != null) {
                        clauses.add(switchClause);
                    }
                    stmts = new Stmts(JavaParser.this.dummySource);
                    switchClause = new SwitchClause(JavaParser.this.dummySource, label, stmts);
                    continue;
                }
                if (JavaParser.this.maybeEatKeyword("default")) {
                    JavaParser.this.eatTopToken(36);
                    if (switchClause != null) {
                        clauses.add(switchClause);
                    }
                    stmts = new Stmts(JavaParser.this.dummySource);
                    switchClause = new SwitchClause(JavaParser.this.dummySource, null, stmts);
                    continue;
                }
                if (JavaParser.this.peekToken().kind == 24) {
                    if (switchClause != null) {
                        clauses.add(switchClause);
                    }
                    JavaParser.this.eatTopToken();
                    break;
                }
                if (stmts == null) {
                    JavaParser.this.throwError(JavaParser.this.peekToken(), "'case', 'default' or '}' expected");
                    break;
                }
                stmts.add(JavaParser.this.parseStmt());
            }
            return new SwitchStmt(JavaParser.this.dummySource, expr, clauses);
        }
    }

    class ReturnStmtParser
    extends StmtParser {
        ReturnStmtParser() {
        }

        public Stmt parse() {
            Expr expr = null;
            if (JavaParser.this.peekToken().kind != 27) {
                expr = JavaParser.this.parseExpr();
            }
            JavaParser.this.eatTopToken(27);
            return new ReturnStmt(JavaParser.this.dummySource, expr);
        }
    }

    class IfStmtParser
    extends StmtParser {
        IfStmtParser() {
        }

        public Stmt parse() {
            Expr test = JavaParser.this.parseParenExpr();
            Stmt _then = JavaParser.this.parseStmt();
            Stmt _else = null;
            if (JavaParser.this.maybeEatKeyword("else")) {
                _else = JavaParser.this.parseStmt();
            }
            IfStmt ifStmt = new IfStmt(JavaParser.this.dummySource, test, _then, _else);
            if (_else == null) {
                ifStmt.setElse((Stmt)new EmptyStmt(JavaParser.this.dummySource).setSyntheticSource(ifStmt));
            }
            return ifStmt;
        }
    }

    class ForStmtParser
    extends StmtParser {
        ForStmtParser() {
        }

        public Stmt parse() {
            ASTObject init;
            JavaParser.this.eatTopToken(21);
            if (JavaParser.this.lookaheadVarDes()) {
                init = JavaParser.this.parseVarDec();
            } else {
                init = JavaParser.this.parseExprs(27);
                JavaParser.this.eatTopToken(27);
            }
            Expr test = JavaParser.this.parseExpr(true);
            JavaParser.this.eatTopToken(27);
            Exprs update = JavaParser.this.parseExprs(22);
            JavaParser.this.eatTopToken(22);
            Stmt body = JavaParser.this.parseStmt();
            ForStmt forStmt = new ForStmt(JavaParser.this.dummySource, init, test, update, body);
            if (test == null) {
                forStmt.setTest((Expr)new BooleanLiteralExpr(JavaParser.this.dummySource, true).setSyntheticSource(forStmt));
            }
            return forStmt;
        }
    }

    class AssertStmtParser
    extends StmtParser {
        AssertStmtParser() {
        }

        public Stmt parse() {
            Expr test = JavaParser.this.parseExpr();
            Expr message = null;
            if (JavaParser.this.maybeEatToken(36)) {
                message = JavaParser.this.parseExpr();
            }
            JavaParser.this.eatTopToken(27);
            return new AssertStmt(JavaParser.this.dummySource, test, message);
        }
    }

    class DoStmtParser
    extends StmtParser {
        DoStmtParser() {
        }

        public Stmt parse() {
            Stmt body = JavaParser.this.parseStmt();
            JavaParser.this.eatKeyword("while");
            Expr test = JavaParser.this.parseParenExpr();
            JavaParser.this.eatTopToken(27);
            return new DoStmt(JavaParser.this.dummySource, body, test);
        }
    }

    class ContinueStmtParser
    extends StmtParser {
        ContinueStmtParser() {
        }

        public Stmt parse() {
            String label = null;
            if (JavaParser.this.peekToken().kind != 27) {
                label = JavaParser.this.parseId();
            }
            JavaParser.this.eatTopToken(27);
            return new ContinueStmt(JavaParser.this.dummySource, label);
        }
    }

    class BreakStmtParser
    extends StmtParser {
        BreakStmtParser() {
        }

        public Stmt parse() {
            String label = null;
            if (JavaParser.this.peekToken().kind != 27) {
                label = JavaParser.this.parseId();
            }
            JavaParser.this.eatTopToken(27);
            return new BreakStmt(JavaParser.this.dummySource, label);
        }
    }

    public static abstract class StmtParser {
        public abstract Stmt parse();
    }

    class ClassDecParser
    extends DecParser {
        ClassDecParser() {
        }

        public Dec parse() {
            throw new RuntimeException();
        }

        public Dec parse(boolean isNotMethodLocal) {
            int legalModifiers = !isNotMethodLocal ? 3088 : (JavaParser.this.peekEnclosingTypeDec() == null ? 3089 : (JavaParser.this.inInterface ? 3097 : 3103));
            Modifiers modifiers = JavaParser.this.parseModifiers(legalModifiers);
            if (JavaParser.this.inInterface) {
                modifiers.setPublic(true);
            }
            JavaParser.this.eatKeyword("class");
            String id = JavaParser.this.parseId();
            TypeD superClass = null;
            if (JavaParser.this.maybeEatKeyword("extends")) {
                superClass = JavaParser.this.parseTypeD();
            }
            TypeDs _implements = null;
            if (JavaParser.this.maybeEatKeyword("implements")) {
                _implements = JavaParser.this.parseTypeDs();
            }
            ClassDec ret = new ClassDec(JavaParser.this.dummySource, modifiers, id, superClass, _implements, null);
            if (!isNotMethodLocal) {
                ret.setLocal();
            }
            ret.setEnclosingTypeDec(JavaParser.this.peekEnclosingTypeDec());
            JavaParser.this.pushEnclosingTypeDec(ret);
            Decs body = null;
            boolean oldInInterface = JavaParser.this.inInterface;
            try {
                JavaParser.this.inInterface = false;
                body = JavaParser.this.parseDecs();
                Object var11_10 = null;
                JavaParser.this.inInterface = oldInInterface;
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                JavaParser.this.inInterface = oldInInterface;
                throw throwable;
            }
            JavaParser.this.popEnclosingTypeDec();
            ret.setBody(body);
            if (JavaParser.this.peekEnclosingTypeDec() == null) {
                JavaParser.this.currentCompilationUnit.addDefinedType(ret);
            }
            return ret;
        }
    }

    class InterfaceDecParser
    extends DecParser {
        InterfaceDecParser() {
        }

        public Dec parse() {
            throw new RuntimeException();
        }

        public Dec parse(boolean isNotMethodLocal) {
            int legalModifiers = !isNotMethodLocal ? 3072 : (JavaParser.this.peekEnclosingTypeDec() == null ? 3073 : (JavaParser.this.inInterface ? 3081 : 3087));
            Modifiers modifiers = JavaParser.this.parseModifiers(legalModifiers);
            if (JavaParser.this.inInterface) {
                modifiers.setPublic(true);
            }
            JavaParser.this.eatKeyword("interface");
            String id = JavaParser.this.parseId();
            TypeDs _extends = null;
            if (JavaParser.this.maybeEatKeyword("extends")) {
                _extends = JavaParser.this.parseTypeDs();
            }
            InterfaceDec ret = new InterfaceDec(JavaParser.this.dummySource, modifiers, id, _extends, null);
            ret.setEnclosingTypeDec(JavaParser.this.peekEnclosingTypeDec());
            JavaParser.this.pushEnclosingTypeDec(ret);
            Decs body = null;
            boolean oldInInterface = JavaParser.this.inInterface;
            try {
                JavaParser.this.inInterface = true;
                body = JavaParser.this.parseDecs();
                Object var10_9 = null;
                JavaParser.this.inInterface = oldInInterface;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                JavaParser.this.inInterface = oldInInterface;
                throw throwable;
            }
            JavaParser.this.popEnclosingTypeDec();
            ret.setBody(body);
            if (JavaParser.this.peekEnclosingTypeDec() == null) {
                JavaParser.this.currentCompilationUnit.addDefinedType(ret);
            }
            return ret;
        }
    }

    public static abstract class DecParser {
        public Dec parse(boolean isNotMethodLocal) {
            return this.parse();
        }

        public abstract Dec parse();
    }

    static class FakeASTObject
    extends ASTObject {
        public FakeASTObject(SourceLocation loc) {
            super(loc);
        }

        public ASTObject copy() {
            return null;
        }

        public int getChildCount() {
            return 0;
        }
    }

    protected class ExprParser {
        protected PrefixOperator[] prefixOps;
        protected InfixOperator[] infixOps;
        private boolean allowLiterals = true;

        public ExprParser() {
            int tokenTypes = JavaConstants.tokenImage.length;
            this.prefixOps = new PrefixOperator[512];
            this.infixOps = new InfixOperator[512];
        }

        private final void fillOps(Operator[] ops, Operator[] toArray) {
            int i = 0;
            while (i < ops.length) {
                Operator op;
                toArray[op.getTokenKind()] = op = ops[i];
                op.setParent(this);
                ++i;
            }
        }

        public ExprParser(PrefixOperator[] prefixes, InfixOperator[] infixes, boolean allowLiterals) {
            this(prefixes, infixes);
            this.allowLiterals = allowLiterals;
        }

        public ExprParser(PrefixOperator[] prefixes, InfixOperator[] infixes) {
            this();
            this.fillOps(prefixes, this.prefixOps);
            this.fillOps(infixes, this.infixOps);
        }

        public void addInfixOperator(InfixOperator op) {
            this.infixOps[op.getTokenKind()] = op;
            op.setParent(this);
        }

        public void addPrefixOperator(PrefixOperator op) {
            this.prefixOps[op.getTokenKind()] = op;
            op.setParent(this);
        }

        public Expr parseTerminal() {
            Token token = JavaParser.this.peekToken();
            int kind = token.kind;
            Expr literalExpr = token.getExpr(JavaParser.this.makeSourceLocation(token));
            if (literalExpr != null && this.allowLiterals) {
                JavaParser.this.eatTopToken();
                return literalExpr;
            }
            PrefixOperator op = this.prefixOps[kind];
            if (op == null && token.isIdentifier()) {
                op = this.prefixOps[70];
            }
            if (op != null) {
                return op.parse();
            }
            return null;
        }

        public Expr parseOperator(Expr lhs, int minimumPrecedence) {
            Token token = JavaParser.this.peekToken();
            int kind = token.kind;
            InfixOperator op = this.infixOps[kind];
            if (op != null) {
                return op.parse(lhs, minimumPrecedence);
            }
            return lhs;
        }

        /*
         * WARNING - void declaration
         */
        public Expr parseAll(Expr lhs, int minimumPrecedence, Token beginToken) {
            Expr ret;
            while ((ret = this.parseOperator(lhs, minimumPrecedence)) != lhs && ret != null) {
                void var4_4;
                JavaParser.this.addContext((ASTObject)var4_4, beginToken);
                beginToken = JavaParser.this.peekToken();
                lhs = var4_4;
            }
            return ret;
        }

        protected Expr parse(int minimumPrecedence) {
            Token beginToken = JavaParser.this.peekToken();
            Expr lhs = this.parseTerminal();
            if (lhs == null) {
                return null;
            }
            JavaParser.this.addContext((ASTObject)lhs, beginToken);
            return this.parseAll(lhs, minimumPrecedence, beginToken);
        }

        public Expr parse() {
            return this.parse(0);
        }
    }

    protected class PostOperator
    extends InfixOperator {
        public PostOperator(String image, int precedence) {
            super(image, precedence);
        }

        public Expr parse(Expr lhs) {
            return new PostfixExpr(JavaParser.this.dummySource, JavaParser.this.checkAssignable(lhs), this.image);
        }
    }

    protected class PreOperator
    extends PrefixOperator {
        public PreOperator(String image, int precedence) {
            super(image, precedence);
        }

        public Expr parse() {
            JavaParser.this.eatTopToken();
            return new PrefixExpr(JavaParser.this.dummySource, JavaParser.this.checkAssignable(this.parentParse(this.precedence)), this.image);
        }
    }

    protected class InstanceOfOperator
    extends InfixOperator {
        public InstanceOfOperator(int precedence) {
            super("instanceof", precedence);
        }

        public Expr parse(Expr lhs) {
            TypeD typeD = JavaParser.this.parseTypeD();
            return new InstanceofExpr(JavaParser.this.dummySource, lhs, typeD);
        }
    }

    protected class QuestionOperator
    extends InfixOperator {
        public QuestionOperator(int precedence) {
            super("?", precedence);
        }

        public Expr parse(Expr lhs) {
            Expr trueExpr = this.parentParse(0);
            JavaParser.this.eatTopToken(36);
            Expr falseExpr = JavaParser.this.parseExpr();
            return new TriTestExpr(JavaParser.this.dummySource, lhs, trueExpr, falseExpr);
        }
    }

    protected class ArrayOperator
    extends InfixOperator {
        public ArrayOperator(int precedence) {
            super("[", precedence);
        }

        public Expr parse(Expr lhs) {
            if (JavaParser.this.peekToken().kind == 26) {
                TypeD typeD = JavaParser.this.exprToTypeD(lhs, ".class");
                --JavaParser.this.currentIndex;
                typeD = JavaParser.this.addBracketsToTypeD(typeD);
                JavaParser.this.eatTopToken(29);
                JavaParser.this.eatKeyword("class");
                return new ClassExpr(JavaParser.this.dummySource, typeD);
            }
            Expr index = JavaParser.this.parseExpr();
            JavaParser.this.eatTopToken(26);
            return new ArrayExpr(JavaParser.this.dummySource, lhs, index);
        }
    }

    protected class AssignOperator
    extends InfixOperator {
        public AssignOperator(String image, int precedence) {
            super(image, precedence);
        }

        public Expr parse(Expr lhs) {
            Expr rhs = this.parentParse(this.precedence - 1);
            String s = this.image;
            return AssignExpr.build(JavaParser.this.dummySource, JavaParser.this.checkAssignable(lhs), s.substring(0, s.length() - 1), rhs);
        }
    }

    protected class DotOperator
    extends InfixOperator {
        public DotOperator(int precedence) {
            super(".", precedence);
        }

        public Expr parse(Expr lhs) {
            if (JavaParser.this.maybeEatKeyword("new")) {
                String innerName = JavaParser.this.parseId();
                JavaParser.this.eatTopToken(21);
                Exprs args = JavaParser.this.parseExprs(22);
                JavaParser.this.eatTopToken(22);
                TypeDec typeDec = JavaParser.this.maybeParseClassBody(null);
                return new NewInnerInstanceExpr(JavaParser.this.dummySource, lhs, null, args, typeDec, null, innerName);
            }
            String id = JavaParser.this.parseIdOrKeywords_this_super_class();
            if (id.equals("this")) {
                return new QualifiedThisExpr(JavaParser.this.dummySource, JavaParser.this.exprToTypeD(lhs, ".this"));
            }
            if (id.equals("super")) {
                if (JavaParser.this.inConstructor() && JavaParser.this.maybeEatToken(21)) {
                    Exprs args = JavaParser.this.parseExprs(22);
                    JavaParser.this.eatTopToken(22);
                    return new ConstructorCallExpr(JavaParser.this.dummySource, lhs, true, args, null);
                }
                return new QualifiedSuperExpr(JavaParser.this.dummySource, JavaParser.this.exprToTypeD(lhs, ".super"));
            }
            if (id.equals("class")) {
                return new ClassExpr(JavaParser.this.dummySource, JavaParser.this.exprToTypeD(lhs, ".class"));
            }
            if (JavaParser.this.maybeEatToken(21)) {
                Exprs args = JavaParser.this.parseExprs(22);
                JavaParser.this.eatTopToken(22);
                return new CallExpr(JavaParser.this.dummySource, lhs, id, args);
            }
            return new UnresolvedFieldAccessExpr(JavaParser.this.dummySource, lhs, id);
        }
    }

    protected class InfixOperator
    extends Operator {
        protected InfixOperator(int tokenKind, int precedence) {
            super(tokenKind, precedence);
        }

        public InfixOperator(String image, int precedence) {
            super(image, precedence);
        }

        public Expr parse(Expr lhs, int minimumPrecedence) {
            if (this.precedence <= minimumPrecedence) {
                return lhs;
            }
            JavaParser.this.eatTopToken();
            return this.parse(lhs);
        }

        public Expr parse(Expr lhs) {
            return BinopExpr.build(JavaParser.this.dummySource, this.image, lhs, this.parentParse(this.precedence));
        }
    }

    protected class IdentifierOp
    extends LiteralOp {
        public IdentifierOp() {
            super(70);
        }

        public Expr parse(String image) {
            TypeD typeD = JavaParser.this.lookupPrimitiveTypeD(image);
            if (typeD != null) {
                JavaParser.this.eatTopToken();
                return new TypeExpr(JavaParser.this.dummySource, typeD);
            }
            Name name = JavaParser.this.parseExtendedName();
            if (JavaParser.this.maybeEatToken(21)) {
                return JavaParser.this.parseCallExpr(name);
            }
            return new UnresolvedExpr(JavaParser.this.dummySource, name);
        }
    }

    protected class SuperLiteral
    extends LiteralOp {
        public SuperLiteral() {
            super("super");
        }

        public Expr parse(String image) {
            JavaParser.this.eatTopToken();
            return new SuperExpr(JavaParser.this.dummySource);
        }
    }

    protected class ThisLiteral
    extends LiteralOp {
        public ThisLiteral() {
            super("this");
        }

        public Expr parse(String image) {
            JavaParser.this.eatTopToken();
            return new ThisExpr(JavaParser.this.dummySource);
        }
    }

    protected class NullLiteral
    extends LiteralOp {
        public NullLiteral() {
            super("null");
        }

        public Expr parse(String image) {
            JavaParser.this.eatTopToken();
            return new NullExpr(JavaParser.this.dummySource);
        }
    }

    protected class FalseLiteral
    extends LiteralOp {
        public FalseLiteral() {
            super("false");
        }

        public Expr parse(String image) {
            JavaParser.this.eatTopToken();
            return new BooleanLiteralExpr(JavaParser.this.dummySource, false);
        }
    }

    protected class TrueLiteral
    extends LiteralOp {
        public TrueLiteral() {
            super("true");
        }

        public Expr parse(String image) {
            JavaParser.this.eatTopToken();
            return new BooleanLiteralExpr(JavaParser.this.dummySource, true);
        }
    }

    protected abstract class LiteralOp
    extends PrefixOperator {
        public LiteralOp(int tokenKind) {
            super(tokenKind, -1);
        }

        public LiteralOp(String image) {
            super(image, -1);
        }

        public Expr parse() {
            Token token = JavaParser.this.peekToken();
            Expr expr = this.parse(token.image);
            return expr;
        }

        public abstract Expr parse(String var1);
    }

    protected class PrefixOperator
    extends Operator {
        protected PrefixOperator(int tokenKind, int precedence) {
            super(tokenKind, precedence);
        }

        public PrefixOperator(String image, int precedence) {
            super(image, precedence);
        }

        public Expr parse() {
            JavaParser.this.eatTopToken();
            return UnopExpr.build(JavaParser.this.dummySource, this.image, this.parentParse(this.precedence));
        }
    }

    protected class MinusOperator
    extends PrefixOperator {
        public MinusOperator(int precedence) {
            super("-", precedence);
        }

        public Expr parse() {
            JavaParser.this.eatTopToken();
            if (JavaParser.this.peekToken().kind == 13) {
                Token t = JavaParser.this.popToken();
                return t.getNegativeExpr(JavaParser.this.makeSourceLocation(JavaParser.this.peekToken(-1)));
            }
            return new MinusOpExpr(JavaParser.this.makeSourceLocation(JavaParser.this.peekToken(-1)), this.image, this.parentParse(this.precedence));
        }
    }

    protected abstract class Operator {
        protected int precedence;
        protected String image;
        protected int tokenKind;
        private ExprParser parent;

        protected Operator(int tokenKind, int precedence) {
            this.precedence = precedence;
            this.tokenKind = tokenKind;
            this.image = JavaConstants.tokenImage[tokenKind];
        }

        protected Operator(String image, int precedence) {
            int tokenKind = 0;
            String testImage = "\"" + image + "\"";
            while (tokenKind < JavaConstants.tokenImage.length) {
                String maybeImage = JavaConstants.tokenImage[tokenKind];
                if (maybeImage != null && maybeImage.equals(testImage)) break;
                ++tokenKind;
            }
            if (tokenKind == JavaConstants.tokenImage.length) {
                JavaParser.this.tokenSource;
                tokenKind = JavaTokenizer.addOperator(image);
            }
            this.tokenKind = tokenKind;
            this.image = image;
            this.precedence = precedence;
        }

        public int getTokenKind() {
            return this.tokenKind;
        }

        public void setParent(ExprParser parent) {
            this.parent = parent;
        }

        public Expr parentParse() {
            Expr ret = this.parent.parse();
            if (ret == null) {
                JavaParser.this.throwError(null, "expression expected");
            }
            return ret;
        }

        public Expr parentParse(int precedence) {
            Expr ret = this.parent.parse(precedence);
            if (ret == null) {
                JavaParser.this.throwError(null, "expression expected");
            }
            return ret;
        }
    }

    protected class ParenOperator
    extends PrefixOperator {
        protected boolean allowCasts = false;

        public ParenOperator(int precedence, boolean allowCasts) {
            super("(", precedence);
            this.allowCasts = allowCasts;
        }

        public ParenOperator(int precedence) {
            this(precedence, false);
        }

        private boolean notPlusMinus(int kind) {
            switch (kind) {
                case 27: 
                case 35: 
                case 43: 
                case 44: 
                case 45: 
                case 46: {
                    return false;
                }
            }
            return true;
        }

        public Expr parse() {
            JavaParser.this.eatTopToken();
            if (!this.allowCasts) {
                return this.basicParse();
            }
            int savedIndex = JavaParser.this.currentIndex;
            Token nextToken = JavaParser.this.peekToken();
            if (nextToken.isIdentifier() && JavaParser.this.primitiveTypeNames.get(nextToken.image) != null) {
                TypeD typeD = JavaParser.this.parseTypeD();
                JavaParser.this.eatTopToken(22);
                return new CastExpr(JavaParser.this.dummySource, typeD, JavaParser.this.exprParser.parse(1500));
            }
            if (JavaParser.this.eatTypeD() && JavaParser.this.popToken().kind == 22 && this.notPlusMinus(JavaParser.this.popToken().kind)) {
                JavaParser.this.currentIndex = savedIndex;
                TypeD typeD = JavaParser.this.parseTypeD();
                JavaParser.this.eatTopToken(22);
                Expr expr = JavaParser.this.exprParser.parse(1500);
                if (expr != null) {
                    return new CastExpr(JavaParser.this.dummySource, typeD, expr);
                }
            }
            JavaParser.this.currentIndex = savedIndex;
            return this.basicParse();
        }

        protected Expr basicParse() {
            Expr expr = this.parentParse();
            JavaParser.this.eatTopToken(22);
            return new ParenExpr(JavaParser.this.dummySource, expr);
        }
    }

    protected class NewOperator
    extends PrefixOperator {
        public NewOperator(int precedence) {
            super("new", precedence);
        }

        private NewArrayExpr parseNewArrayExprWithInitializer(ArrayTypeD typeD) {
            ArrayInitializer init = null;
            if (JavaParser.this.peekToken().kind == 23) {
                init = JavaParser.this.parseArrayInitializer();
            } else {
                JavaParser.this.showError(JavaParser.this.peekToken(), "'{' expected");
            }
            return new NewArrayExpr(JavaParser.this.dummySource, typeD, init, null);
        }

        private NewArrayExpr parseNewArrayExpr(TypeD typeD) {
            Exprs dimExprs = null;
            if (JavaParser.this.peekToken().kind == 25) {
                dimExprs = JavaParser.this.parseArrayDimExprs();
                int i = 0;
                while (i < dimExprs.size()) {
                    typeD = new ArrayTypeD(JavaParser.this.dummySource, typeD);
                    ++i;
                }
            }
            return new NewArrayExpr(JavaParser.this.dummySource, (ArrayTypeD)typeD, null, dimExprs);
        }

        public Expr parse() {
            Token beginToken = JavaParser.this.peekToken();
            JavaParser.this.eatTopToken();
            TypeD typeD = JavaParser.this.parseTypeD();
            if (typeD == null) {
                JavaParser.this.throwError(JavaParser.this.peekToken(), "type expected");
            }
            if (JavaParser.this.maybeEatToken(21)) {
                Exprs args = JavaParser.this.parseExprs(22);
                JavaParser.this.eatTopToken(22);
                TypeDec typeDec = JavaParser.this.maybeParseClassBody(typeD);
                return new NewInstanceExpr(JavaParser.this.dummySource, null, typeD, args, typeDec, null);
            }
            if (typeD instanceof ArrayTypeD) {
                return this.parseNewArrayExprWithInitializer((ArrayTypeD)typeD);
            }
            if (JavaParser.this.peekToken().kind == 25) {
                return this.parseNewArrayExpr(typeD);
            }
            JavaParser.this.throwError(JavaParser.this.peekToken(), "( or [ expected");
            return null;
        }
    }
}

