/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.parser;

import java.math.BigDecimal;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.FloatLiteralExpr;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.parser.Literal;

class FloatLiteral
extends Literal {
    public float value;

    public FloatLiteral(String image) {
        super(image, 17);
    }

    public String getValueImage() {
        if (this.image.endsWith("F") || this.image.endsWith("f")) {
            return this.image.substring(0, this.image.length() - 1);
        }
        return this.image;
    }

    public Expr getExpr(SourceLocation source) {
        FloatLiteralExpr ret;
        try {
            this.value = Float.valueOf(this.getValueImage()).floatValue();
            ret = new FloatLiteralExpr(source, this.value);
            if (this.value == 0.0f) {
                BigDecimal bd = new BigDecimal(this.getValueImage());
                if (bd.compareTo(new BigDecimal("0")) != 0) {
                    ret.showError("non-zero literal rounds to 0");
                }
            } else if (this.value == Float.POSITIVE_INFINITY || this.value == Float.NEGATIVE_INFINITY) {
                ret.showError("floating point literal rounds to IEEE infinity");
            }
        }
        catch (NumberFormatException nfe) {
            source.showError("illegal floating point literal format");
            ret = new FloatLiteralExpr(source, 0.0f);
        }
        return ret;
    }
}

