/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.cst;

import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.Field;
import org.aspectj.compiler.base.ast.FieldAccessExpr;
import org.aspectj.compiler.base.ast.ScopeWalker;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.SuperExpr;
import org.aspectj.compiler.base.ast.Type;

public class UnresolvedFieldAccessExpr
extends FieldAccessExpr {
    protected String id;

    public UnresolvedFieldAccessExpr(SourceLocation source, Expr expr, String id) {
        this(source, expr, null, false, id);
    }

    public Field resolveField() {
        Type type = this.expr.getType();
        if (type == null) {
            this.expr.showError("bad type");
            return null;
        }
        return type.getField(this.id, this, true);
    }

    public ASTObject postScope(ScopeWalker walker) {
        if (this.expr != null && this.expr instanceof SuperExpr) {
            this.setIsSuper(true);
        }
        return new FieldAccessExpr(this.getSourceLocation(), this.getExpr(), this.resolveField(), this.getIsSuper());
    }

    public String getId() {
        return this.id;
    }

    public void setId(String _id) {
        this.id = _id;
    }

    public UnresolvedFieldAccessExpr(SourceLocation location, Expr _expr, Field _field, boolean _isSuper, String _id) {
        super(location, _expr, _field, _isSuper);
        this.setId(_id);
    }

    protected UnresolvedFieldAccessExpr(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        UnresolvedFieldAccessExpr ret = new UnresolvedFieldAccessExpr(this.getSourceLocation());
        ret.preCopy(walker, this);
        if (this.expr != null) {
            ret.setExpr((Expr)walker.process(this.expr));
        }
        ret.field = this.field;
        ret.isSuper = this.isSuper;
        ret.id = this.id;
        return ret;
    }

    public String getDefaultDisplayName() {
        return "UnresolvedFieldAccessExpr(field: " + this.field + ", " + "isSuper: " + this.isSuper + ", " + "id: " + this.id + ")";
    }
}

