/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.cst;

import java.util.HashMap;
import org.aspectj.compiler.base.JavaCompiler;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CompilationUnit;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.Import;
import org.aspectj.compiler.base.ast.Imports;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.TypeDec;
import org.aspectj.compiler.base.cst.Scope;

public class CUScope
extends Scope {
    private CompilationUnit cu;
    HashMap nameToType = new HashMap();

    public CUScope(JavaCompiler compiler, Scope parent, CompilationUnit cu) {
        super(compiler, parent);
        this.cu = cu;
    }

    public String shortToString() {
        return "CU(" + this.cu.getSourceFileName() + ")";
    }

    public Expr bindUnqualifiedName(String name, ASTObject fromWhere) {
        return null;
    }

    public Type findMethodLookupType(String name, ASTObject fromWhere) {
        return null;
    }

    public Type findType(String name, ASTObject fromWhere) {
        Type type = (Type)this.nameToType.get(name);
        if (type != null) {
            return type;
        }
        type = this.internalFindType(name, fromWhere);
        if (type != null) {
            this.nameToType.put(name, type);
        }
        return type;
    }

    protected boolean isPackageAccessible(TypeDec typeDec) {
        String p1 = typeDec.getPackageName();
        String p2 = this.cu.getPackageName();
        if (p1 == null) {
            return p2 == null;
        }
        return p1.equals(p2);
    }

    protected boolean checkAccessibility(TypeDec typeDec, ASTObject fromWhere) {
        if (typeDec.isPublic()) {
            return true;
        }
        if (typeDec.isPrivate()) {
            return false;
        }
        if (typeDec.isProtected()) {
            if (this.isPackageAccessible(typeDec)) {
                return true;
            }
            return typeDec.isAccessible(fromWhere);
        }
        return this.isPackageAccessible(typeDec);
    }

    protected Type checkFoundType(String id, Type oldType, Type foundType, ASTObject fromWhere) {
        if (foundType == null) {
            return oldType;
        }
        if (foundType == this.getTypeManager().TYPE_NOT_FOUND) {
            return oldType;
        }
        if (!this.checkAccessibility(foundType.getTypeDec(), fromWhere)) {
            return oldType;
        }
        if (oldType != null && foundType != oldType) {
            return this.handleAmbiguousImport(id, foundType, oldType, fromWhere);
        }
        return foundType;
    }

    protected Type internalFindType(String id, ASTObject fromWhere) {
        Type type = null;
        Imports imports = this.cu.getImports();
        if (imports != null) {
            int i = 0;
            while (i < imports.size()) {
                Import _import = imports.get(i);
                if (!_import.getStar() && _import.capturesId(id)) {
                    return _import.getType();
                }
                ++i;
            }
        }
        String packageName = this.cu.getPackageName();
        type = this.getTypeManager().findType(packageName, id);
        if (type != null) {
            return type;
        }
        if (imports != null) {
            int i = 0;
            while (i < imports.size()) {
                Import _import = imports.get(i);
                if (_import.getStar()) {
                    Object o = _import.getTypeName().resolve(_import.makeTypeNameScope(), false);
                    Type tryType = null;
                    if (o != null) {
                        if (o instanceof String) {
                            tryType = this.getTypeManager().findType((String)o, id);
                        } else if (o instanceof Type) {
                            tryType = ((Type)o).getInnerType(id, _import, false);
                        }
                        type = this.checkFoundType(id, type, tryType, fromWhere);
                    }
                }
                ++i;
            }
        }
        Type javaLangType = this.getTypeManager().findType("java.lang", id);
        type = this.checkFoundType(id, type, javaLangType, fromWhere);
        return type;
    }

    protected Type handleAmbiguousImport(String id, Type type1, Type type2, ASTObject showWhere) {
        this.getCompiler().showError(showWhere, "ambiguous type reference, could be either " + type1.getString() + " or " + type2.getString());
        return null;
    }
}

