/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.cst;

import org.aspectj.compiler.base.JavaCompiler;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.TypeDec;
import org.aspectj.compiler.base.ast.VarDec;
import org.aspectj.compiler.base.ast.VarExpr;
import org.aspectj.compiler.base.cst.Scope;
import org.aspectj.util.StackMap;

public class BlockScope
extends Scope {
    private StackMap vars = new StackMap();
    private StackMap types = new StackMap();

    public BlockScope(JavaCompiler compiler, Scope parent) {
        super(compiler, parent);
    }

    public String shortToString() {
        return "BLOCK";
    }

    public void pushBlock() {
        this.vars.push();
        this.types.push();
    }

    public void popBlock() {
        this.vars.pop();
        this.types.pop();
    }

    public void addVarDec(VarDec varDec) {
        Object oldDec = this.vars.put(varDec.getId(), varDec);
        if (oldDec == null) {
            return;
        }
        varDec.showError(varDec.getId() + " is already defined");
    }

    public Expr bindUnqualifiedName(String name, ASTObject fromWhere) {
        Object ret = this.vars.get(name);
        if (ret != null) {
            return new VarExpr(fromWhere.getSourceLocation(), (VarDec)ret);
        }
        return super.bindUnqualifiedName(name, fromWhere);
    }

    public void addTypeDec(TypeDec typeDec) {
        Object oldDec = this.types.put(typeDec.getId(), typeDec);
        if (oldDec == null) {
            return;
        }
        typeDec.showError(typeDec.getId() + " is already defined");
    }

    public Type findType(String name, ASTObject fromWhere) {
        Object ret = this.types.get(name);
        if (ret != null) {
            return ((TypeDec)ret).getType();
        }
        return super.findType(name, fromWhere);
    }
}

