/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.bytecode;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.aspectj.compiler.base.JavaCompiler;
import org.aspectj.compiler.base.ast.TypeDec;
import org.aspectj.compiler.base.bytecode.ClassManager;

class JarClassManager
extends ClassManager {
    File origFile;
    ZipFile zipFile;
    String prefix = null;

    private JarClassManager(JavaCompiler compiler, ZipFile zipFile, String prefix) {
        super(compiler);
        this.zipFile = zipFile;
        this.prefix = prefix;
    }

    public JarClassManager(JavaCompiler compiler, File jarFile) {
        super(compiler);
        this.origFile = jarFile;
        if (jarFile.isFile()) {
            try {
                this.zipFile = new ZipFile(jarFile);
            }
            catch (IOException e) {
                this.zipFile = null;
            }
        } else {
            this.zipFile = null;
        }
    }

    public ClassManager makeSubPackageManager(String subPackageName) {
        if (this.zipFile == null) {
            return null;
        }
        String newPrefix = this.prefix == null ? subPackageName + '/' : this.prefix + subPackageName + '/';
        JarClassManager ret = new JarClassManager(this.getCompiler(), this.zipFile, newPrefix);
        return ret;
    }

    public TypeDec findTypeDec(String name) {
        if (this.zipFile == null) {
            return null;
        }
        String fileName = this.prefix + name + ".class";
        ZipEntry entry = this.zipFile.getEntry(fileName);
        if (entry == null) {
            return null;
        }
        try {
            return this.makeTypeDec(name, this.zipFile.getInputStream(entry));
        }
        catch (IOException e) {
            return null;
        }
    }

    public Collection getAllPossibleTypeNames() {
        ArrayList<List> ret = new ArrayList<List>();
        if (this.zipFile == null) {
            return ret;
        }
        Enumeration<? extends ZipEntry> i = this.zipFile.entries();
        while (i.hasMoreElements()) {
            String name;
            ZipEntry entry = i.nextElement();
            if (entry.isDirectory() || !(name = entry.getName()).toLowerCase().endsWith(".class")) continue;
            ret.add(this.filenameToClassName(name));
        }
        return ret;
    }

    public String toString() {
        return "jar(" + this.zipFile.getName() + ")";
    }

    protected String getPathString() {
        if (this.zipFile == null) {
            return this.origFile.toString() + "<not found>";
        }
        return this.origFile.toString();
    }
}

