/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.bytecode;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.aspectj.compiler.base.bytecode.ClassFile;
import org.aspectj.compiler.base.bytecode.ConstantPool;

class Attributes {
    Attribute[] data;
    ClassFile classFile;

    Attributes() {
    }

    static Attributes createFrom(ClassFile classFile, DataInputStream stream) throws IOException {
        Attributes attributes = new Attributes();
        attributes.classFile = classFile;
        attributes.readFrom(stream);
        return attributes;
    }

    public Attribute findAttribute(Class ofType) {
        int i = 0;
        while (i < this.data.length) {
            if (ofType.isInstance(this.data[i])) {
                return this.data[i];
            }
            ++i;
        }
        return null;
    }

    void readFrom(DataInputStream stream) throws IOException {
        int attributeCount = stream.readUnsignedShort();
        this.data = new Attribute[attributeCount];
        int index = 0;
        while (index < attributeCount) {
            Attribute attribute;
            int nameIndex = stream.readUnsignedShort();
            long attributeLength = 65536 * stream.readUnsignedShort() + stream.readUnsignedShort();
            String name = this.classFile.pool.getUTF((int)nameIndex).value;
            if (name.equals("SourceFile")) {
                attribute = new SourceFileAttribute();
                attribute.readFrom(stream);
            } else if (name.equals("Deprecated")) {
                attribute = new DeprecatedAttribute();
                attribute.readFrom(stream);
            } else if (name.equals("Exceptions")) {
                attribute = new ExceptionsAttribute();
                attribute.readFrom(stream);
            } else if (name.equals("ConstantValue")) {
                attribute = new ConstantValueAttribute();
                attribute.readFrom(stream);
            } else if (name.equals("InnerClasses")) {
                attribute = new InnerClassesAttribute();
                attribute.readFrom(stream);
            } else {
                attribute = new UnknownAttribute(name, attributeLength);
                attribute.readFrom(stream);
            }
            this.data[index] = attribute;
            ++index;
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Attributes(");
        int i = 0;
        while (i < this.data.length) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(this.data[i]);
            ++i;
        }
        buf.append(")");
        return buf.toString();
    }

    class UnknownAttribute
    extends Attribute {
        String name;
        long size;

        public UnknownAttribute(String name, long size) {
            this.name = name;
            this.size = size;
        }

        void readFrom(DataInputStream stream) throws IOException {
            stream.skip(this.size);
        }

        public String toString() {
            return "UnknownAttribute(" + this.name + ", " + this.size + ")";
        }
    }

    class InnerClassesAttribute
    extends Attribute {
        public ConstantPool.Class[] innerClasses;
        public ConstantPool.Class[] outerClasses;
        public ConstantPool.UTF[] innerNames;
        public int[] innerAccessFlags;

        InnerClassesAttribute() {
        }

        void readFrom(DataInputStream stream) throws IOException {
            int size = stream.readUnsignedShort();
            this.innerClasses = new ConstantPool.Class[size];
            this.outerClasses = new ConstantPool.Class[size];
            this.innerNames = new ConstantPool.UTF[size];
            this.innerAccessFlags = new int[size];
            int i = 0;
            while (i < size) {
                this.innerClasses[i] = Attributes.this.classFile.pool.getClass(stream.readUnsignedShort());
                this.outerClasses[i] = Attributes.this.classFile.pool.getClass(stream.readUnsignedShort());
                this.innerNames[i] = Attributes.this.classFile.pool.getUTF(stream.readUnsignedShort());
                this.innerAccessFlags[i] = stream.readUnsignedShort();
                ++i;
            }
        }

        public String toString() {
            return "InnerClassesAttribute(...)";
        }

        public boolean isPackageLevel(String str) {
            int len = this.innerAccessFlags.length;
            int i = 0;
            while (i < len) {
                ConstantPool.Class inner = this.innerClasses[i];
                if (str.equals(inner.getName())) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        public int getModifiers(String str) {
            int len = this.innerAccessFlags.length;
            int i = 0;
            while (i < len) {
                ConstantPool.Class inner = this.innerClasses[i];
                if (str.equals(inner.getName())) {
                    return this.innerAccessFlags[i];
                }
                ++i;
            }
            throw new RuntimeException("Unknown non-package-level class " + str);
        }

        public Set getContainedTypeNames(String str) {
            HashSet<String> set = new HashSet<String>();
            int len = this.innerAccessFlags.length;
            int i = 0;
            while (i < len) {
                ConstantPool.UTF name;
                ConstantPool.Class outer = this.outerClasses[i];
                if (outer != null && (name = this.innerNames[i]) != null && str.equals(outer.getName())) {
                    set.add(name.value);
                }
                ++i;
            }
            return set;
        }
    }

    class ConstantValueAttribute
    extends Attribute {
        public ConstantPool.Entry value;

        ConstantValueAttribute() {
        }

        void readFrom(DataInputStream stream) throws IOException {
            this.value = Attributes.this.classFile.pool.getEntry(stream.readUnsignedShort());
        }

        public String toString() {
            return "ConstantValue(...)";
        }
    }

    class DeprecatedAttribute
    extends Attribute {
        DeprecatedAttribute() {
        }

        void readFrom(DataInputStream stream) throws IOException {
        }

        public String toString() {
            return "Deprecated()";
        }
    }

    public class ExceptionsAttribute
    extends Attribute {
        public ConstantPool.Class[] exceptions;

        void readFrom(DataInputStream stream) throws IOException {
            int n = stream.readUnsignedShort();
            this.exceptions = new ConstantPool.Class[n];
            int i = 0;
            while (i < n) {
                this.exceptions[i] = Attributes.this.classFile.pool.getClass(stream.readUnsignedShort());
                ++i;
            }
        }

        public String toString() {
            return "Exceptions(" + this.exceptions.length + ")";
        }
    }

    class SourceFileAttribute
    extends Attribute {
        ConstantPool.UTF filename;

        SourceFileAttribute() {
        }

        void readFrom(DataInputStream stream) throws IOException {
            this.filename = Attributes.this.classFile.pool.getUTF(stream.readUnsignedShort());
        }

        public String toString() {
            return "SourceFile(" + this.filename.value + ")";
        }
    }

    abstract class Attribute {
        Attribute() {
        }

        abstract void readFrom(DataInputStream var1) throws IOException;
    }
}

