/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.bytecode;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.ListIterator;
import org.aspectj.compiler.base.CompilerObject;
import org.aspectj.compiler.base.JavaCompiler;
import org.aspectj.compiler.base.ast.ArrayTypeD;
import org.aspectj.compiler.base.ast.BooleanLiteralExpr;
import org.aspectj.compiler.base.ast.CodeDec;
import org.aspectj.compiler.base.ast.CompilationUnit;
import org.aspectj.compiler.base.ast.ConstructorDec;
import org.aspectj.compiler.base.ast.Decs;
import org.aspectj.compiler.base.ast.DoubleLiteralExpr;
import org.aspectj.compiler.base.ast.DummySourceLocation;
import org.aspectj.compiler.base.ast.FieldDec;
import org.aspectj.compiler.base.ast.FloatLiteralExpr;
import org.aspectj.compiler.base.ast.FormalDec;
import org.aspectj.compiler.base.ast.Formals;
import org.aspectj.compiler.base.ast.IntLiteralExpr;
import org.aspectj.compiler.base.ast.InterfaceDec;
import org.aspectj.compiler.base.ast.LazyNameTypeD;
import org.aspectj.compiler.base.ast.LiteralExpr;
import org.aspectj.compiler.base.ast.LongLiteralExpr;
import org.aspectj.compiler.base.ast.MethodDec;
import org.aspectj.compiler.base.ast.Modifiers;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.StringLiteralExpr;
import org.aspectj.compiler.base.ast.TextSourceLocation;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.TypeD;
import org.aspectj.compiler.base.ast.TypeDec;
import org.aspectj.compiler.base.ast.TypeDs;
import org.aspectj.compiler.base.bytecode.Attributes;
import org.aspectj.compiler.base.bytecode.ClassFile;
import org.aspectj.compiler.base.bytecode.ConstantPool;
import org.aspectj.compiler.base.parser.SourceInfo;

public class ASTConnection
extends CompilerObject {
    protected SourceLocation dummySource = new DummySourceLocation(this.getCompiler());
    static /* synthetic */ Class class$org$aspectj$compiler$base$bytecode$Attributes$InnerClassesAttribute;
    static /* synthetic */ Class class$org$aspectj$compiler$base$bytecode$Attributes$ConstantValueAttribute;

    public ASTConnection(JavaCompiler compiler) {
        super(compiler);
    }

    private TypeDs classesToTypeDs(ConstantPool.Class[] classes) {
        if (classes == null || classes.length == 0) {
            return null;
        }
        TypeDs names = new TypeDs(this.dummySource);
        int N = classes.length;
        int i = 0;
        while (i < N) {
            names.add(this.makeTypeD(classes[i]));
            ++i;
        }
        return names;
    }

    public TypeDec makeTypeDec(ClassFile classFile) {
        String fullName;
        int modifiers = classFile.modifiers;
        boolean isInterface = Modifier.isInterface(modifiers);
        modifiers &= 0xFFFFFDFF;
        Decs body = new Decs(this.dummySource);
        String name = fullName = classFile.thisClass.getName();
        String packageName = null;
        int dot = fullName.lastIndexOf(46);
        if (dot != -1) {
            packageName = fullName.substring(0, dot);
            name = fullName.substring(dot + 1);
        }
        String id = name;
        String enclosingName = null;
        int dollar = id.lastIndexOf(36);
        if (dollar != -1) {
            name = id.substring(dollar + 1);
            enclosingName = id.substring(0, dollar);
        }
        CompilationUnit cu = new CompilationUnit(this.dummySource, packageName, null, new Decs(this.dummySource), new SourceInfo(null, null), true);
        TextSourceLocation loc = new TextSourceLocation(cu, -1, -1);
        TypeD superClass = classFile.superClass == null ? null : this.makeTypeD(classFile.superClass);
        TypeDs _implements = this.classesToTypeDs(classFile.interfaces);
        TypeDec typeDec = isInterface ? this.getAST().makeInterface(this.getAST().makeModifiers(modifiers), name, _implements) : this.getAST().makeClass(this.getAST().makeModifiers(modifiers), name, superClass, _implements);
        typeDec.setBody(body);
        typeDec.setSourceLocation(loc);
        if (enclosingName != null) {
            Type t = this.getTypeManager().getType(packageName, enclosingName);
            t.getTypeDec().getBody().add(typeDec);
            typeDec.setEnclosingTypeDec(t.getTypeDec());
        } else {
            cu.getDecs().add(typeDec);
        }
        int i = 0;
        while (i < classFile.fields.length) {
            FieldDec dec = this.makeFieldDec(classFile.fields[i]);
            dec.setSourceLocation(loc);
            body.add(dec);
            ++i;
        }
        int i2 = 0;
        while (i2 < classFile.methods.length) {
            CodeDec dec = this.makeCodeDec(classFile.methods[i2]);
            if (dec != null) {
                dec.setSourceLocation(loc);
                body.add(dec);
            }
            ++i2;
        }
        Attributes.InnerClassesAttribute attr = (Attributes.InnerClassesAttribute)classFile.attributes.findAttribute(class$org$aspectj$compiler$base$bytecode$Attributes$InnerClassesAttribute == null ? (class$org$aspectj$compiler$base$bytecode$Attributes$InnerClassesAttribute = ASTConnection.class$("org.aspectj.compiler.base.bytecode.Attributes$InnerClassesAttribute")) : class$org$aspectj$compiler$base$bytecode$Attributes$InnerClassesAttribute);
        if (attr != null) {
            typeDec.memberTypeNames = attr.getContainedTypeNames(fullName);
            if (!attr.isPackageLevel(fullName)) {
                Modifiers m = new Modifiers(this.dummySource, attr.getModifiers(fullName));
                typeDec.setModifiers(m);
                if (!m.isStatic() && !(typeDec instanceof InterfaceDec)) {
                    ListIterator i3 = typeDec.getBody().iterator();
                    while (i3.hasNext()) {
                        Object dec = i3.next();
                        if (!(dec instanceof ConstructorDec)) continue;
                        ConstructorDec cdec = (ConstructorDec)dec;
                        Formals f = cdec.getFormals();
                        cdec.setEnclosingInstanceFormal(f.get(0));
                        f.remove(0);
                    }
                    typeDec.setInnerDiscoveries(false, true, false);
                } else {
                    typeDec.setInnerDiscoveries(false, false, false);
                }
            } else {
                typeDec.setInnerDiscoveries(true, false, false);
            }
        } else {
            typeDec.setInnerDiscoveries(true, false, false);
        }
        return typeDec;
    }

    public TypeD makeTypeD(ConstantPool.Class cpClass) {
        String name = cpClass.getName();
        int lastDot = name.lastIndexOf(46);
        if (lastDot == -1) {
            return new LazyNameTypeD(this.dummySource, null, name);
        }
        return new LazyNameTypeD(this.dummySource, name.substring(0, lastDot), name.substring(lastDot + 1));
    }

    public FieldDec makeFieldDec(ClassFile.FieldInfo field) {
        int modifiers = field.modifiers;
        TypeD typeD = this.makeTypeD(field.descriptor.value);
        String name = field.name.value;
        LiteralExpr initializer = null;
        Attributes.ConstantValueAttribute attr = (Attributes.ConstantValueAttribute)field.attributes.findAttribute(class$org$aspectj$compiler$base$bytecode$Attributes$ConstantValueAttribute == null ? (class$org$aspectj$compiler$base$bytecode$Attributes$ConstantValueAttribute = ASTConnection.class$("org.aspectj.compiler.base.bytecode.Attributes$ConstantValueAttribute")) : class$org$aspectj$compiler$base$bytecode$Attributes$ConstantValueAttribute);
        if (attr != null) {
            ConstantPool.Entry entry = attr.value;
            if (entry instanceof ConstantPool.String) {
                ConstantPool.String stringEntry = (ConstantPool.String)entry;
                initializer = new StringLiteralExpr(this.dummySource, stringEntry.value.value);
            } else if (entry instanceof ConstantPool.Float) {
                ConstantPool.Float floatEntry = (ConstantPool.Float)entry;
                initializer = new FloatLiteralExpr(this.dummySource, floatEntry.value);
            } else if (entry instanceof ConstantPool.Long) {
                ConstantPool.Long longEntry = (ConstantPool.Long)entry;
                initializer = new LongLiteralExpr(this.dummySource, longEntry.value);
            } else if (entry instanceof ConstantPool.Double) {
                ConstantPool.Double doubleEntry = (ConstantPool.Double)entry;
                initializer = new DoubleLiteralExpr(this.dummySource, doubleEntry.value);
            } else {
                ConstantPool.Integer intEntry = (ConstantPool.Integer)entry;
                int init = intEntry.value;
                initializer = typeD.getType().isBoolean() ? new BooleanLiteralExpr(this.dummySource, init != 0) : new IntLiteralExpr(this.dummySource, init);
            }
        }
        return new FieldDec(this.dummySource, new Modifiers(this.dummySource, modifiers), typeD, name, initializer);
    }

    public CodeDec makeCodeDec(ClassFile.MethodInfo method) {
        int modifiers = method.modifiers;
        String name = method.name.value;
        TypeDs _throws = this.classesToTypeDs(method.getExceptions());
        Formals formals = this.getFormals(method.descriptor.value);
        if (name.equals("<init>")) {
            ConstructorDec ret = new ConstructorDec(this.dummySource, new Modifiers(this.dummySource, modifiers), formals, _throws, null);
            if (method.isDeprecated()) {
                ret.setDeprecated(true);
            }
            return ret;
        }
        if (name.equals("<clinit>")) {
            return null;
        }
        TypeD typeD = this.getReturnTypeD(method.descriptor.value);
        MethodDec ret = new MethodDec(this.dummySource, new Modifiers(this.dummySource, modifiers), typeD, name, formals, _throws, null);
        if (method.isDeprecated()) {
            ret.setDeprecated(true);
        }
        return ret;
    }

    TypeD getReturnTypeD(String descriptor) {
        int lastParen = descriptor.lastIndexOf(41);
        return this.makeTypeD(descriptor.substring(lastParen + 1));
    }

    TypeD readNameTypeD(IndexedChars ic) {
        int startIndex;
        char[] chars = ic.chars;
        int endIndex = startIndex = ic.index;
        int idStart = startIndex;
        while (endIndex < chars.length) {
            if (chars[endIndex] == '/') {
                chars[endIndex] = 46;
                idStart = endIndex + 1;
            }
            if (chars[endIndex] == ';') break;
            ++endIndex;
        }
        String id = new String(chars, idStart, endIndex - idStart);
        String pname = idStart == startIndex ? null : new String(chars, startIndex, idStart - startIndex - 1);
        ic.index = endIndex + 1;
        return new LazyNameTypeD(this.dummySource, pname, id);
    }

    TypeD readTypeD(IndexedChars ic) {
        switch (ic.read()) {
            case 'B': {
                return this.getTypeManager().byteType.makeTypeD();
            }
            case 'C': {
                return this.getTypeManager().charType.makeTypeD();
            }
            case 'D': {
                return this.getTypeManager().doubleType.makeTypeD();
            }
            case 'F': {
                return this.getTypeManager().floatType.makeTypeD();
            }
            case 'I': {
                return this.getTypeManager().intType.makeTypeD();
            }
            case 'J': {
                return this.getTypeManager().longType.makeTypeD();
            }
            case 'S': {
                return this.getTypeManager().shortType.makeTypeD();
            }
            case 'Z': {
                return this.getTypeManager().booleanType.makeTypeD();
            }
            case 'V': {
                return this.getTypeManager().voidType.makeTypeD();
            }
            case '[': {
                return new ArrayTypeD(this.dummySource, this.readTypeD(ic));
            }
            case 'L': {
                return this.readNameTypeD(ic);
            }
        }
        throw new RuntimeException("unknown descriptor: " + ic.chars[ic.index - 1] + " in " + new String(ic.chars));
    }

    Formals getFormals(String descriptor) {
        IndexedChars ic = new IndexedChars(descriptor.toCharArray());
        ++ic.index;
        ArrayList<FormalDec> formals = new ArrayList<FormalDec>();
        int n = 0;
        while (ic.chars[ic.index] != ')') {
            FormalDec formal = new FormalDec(this.dummySource, new Modifiers(this.dummySource, 0), this.readTypeD(ic), "__" + n, null);
            ++n;
            formals.add(formal);
        }
        return new Formals(this.dummySource, formals.toArray(new FormalDec[formals.size()]));
    }

    public TypeD makeTypeD(String descriptor) {
        return this.readTypeD(new IndexedChars(descriptor.toCharArray()));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class IndexedChars {
        char[] chars;
        int index;

        public IndexedChars(char[] chars) {
            this.chars = chars;
            this.index = 0;
        }

        public char read() {
            return this.chars[this.index++];
        }

        public String readTo(char end) {
            int j = this.index;
            while (j < this.chars.length) {
                if (this.chars[j] == end) {
                    String ret = new String(this.chars, this.index, j - this.index);
                    this.index = j + 1;
                    return ret;
                }
                ++j;
            }
            String ret = new String(this.chars, this.index, this.chars.length - this.index);
            this.index = this.chars.length;
            return ret;
        }
    }
}

