/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.bcg.pool;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.compiler.base.bcg.pool.Constant;
import org.aspectj.compiler.base.bcg.pool.ConstantPool;

public class Utf8Constant
extends Constant {
    public String value;

    Utf8Constant() {
    }

    Utf8Constant(String value) {
        this.value = value;
    }

    void writeTo(DataOutputStream stream) throws IOException {
        stream.writeByte(1);
        stream.writeUTF(this.value);
    }

    public String toString() {
        return Constant.rep(this.getIndex(), "\"" + this.value + "\"");
    }

    public boolean equals(Object other) {
        if (!(other instanceof Utf8Constant)) {
            return false;
        }
        Utf8Constant o = (Utf8Constant)other;
        return this.value.equals(o.value);
    }

    public int hashCode() {
        return this.value.hashCode() + 1;
    }

    void readFrom(DataInputStream stream, ConstantPool pool) throws IOException {
        this.value = stream.readUTF();
    }
}

