/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.bcg.pool;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.compiler.base.bcg.pool.ConstantPool;

public abstract class Constant
implements Comparable {
    static final byte UTF_TAG = 1;
    static final byte INT_TAG = 3;
    static final byte FLOAT_TAG = 4;
    static final byte LONG_TAG = 5;
    static final byte DOUBLE_TAG = 6;
    static final byte CLASS_TAG = 7;
    static final byte STRING_TAG = 8;
    static final byte FIELD_REF_TAG = 9;
    static final byte METHOD_REF_TAG = 10;
    static final byte INTERFACE_METHOD_REF_TAG = 11;
    static final byte NAME_AND_TYPE_TAG = 12;
    private int index = 0;
    private int popularity = 0;

    public void makePopular() {
        ++this.popularity;
    }

    void setIndex(int index) {
        this.index = index;
    }

    public short getIndex() {
        return (short)this.index;
    }

    public void writeIndex(DataOutputStream stream) throws IOException {
        stream.writeShort((short)this.index);
    }

    public void writeBriefIndex(DataOutputStream stream) throws IOException {
        stream.writeByte((byte)this.index);
    }

    abstract void writeTo(DataOutputStream var1) throws IOException;

    abstract void readFrom(DataInputStream var1, ConstantPool var2) throws IOException;

    public int compareTo(Object o) {
        int other = ((Constant)o).popularity;
        return this.popularity > other ? 1 : (this.popularity == other ? 0 : -1);
    }

    boolean isBig() {
        return false;
    }

    public void display(int indent, boolean inline) {
        System.err.print(this);
    }

    static String rep(int index, String x) {
        return x + ":" + Integer.toHexString(index);
    }
}

