/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.bcg;

import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.compiler.base.bcg.Asserts;
import org.aspectj.compiler.base.bcg.Code;
import org.aspectj.compiler.base.bcg.CodeBuilder;

public class Label {
    boolean anchored;
    Code target;
    static int labelCount = 0;
    int myLabelNum = -1;

    Label(boolean anchored) {
        this.anchored = anchored;
    }

    boolean isAnchored() {
        return this.anchored;
    }

    void setTarget(Code target) {
        this.target = target;
        target.addLabel(this);
    }

    Code getTarget() {
        return this.target;
    }

    int getPc() {
        return this.target.getPc();
    }

    void writeRelativeShort(int src, DataOutputStream stream) throws IOException {
        int relative = this.target.getPc() - src;
        if (!Asserts.isShort(relative)) {
            throw new CodeBuilder.TooWideJumpException();
        }
        stream.writeShort((short)relative);
    }

    void writeRelativeInt(int src, DataOutputStream stream) throws IOException {
        long relative = this.target.getPc() - src;
        stream.writeInt((int)relative);
    }

    public String toString() {
        if (this.getTarget().getPc() != -1) {
            return "" + this.getTarget().getPc();
        }
        Label l = (Label)this.getTarget().getLabels().get(0);
        if (l.myLabelNum == -1) {
            l.myLabelNum = labelCount++;
        }
        return "_" + l.myLabelNum;
    }
}

