/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.bcg;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Modifier;
import org.aspectj.compiler.base.bcg.Attributes;
import org.aspectj.compiler.base.bcg.ClassfileBuilder;
import org.aspectj.compiler.base.bcg.pool.Constant;
import org.aspectj.compiler.base.bcg.pool.ConstantPool;

public final class FieldBuilder {
    ConstantPool pool;
    Attributes attributes;
    int accessFlags = 0;
    Constant name;
    Constant descriptor;

    FieldBuilder(ClassfileBuilder cfb) {
        this.pool = cfb.pool;
        this.attributes = new Attributes(this.pool);
    }

    public void writeTo(DataOutputStream stream) throws IOException {
        stream.writeShort((short)this.accessFlags);
        this.name.writeIndex(stream);
        this.descriptor.writeIndex(stream);
        this.attributes.writeTo(stream);
    }

    public String toString() {
        return "(field " + Modifier.toString(this.accessFlags) + " " + this.name + " " + this.descriptor + " " + this.attributes + ")";
    }

    void display(int indent, boolean inline) {
        System.err.print("(field ");
        this.name.display(0, true);
        System.err.print(" ");
        this.descriptor.display(0, true);
        FieldBuilder.between(indent += 2, inline);
        System.err.print("(modifiers " + Modifier.toString(this.accessFlags) + ")");
        FieldBuilder.between(indent, inline);
        this.attributes.display(indent, inline);
        System.err.print(")");
    }

    static void between(int indent, boolean inline) {
        if (inline) {
            System.err.print(" ");
        } else {
            System.err.println();
            int s = indent;
            while (s >= 0) {
                System.err.print(" ");
                --s;
            }
        }
    }

    public void addAccessFlags(int newFlags) {
        this.accessFlags |= newFlags;
    }

    public void setName(String name) {
        this.name = this.pool.addUtf8(name);
    }

    public void setDescriptor(String descriptor) {
        this.descriptor = this.pool.addUtf8(descriptor);
    }

    public void setDeprecated() {
        this.attributes.addDeprecatedAttribute();
    }

    public void setSynthetic() {
        this.attributes.addSyntheticAttribute();
    }

    public void setConstantValue(boolean b) {
        this.attributes.addConstantValueAttribute(this.pool.addInt(b ? 1 : 0));
    }

    public void setConstantValue(String s) {
        this.attributes.addConstantValueAttribute(this.pool.addString(s));
    }

    public void setConstantValue(int i) {
        this.attributes.addConstantValueAttribute(this.pool.addInt(i));
    }

    public void setConstantValue(float f) {
        this.attributes.addConstantValueAttribute(this.pool.addFloat(f));
    }

    public void setConstantValue(long l) {
        this.attributes.addConstantValueAttribute(this.pool.addLong(l));
    }

    public void setConstantValue(double d) {
        this.attributes.addConstantValueAttribute(this.pool.addDouble(d));
    }

    FieldBuilder readFrom(DataInputStream stream) throws IOException {
        this.accessFlags = stream.readUnsignedShort();
        this.name = this.pool.get(stream.readUnsignedShort());
        this.descriptor = this.pool.get(stream.readUnsignedShort());
        this.attributes.readFrom(stream);
        return this;
    }
}

