/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.bcg;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.aspectj.compiler.base.JavaCompiler;
import org.aspectj.compiler.base.ast.ArrayType;
import org.aspectj.compiler.base.ast.ControlContext;
import org.aspectj.compiler.base.ast.NameType;
import org.aspectj.compiler.base.ast.RefType;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Stmt;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.VarDec;
import org.aspectj.compiler.base.ast.WindingStmt;
import org.aspectj.compiler.base.bcg.Asserts;
import org.aspectj.compiler.base.bcg.Attributes;
import org.aspectj.compiler.base.bcg.ClassfileBuilder;
import org.aspectj.compiler.base.bcg.Code;
import org.aspectj.compiler.base.bcg.Label;
import org.aspectj.compiler.base.bcg.pool.Constant;
import org.aspectj.compiler.base.bcg.pool.ConstantPool;

public final class CodeBuilder {
    private boolean isResolvedFlag = false;
    ConstantPool pool;
    ClassfileBuilder cfb;
    Attributes attributes;
    int maxFrame;
    int maxStack = 0;
    int stackSize = 0;
    List starts = new ArrayList();
    List ends = new ArrayList();
    List handlers = new ArrayList();
    List names = new ArrayList();
    List codes = new ArrayList();
    Code[] codea;
    List labels = new ArrayList();
    private ControlContext context = new ControlContext();
    private Map breakLabels = new HashMap();
    private Map continueLabels = new HashMap();
    private Map windingLabels = new HashMap();
    private Stack localVarStack = new Stack();
    private LocalVar localVars = null;
    LineNumber lineNumbers = null;
    JumpCode prevJump = null;
    private int endPc;
    static final boolean DEBUG = false;
    private final byte[] aloads = new byte[]{42, 43, 44, 45, 25};
    private final byte[] iloads = new byte[]{26, 27, 28, 29, 21};
    private final byte[] lloads = new byte[]{30, 31, 32, 33, 22};
    private final byte[] floads = new byte[]{34, 35, 36, 37, 23};
    private final byte[] dloads = new byte[]{38, 39, 40, 41, 24};
    private final byte[] astores = new byte[]{75, 76, 77, 78, 58};
    private final byte[] istores = new byte[]{59, 60, 61, 62, 54};
    private final byte[] lstores = new byte[]{63, 64, 65, 66, 55};
    private final byte[] fstores = new byte[]{67, 68, 69, 70, 56};
    private final byte[] dstores = new byte[]{71, 72, 73, 74, 57};
    int labelCount = 0;
    protected static final byte NOP = 0;
    protected static final byte ACONST_NULL = 1;
    protected static final byte ICONST_M1 = 2;
    protected static final byte ICONST_0 = 3;
    protected static final byte ICONST_1 = 4;
    protected static final byte ICONST_2 = 5;
    protected static final byte ICONST_3 = 6;
    protected static final byte ICONST_4 = 7;
    protected static final byte ICONST_5 = 8;
    protected static final byte LCONST_0 = 9;
    protected static final byte LCONST_1 = 10;
    protected static final byte FCONST_0 = 11;
    protected static final byte FCONST_1 = 12;
    protected static final byte FCONST_2 = 13;
    protected static final byte DCONST_0 = 14;
    protected static final byte DCONST_1 = 15;
    protected static final byte ILOAD_0 = 26;
    protected static final byte ILOAD_1 = 27;
    protected static final byte ILOAD_2 = 28;
    protected static final byte ILOAD_3 = 29;
    protected static final byte LLOAD_0 = 30;
    protected static final byte LLOAD_1 = 31;
    protected static final byte LLOAD_2 = 32;
    protected static final byte LLOAD_3 = 33;
    protected static final byte FLOAD_0 = 34;
    protected static final byte FLOAD_1 = 35;
    protected static final byte FLOAD_2 = 36;
    protected static final byte FLOAD_3 = 37;
    protected static final byte DLOAD_0 = 38;
    protected static final byte DLOAD_1 = 39;
    protected static final byte DLOAD_2 = 40;
    protected static final byte DLOAD_3 = 41;
    protected static final byte ALOAD_0 = 42;
    protected static final byte ALOAD_1 = 43;
    protected static final byte ALOAD_2 = 44;
    protected static final byte ALOAD_3 = 45;
    protected static final byte IALOAD = 46;
    protected static final byte LALOAD = 47;
    protected static final byte FALOAD = 48;
    protected static final byte DALOAD = 49;
    protected static final byte AALOAD = 50;
    protected static final byte BALOAD = 51;
    protected static final byte CALOAD = 52;
    protected static final byte SALOAD = 53;
    protected static final byte ISTORE_0 = 59;
    protected static final byte ISTORE_1 = 60;
    protected static final byte ISTORE_2 = 61;
    protected static final byte ISTORE_3 = 62;
    protected static final byte LSTORE_0 = 63;
    protected static final byte LSTORE_1 = 64;
    protected static final byte LSTORE_2 = 65;
    protected static final byte LSTORE_3 = 66;
    protected static final byte FSTORE_0 = 67;
    protected static final byte FSTORE_1 = 68;
    protected static final byte FSTORE_2 = 69;
    protected static final byte FSTORE_3 = 70;
    protected static final byte DSTORE_0 = 71;
    protected static final byte DSTORE_1 = 72;
    protected static final byte DSTORE_2 = 73;
    protected static final byte DSTORE_3 = 74;
    protected static final byte ASTORE_0 = 75;
    protected static final byte ASTORE_1 = 76;
    protected static final byte ASTORE_2 = 77;
    protected static final byte ASTORE_3 = 78;
    protected static final byte IASTORE = 79;
    protected static final byte LASTORE = 80;
    protected static final byte FASTORE = 81;
    protected static final byte DASTORE = 82;
    protected static final byte AASTORE = 83;
    protected static final byte BASTORE = 84;
    protected static final byte CASTORE = 85;
    protected static final byte SASTORE = 86;
    protected static final byte POP = 87;
    protected static final byte POP2 = 88;
    protected static final byte DUP = 89;
    protected static final byte DUP_X1 = 90;
    protected static final byte DUP_X2 = 91;
    protected static final byte DUP2 = 92;
    protected static final byte DUP2_X1 = 93;
    protected static final byte DUP2_X2 = 94;
    protected static final byte SWAP = 95;
    protected static final byte IADD = 96;
    protected static final byte LADD = 97;
    protected static final byte FADD = 98;
    protected static final byte DADD = 99;
    protected static final byte ISUB = 100;
    protected static final byte LSUB = 101;
    protected static final byte FSUB = 102;
    protected static final byte DSUB = 103;
    protected static final byte IMUL = 104;
    protected static final byte LMUL = 105;
    protected static final byte FMUL = 106;
    protected static final byte DMUL = 107;
    protected static final byte IDIV = 108;
    protected static final byte LDIV = 109;
    protected static final byte FDIV = 110;
    protected static final byte DDIV = 111;
    protected static final byte IREM = 112;
    protected static final byte LREM = 113;
    protected static final byte FREM = 114;
    protected static final byte DREM = 115;
    protected static final byte INEG = 116;
    protected static final byte LNEG = 117;
    protected static final byte FNEG = 118;
    protected static final byte DNEG = 119;
    protected static final byte ISHL = 120;
    protected static final byte LSHL = 121;
    protected static final byte ISHR = 122;
    protected static final byte LSHR = 123;
    protected static final byte IUSHR = 124;
    protected static final byte LUSHR = 125;
    protected static final byte IAND = 126;
    protected static final byte LAND = 127;
    protected static final byte IOR = -128;
    protected static final byte LOR = -127;
    protected static final byte IXOR = -126;
    protected static final byte LXOR = -125;
    protected static final byte I2L = -123;
    protected static final byte I2F = -122;
    protected static final byte I2D = -121;
    protected static final byte L2I = -120;
    protected static final byte L2F = -119;
    protected static final byte L2D = -118;
    protected static final byte F2I = -117;
    protected static final byte F2L = -116;
    protected static final byte F2D = -115;
    protected static final byte D2I = -114;
    protected static final byte D2L = -113;
    protected static final byte D2F = -112;
    protected static final byte I2B = -111;
    protected static final byte I2C = -110;
    protected static final byte I2S = -109;
    protected static final byte LCMP = -108;
    protected static final byte FCMPL = -107;
    protected static final byte FCMPG = -106;
    protected static final byte DCMPL = -105;
    protected static final byte DCMPG = -104;
    protected static final byte IRETURN = -84;
    protected static final byte LRETURN = -83;
    protected static final byte FRETURN = -82;
    protected static final byte DRETURN = -81;
    protected static final byte ARETURN = -80;
    protected static final byte RETURN = -79;
    protected static final byte ARRAYLENGTH = -66;
    protected static final byte ATHROW = -65;
    protected static final byte MONITORENTER = -62;
    protected static final byte MONITOREXIT = -61;
    protected static final byte BIPUSH = 16;
    protected static final byte NEWARRAY = -68;
    protected static final byte ILOAD = 21;
    protected static final byte LLOAD = 22;
    protected static final byte FLOAD = 23;
    protected static final byte DLOAD = 24;
    protected static final byte ALOAD = 25;
    protected static final byte ISTORE = 54;
    protected static final byte LSTORE = 55;
    protected static final byte FSTORE = 56;
    protected static final byte DSTORE = 57;
    protected static final byte ASTORE = 58;
    protected static final byte RET = -87;
    protected static final byte SIPUSH = 17;
    protected static final byte LDC = 18;
    protected static final byte LDC_W = 19;
    protected static final byte LDC2_W = 20;
    protected static final byte GETSTATIC = -78;
    protected static final byte PUTSTATIC = -77;
    protected static final byte GETFIELD = -76;
    protected static final byte PUTFIELD = -75;
    protected static final byte INVOKEVIRTUAL = -74;
    protected static final byte INVOKESPECIAL = -73;
    protected static final byte INVOKESTATIC = -72;
    protected static final byte INVOKEINTERFACE = -71;
    protected static final byte ANEWARRAY = -67;
    protected static final byte NEW = -69;
    protected static final byte CHECKCAST = -64;
    protected static final byte INSTANCEOF = -63;
    protected static final byte MULTIANEWARRAY = -59;
    protected static final byte IFEQ = -103;
    protected static final byte IFNE = -102;
    protected static final byte IFLT = -101;
    protected static final byte IFGE = -100;
    protected static final byte IFGT = -99;
    protected static final byte IFLE = -98;
    protected static final byte IF_ICMPEQ = -97;
    protected static final byte IF_ICMPNE = -96;
    protected static final byte IF_ICMPLT = -95;
    protected static final byte IF_ICMPGE = -94;
    protected static final byte IF_ICMPGT = -93;
    protected static final byte IF_ICMPLE = -92;
    protected static final byte IF_ACMPEQ = -91;
    protected static final byte IF_ACMPNE = -90;
    protected static final byte IFNULL = -58;
    protected static final byte IFNONNULL = -57;
    protected static final byte GOTO = -89;
    protected static final byte JSR = -88;
    protected static final byte GOTO_W = -56;
    protected static final byte JSR_W = -55;
    protected static final byte TABLESWITCH = -86;
    protected static final byte LOOKUPSWITCH = -85;
    protected static final byte IINC = -124;
    protected static final byte WIDE = -60;
    protected static final byte XXXUNUSEDXXX1 = -70;
    protected static final byte BREAKPOINT = -54;
    protected static final byte IMPDEP1 = -2;
    protected static final byte IMPDEP2 = -1;

    public boolean isResolved() {
        return this.isResolvedFlag;
    }

    CodeBuilder(ClassfileBuilder cfb) {
        this.cfb = cfb;
        this.pool = cfb.pool;
        this.attributes = new Attributes(this.pool);
    }

    public JavaCompiler getCompiler() {
        return this.cfb.getCompiler();
    }

    public void setMaxFrame(int maxFrame) {
        this.maxFrame = maxFrame;
    }

    public int getStackSize() {
        return this.stackSize;
    }

    public void pushStack(int delta) {
        this.stackSize += delta;
        this.stackInvariant();
    }

    public void adjustStack(int delta) {
        this.pushStack(delta);
    }

    public void popStack(int delta) {
        this.stackSize -= delta;
    }

    public void setStackSize(int ss) {
        this.stackSize = ss;
        this.stackInvariant();
    }

    public void clearStack() {
        this.stackSize = 0;
    }

    private void stackInvariant() {
        if (this.stackSize > this.maxStack) {
            this.maxStack = this.stackSize;
        }
    }

    public void enterNonWindingContext(Stmt s, Label b, Label c) {
        this.context.enter(s);
        this.breakLabels.put(s, b);
        if (c != null) {
            this.continueLabels.put(s, c);
        }
    }

    public void enterWindingContext(Stmt s, Label w) {
        this.context.enter(s);
        this.windingLabels.put(s, w);
    }

    public void leaveContext() {
        this.context.exit();
    }

    public void doBreak(String label) {
        Stmt target = this.context.getBreakTarget(label);
        this.doJsrUntil(target);
        this.emitJump((Label)this.breakLabels.get(target));
    }

    public void doContinue(String label) {
        Stmt target = this.context.getContinueTarget(label);
        this.doJsrUntil(target);
        this.emitJump((Label)this.continueLabels.get(target));
    }

    private void doJsrUntil(Stmt target) {
        Iterator i = this.context.getWindsUntil(target);
        while (i.hasNext()) {
            this.emitJSR((Label)this.windingLabels.get(i.next()));
        }
    }

    public void doReturn(Type t) {
        Iterator i = this.context.getWindsUntil(null);
        while (i.hasNext()) {
            WindingStmt w = (WindingStmt)i.next();
            int rvl = w.getRetValLoc();
            t.emitStore(this, rvl);
            this.emitJSR((Label)this.windingLabels.get(w));
            t.emitLoad(this, rvl);
        }
        t.emitReturn(this);
    }

    public void enterBlock() {
        this.localVarStack.push(null);
        this.localVarStack.push(null);
    }

    public void enterVar(VarDec v) {
        Label start = this.genAnchor();
        this.emitLabel(start);
        this.localVarStack.push(v);
        this.localVarStack.push(start);
    }

    public void exitBlock() {
        Label start = (Label)this.localVarStack.pop();
        VarDec v = (VarDec)this.localVarStack.pop();
        while (v != null) {
            Label end = this.genAnchor();
            this.emitLabel(end);
            this.localVars = new LocalVar(start, end, this.pool.addUtf8(v.getBytecodeId()), this.pool.addUtf8(v.getDescriptor()), v.getFrameLoc(), this.localVars);
            start = (Label)this.localVarStack.pop();
            v = (VarDec)this.localVarStack.pop();
        }
    }

    void createLocalAttribute() {
        int size = 0;
        LocalVar in = this.localVars;
        while (in != null) {
            ++size;
            in = in.next;
        }
        if (size == 0) {
            return;
        }
        Label[] starts = new Label[size];
        Label[] ends = new Label[size];
        Constant[] names = new Constant[size];
        Constant[] descriptors = new Constant[size];
        int[] indices = new int[size];
        LocalVar lvs = this.localVars;
        int i = 0;
        while (lvs != null) {
            starts[i] = lvs.start;
            ends[i] = lvs.end;
            names[i] = lvs.name;
            descriptors[i] = lvs.descriptor;
            indices[i] = lvs.index;
            ++i;
            lvs = lvs.next;
        }
        this.attributes.addLocalVariableTableAttribute(starts, ends, names, descriptors, indices);
    }

    public void enterLocation(SourceLocation loc) {
        ClassfileBuilder.SourceFile fileInfo = this.cfb.getSourceFile(loc);
        if (fileInfo == null) {
            return;
        }
        int currLine = loc.getBeginLine();
        if (this.lineNumbers != null) {
            if (currLine == -1) {
                return;
            }
            if (currLine == this.lineNumbers.line && fileInfo == this.lineNumbers.fileInfo) {
                return;
            }
        }
        Label pc = this.genAnchor();
        this.emitLabel(pc);
        this.lineNumbers = new LineNumber(fileInfo, pc, currLine, this.lineNumbers);
    }

    void createLineAttribute() {
        int endPc = this.getEndPc();
        int size = 0;
        LineNumber in = this.lineNumbers;
        LineNumber out = null;
        while (in != null) {
            if (in.pc.getPc() >= endPc) {
                in = in.next;
                continue;
            }
            in.line += in.fileInfo.offset;
            LineNumber temp = in.next;
            in.next = out;
            out = in;
            in = temp;
            ++size;
        }
        Label[] pcs = new Label[size];
        int[] lines = new int[size];
        int i = 0;
        while (i < size) {
            pcs[i] = out.pc;
            lines[i] = out.line;
            ++i;
            out = out.next;
        }
        this.attributes.addLineNumberTableAttribute(pcs, lines);
    }

    public void addHandler(Label start, Label end, Label handler, NameType exn) {
        this.starts.add(start);
        this.ends.add(end);
        this.handlers.add(handler);
        this.names.add(exn == null ? null : this.pool.addClass(exn));
    }

    void compressExceptionTable() {
        Iterator i = this.starts.iterator();
        Iterator j = this.ends.iterator();
        Iterator k = this.handlers.iterator();
        Iterator l = this.names.iterator();
        while (i.hasNext()) {
            if (((Label)i.next()).getPc() != ((Label)j.next()).getPc()) continue;
            k.next();
            l.next();
            i.remove();
            j.remove();
            k.remove();
            l.remove();
        }
    }

    void writeExceptionTableTo(DataOutputStream stream) throws IOException {
        stream.writeShort((short)this.starts.size());
        Iterator i = this.starts.iterator();
        Iterator j = this.ends.iterator();
        Iterator k = this.handlers.iterator();
        Iterator l = this.names.iterator();
        while (i.hasNext()) {
            stream.writeShort(((Label)i.next()).getPc());
            stream.writeShort(((Label)j.next()).getPc());
            stream.writeShort(((Label)k.next()).getPc());
            Constant name = (Constant)l.next();
            if (name == null) {
                stream.writeShort(0);
                continue;
            }
            name.writeIndex(stream);
        }
    }

    public void emitLabel(Label l) {
        if (this.isResolved()) {
            throw new RuntimeException("already resolved");
        }
        this.labels.add(l);
        if (this.prevJump != null && this.prevJump.getDest() == l) {
            this.labels.addAll(this.prevJump.getLabels());
            this.codes.remove(this.codes.size() - 1);
            this.prevJump = !this.codes.isEmpty() && this.codes.get(this.codes.size() - 1) instanceof JumpCode ? (JumpCode)this.codes.get(this.codes.size() - 1) : null;
        }
    }

    public Label genLabel() {
        return new Label(false);
    }

    public Label genAnchor() {
        return new Label(true);
    }

    private void addCode(Code c, int stackDelta) {
        this.addCode(c);
        this.adjustStack(stackDelta);
    }

    private void addCode(Code c) {
        if (this.isResolved()) {
            throw new RuntimeException("already resolved");
        }
        Iterator i = this.labels.iterator();
        while (i.hasNext()) {
            ((Label)i.next()).setTarget(c);
        }
        c.index = this.codes.size();
        this.labels.clear();
        this.codes.add(c);
        this.prevJump = null;
    }

    /*
     * Unable to fully structure code
     */
    public void resolve() {
        block10: {
            if (this.isResolved()) {
                throw new RuntimeException("already resolved");
            }
            if (!this.pool.isResolved()) {
                throw new RuntimeException("pool not resolved yet");
            }
            this.addCode(new SentinelCode());
            len = this.codes.size();
            a = new Code[len];
            i = 0;
            while (i < len) {
                a[i] = (Code)this.codes.get(i);
                ++i;
            }
            this.codea = a;
            this.codes = null;
            this.keelbackwards();
            pc = 0;
            try {
                i = 0;
                while (i < len) {
                    c = a[i];
                    pc = c.resolveBest(pc);
                    ++i;
                }
                sink = new DataOutputStream(new OutputStream(){

                    public void write(int b) {
                    }
                });
                try {
                    i = 0;
                    while (i < len) {
                        a[i].writeTo(sink);
                        ++i;
                    }
                    break block10;
                }
                catch (IOException e) {}
                break block10;
            }
            catch (TooWideJumpException e) {
                pc = 0;
                i = 0;
                ** while (i < len)
            }
lbl-1000:
            // 1 sources

            {
                c = a[i];
                pc = c.resolveWorst(pc);
                ++i;
                continue;
            }
        }
        this.endPc = pc;
        this.isResolvedFlag = true;
        this.createLineAttribute();
        this.createLocalAttribute();
        this.compressExceptionTable();
    }

    int getEndPc() {
        if (!this.isResolvedFlag) {
            throw new RuntimeException("not yet resolved");
        }
        return this.endPc;
    }

    private void keelbackwards() {
        Code[] a = this.codea;
        Code curr = a[a.length - 1];
        int i = a.length - 2;
        while (i >= 0) {
            Code next = curr;
            curr = a[i];
            curr.resolve(next.getRealNext());
            if (curr.jumps()) {
                next.notifyNonLive();
            }
            --i;
        }
    }

    int getByteSize() {
        return 4 + this.getCodeByteSize() + this.getExnTableByteSize() + this.attributes.getByteSize();
    }

    private int getCodeByteSize() {
        return 4 + this.getEndPc();
    }

    private int getExnTableByteSize() {
        return 2 + 8 * this.starts.size();
    }

    void writeTo(DataOutputStream stream) throws IOException {
        if (!this.isResolved()) {
            throw new RuntimeException("not yet resolved");
        }
        stream.writeShort((short)this.maxStack);
        stream.writeShort((short)this.maxFrame);
        this.writeCodeTo(stream);
        this.writeExceptionTableTo(stream);
        this.attributes.writeTo(stream);
    }

    private void writeCodeTo(DataOutputStream stream) throws IOException {
        stream.writeInt(this.getEndPc());
        Code[] a = this.codea;
        int i = 0;
        int len = a.length;
        while (i < len) {
            a[i].writeTo(stream);
            ++i;
        }
    }

    public void emitJump(Label dest) {
        JumpCode c = new JumpCode(dest);
        this.addCode(c);
        this.prevJump = c;
    }

    public void emitJSR(Label dest) {
        this.addCode(new JsrCode(dest));
    }

    public void emitRET(int n) {
        this.addCode(new FrameCode(-87, n), 0);
    }

    public void emitSwitch(int[] keys, Label[] cases, Label defaultCase) {
        long max = keys[keys.length - 1];
        long min = keys[0];
        if (2L + max - min + 1L <= (long)(1 + keys.length * 2)) {
            Label[] realCases = new Label[(int)(max - min + 1L)];
            int kv = (int)min;
            int ki = 0;
            int ci = 0;
            int oi = 0;
            while (kv <= (int)max) {
                if (kv == keys[ki]) {
                    realCases[oi] = cases[ci++];
                    ++ki;
                } else {
                    realCases[oi] = defaultCase;
                }
                ++kv;
                ++oi;
            }
            this.addCode(new TableSwitchCode((int)min, (int)max, realCases, defaultCase), -1);
        } else {
            this.addCode(new LookupSwitchCode(keys, cases, defaultCase), -1);
        }
    }

    public void emitINVOKESTATIC(NameType nameType, String name, String descriptor, int stackDelta) {
        this.addCode(new PoolCode(-72, this.pool.addMethodRef(nameType, name, descriptor)), stackDelta);
    }

    public void emitINVOKESPECIAL(NameType nameType, String name, String descriptor, int stackDelta) {
        this.addCode(new PoolCode(-73, this.pool.addMethodRef(nameType, name, descriptor)), stackDelta);
    }

    public void emitINVOKEINTERFACE(NameType nameType, String name, String descriptor, int stackDelta, int arglen) {
        this.addCode(new InvokeInterfaceCode(this.pool.addInterfaceMethodRef(nameType, name, descriptor), arglen), stackDelta);
    }

    public void emitINVOKEVIRTUAL(NameType nameType, String name, String descriptor, int stackDelta) {
        this.addCode(new PoolCode(-74, this.pool.addMethodRef(nameType, name, descriptor)), stackDelta);
    }

    public void emitGETSTATIC(NameType nameType, String name, String descriptor, int stackDelta) {
        this.addCode(new PoolCode(-78, this.pool.addFieldRef(nameType, name, descriptor)), stackDelta);
    }

    public void emitPUTSTATIC(NameType nameType, String name, String descriptor, int stackDelta) {
        this.addCode(new PoolCode(-77, this.pool.addFieldRef(nameType, name, descriptor)), stackDelta);
    }

    public void emitGETFIELD(NameType nameType, String name, String descriptor, int stackDelta) {
        this.addCode(new PoolCode(-76, this.pool.addFieldRef(nameType, name, descriptor)), stackDelta);
    }

    public void emitPUTFIELD(NameType nameType, String name, String descriptor, int stackDelta) {
        this.addCode(new PoolCode(-75, this.pool.addFieldRef(nameType, name, descriptor)), stackDelta);
    }

    public void emitNEW(NameType nameType) {
        this.addCode(new PoolCode(-69, this.pool.addClass(nameType)), 1);
    }

    public void emitCHECKCAST(RefType refType) {
        this.addCode(new PoolCode(-64, this.pool.addClass(refType)));
    }

    public void emitINSTANCEOF(RefType refType) {
        this.addCode(new PoolCode(-63, this.pool.addClass(refType)), 0);
    }

    public void emitIAND() {
        this.addCode(new BasicCode(126), -1);
    }

    public void emitLAND() {
        this.addCode(new BasicCode(127), -2);
    }

    public void emitNULL() {
        this.addCode(new BasicCode(1), 1);
    }

    public void emitI2L() {
        this.addCode(new BasicCode(-123), 1);
    }

    public void emitI2F() {
        this.addCode(new BasicCode(-122), 0);
    }

    public void emitI2D() {
        this.addCode(new BasicCode(-121), 1);
    }

    public void emitL2I() {
        this.addCode(new BasicCode(-120), -1);
    }

    public void emitL2F() {
        this.addCode(new BasicCode(-119), -1);
    }

    public void emitL2D() {
        this.addCode(new BasicCode(-118), 0);
    }

    public void emitF2I() {
        this.addCode(new BasicCode(-117), 0);
    }

    public void emitF2L() {
        this.addCode(new BasicCode(-116), 1);
    }

    public void emitF2D() {
        this.addCode(new BasicCode(-115), 1);
    }

    public void emitD2I() {
        this.addCode(new BasicCode(-114), -1);
    }

    public void emitD2L() {
        this.addCode(new BasicCode(-113), 0);
    }

    public void emitD2F() {
        this.addCode(new BasicCode(-112), -1);
    }

    public void emitI2B() {
        this.addCode(new BasicCode(-111), 0);
    }

    public void emitI2C() {
        this.addCode(new BasicCode(-110), 0);
    }

    public void emitI2S() {
        this.addCode(new BasicCode(-109), 0);
    }

    public void emitPOP() {
        this.addCode(new BasicCode(87), -1);
    }

    public void emitPOP2() {
        this.addCode(new BasicCode(88), -2);
    }

    public void emitLCMP() {
        this.addCode(new BasicCode(-108), -3);
    }

    public void emitFCMPL() {
        this.addCode(new BasicCode(-107), -1);
    }

    public void emitFCMPG() {
        this.addCode(new BasicCode(-106), -1);
    }

    public void emitDCMPL() {
        this.addCode(new BasicCode(-105), -3);
    }

    public void emitDCMPG() {
        this.addCode(new BasicCode(-104), -3);
    }

    public void emitNOP() {
        this.addCode(new BasicCode(0), 0);
    }

    public void emitACONST_NULL() {
        this.addCode(new BasicCode(1), 1);
    }

    public void emitIALOAD() {
        this.addCode(new BasicCode(46), -1);
    }

    public void emitLALOAD() {
        this.addCode(new BasicCode(47), 0);
    }

    public void emitFALOAD() {
        this.addCode(new BasicCode(48), -1);
    }

    public void emitDALOAD() {
        this.addCode(new BasicCode(49), 0);
    }

    public void emitAALOAD() {
        this.addCode(new BasicCode(50), -1);
    }

    public void emitBALOAD() {
        this.addCode(new BasicCode(51), -1);
    }

    public void emitCALOAD() {
        this.addCode(new BasicCode(52), -1);
    }

    public void emitSALOAD() {
        this.addCode(new BasicCode(53), -1);
    }

    public void emitIASTORE() {
        this.addCode(new BasicCode(79), -3);
    }

    public void emitLASTORE() {
        this.addCode(new BasicCode(80), -4);
    }

    public void emitFASTORE() {
        this.addCode(new BasicCode(81), -3);
    }

    public void emitDASTORE() {
        this.addCode(new BasicCode(82), -4);
    }

    public void emitAASTORE() {
        this.addCode(new BasicCode(83), -3);
    }

    public void emitBASTORE() {
        this.addCode(new BasicCode(84), -3);
    }

    public void emitCASTORE() {
        this.addCode(new BasicCode(85), -3);
    }

    public void emitSASTORE() {
        this.addCode(new BasicCode(86), -3);
    }

    public void emitSWAP() {
        this.addCode(new BasicCode(95), 0);
    }

    public void emitIADD() {
        this.addCode(new BasicCode(96), -1);
    }

    public void emitLADD() {
        this.addCode(new BasicCode(97), -2);
    }

    public void emitFADD() {
        this.addCode(new BasicCode(98), -1);
    }

    public void emitDADD() {
        this.addCode(new BasicCode(99), -2);
    }

    public void emitISUB() {
        this.addCode(new BasicCode(100), -1);
    }

    public void emitLSUB() {
        this.addCode(new BasicCode(101), -2);
    }

    public void emitFSUB() {
        this.addCode(new BasicCode(102), -1);
    }

    public void emitDSUB() {
        this.addCode(new BasicCode(103), -2);
    }

    public void emitIMUL() {
        this.addCode(new BasicCode(104), -1);
    }

    public void emitLMUL() {
        this.addCode(new BasicCode(105), -2);
    }

    public void emitFMUL() {
        this.addCode(new BasicCode(106), -1);
    }

    public void emitDMUL() {
        this.addCode(new BasicCode(107), -2);
    }

    public void emitIDIV() {
        this.addCode(new BasicCode(108), -1);
    }

    public void emitLDIV() {
        this.addCode(new BasicCode(109), -2);
    }

    public void emitFDIV() {
        this.addCode(new BasicCode(110), -1);
    }

    public void emitDDIV() {
        this.addCode(new BasicCode(111), -2);
    }

    public void emitIREM() {
        this.addCode(new BasicCode(112), -1);
    }

    public void emitLREM() {
        this.addCode(new BasicCode(113), -2);
    }

    public void emitFREM() {
        this.addCode(new BasicCode(114), -1);
    }

    public void emitDREM() {
        this.addCode(new BasicCode(115), -2);
    }

    public void emitINEG() {
        this.addCode(new BasicCode(116), 0);
    }

    public void emitLNEG() {
        this.addCode(new BasicCode(117), 0);
    }

    public void emitFNEG() {
        this.addCode(new BasicCode(118), 0);
    }

    public void emitDNEG() {
        this.addCode(new BasicCode(119), 0);
    }

    public void emitISHL() {
        this.addCode(new BasicCode(120), -1);
    }

    public void emitLSHL() {
        this.addCode(new BasicCode(121), -1);
    }

    public void emitISHR() {
        this.addCode(new BasicCode(122), -1);
    }

    public void emitLSHR() {
        this.addCode(new BasicCode(123), -1);
    }

    public void emitIUSHR() {
        this.addCode(new BasicCode(124), -1);
    }

    public void emitLUSHR() {
        this.addCode(new BasicCode(125), -1);
    }

    public void emitIOR() {
        this.addCode(new BasicCode(-128), -1);
    }

    public void emitLOR() {
        this.addCode(new BasicCode(-127), -2);
    }

    public void emitIXOR() {
        this.addCode(new BasicCode(-126), -1);
    }

    public void emitLXOR() {
        this.addCode(new BasicCode(-125), -2);
    }

    public void emitIRETURN() {
        this.addCode(new ReturnCode(-84), -1);
    }

    public void emitLRETURN() {
        this.addCode(new ReturnCode(-83), -2);
    }

    public void emitFRETURN() {
        this.addCode(new ReturnCode(-82), -1);
    }

    public void emitDRETURN() {
        this.addCode(new ReturnCode(-81), -2);
    }

    public void emitARETURN() {
        this.addCode(new ReturnCode(-80), -1);
    }

    public void emitRETURN() {
        this.addCode(new ReturnCode(-79), 0);
    }

    public void emitARRAYLENGTH() {
        this.addCode(new BasicCode(-66), 0);
    }

    public void emitATHROW() {
        this.addCode(new BasicCode(-65), -1);
    }

    public void emitMONITORENTER() {
        this.addCode(new BasicCode(-62), -1);
    }

    public void emitMONITOREXIT() {
        this.addCode(new BasicCode(-61), -1);
    }

    public void emitDUP() {
        this.addCode(new BasicCode(89), 1);
    }

    public void emitDUP_X1() {
        this.addCode(new BasicCode(90), 1);
    }

    public void emitDUP_X2() {
        this.addCode(new BasicCode(91), 1);
    }

    public void emitDUP2() {
        this.addCode(new BasicCode(92), 2);
    }

    public void emitDUP2_X1() {
        this.addCode(new BasicCode(93), 2);
    }

    public void emitDUP2_X2() {
        this.addCode(new BasicCode(94), 2);
    }

    public void emitIFEQ(Label tdest, Label fdest) {
        this.addCode(new BranchCode(-103, -102, tdest, fdest), -1);
    }

    public void emitIFNE(Label tdest, Label fdest) {
        this.addCode(new BranchCode(-102, -103, tdest, fdest), -1);
    }

    public void emitIFLT(Label tdest, Label fdest) {
        this.addCode(new BranchCode(-101, -100, tdest, fdest), -1);
    }

    public void emitIFGE(Label tdest, Label fdest) {
        this.addCode(new BranchCode(-100, -101, tdest, fdest), -1);
    }

    public void emitIFGT(Label tdest, Label fdest) {
        this.addCode(new BranchCode(-99, -98, tdest, fdest), -1);
    }

    public void emitIFLE(Label tdest, Label fdest) {
        this.addCode(new BranchCode(-98, -99, tdest, fdest), -1);
    }

    public void emitIF_ICMPEQ(Label tdest, Label fdest) {
        this.addCode(new BranchCode(-97, -96, tdest, fdest), -2);
    }

    public void emitIF_ICMPNE(Label tdest, Label fdest) {
        this.addCode(new BranchCode(-96, -97, tdest, fdest), -2);
    }

    public void emitIF_ICMPLT(Label tdest, Label fdest) {
        this.addCode(new BranchCode(-95, -94, tdest, fdest), -2);
    }

    public void emitIF_ICMPGE(Label tdest, Label fdest) {
        this.addCode(new BranchCode(-94, -95, tdest, fdest), -2);
    }

    public void emitIF_ICMPGT(Label tdest, Label fdest) {
        this.addCode(new BranchCode(-93, -92, tdest, fdest), -2);
    }

    public void emitIF_ICMPLE(Label tdest, Label fdest) {
        this.addCode(new BranchCode(-92, -93, tdest, fdest), -2);
    }

    public void emitIF_ACMPEQ(Label tdest, Label fdest) {
        this.addCode(new BranchCode(-91, -90, tdest, fdest), -2);
    }

    public void emitIF_ACMPNE(Label tdest, Label fdest) {
        this.addCode(new BranchCode(-90, -91, tdest, fdest), -2);
    }

    public void emitIFNULL(Label tdest, Label fdest) {
        this.addCode(new BranchCode(-58, -57, tdest, fdest), -1);
    }

    public void emitIFNONNULL(Label tdest, Label fdest) {
        this.addCode(new BranchCode(-57, -58, tdest, fdest), -1);
    }

    public void emitIntConstant(int val) {
        Code code;
        switch (val) {
            case -1: {
                code = new BasicCode(2);
                break;
            }
            case 0: {
                code = new BasicCode(3);
                break;
            }
            case 1: {
                code = new BasicCode(4);
                break;
            }
            case 2: {
                code = new BasicCode(5);
                break;
            }
            case 3: {
                code = new BasicCode(6);
                break;
            }
            case 4: {
                code = new BasicCode(7);
                break;
            }
            case 5: {
                code = new BasicCode(8);
                break;
            }
            default: {
                code = Asserts.isByte(val) ? new ByteCode(16, (byte)val) : (Asserts.isShort(val) ? new ShortCode(17, (short)val) : new LDCCode(this.pool.addInt(val)));
            }
        }
        this.addCode(code, 1);
    }

    public void emitLongConstant(long val) {
        Code code = val == 0L ? new BasicCode(9) : (val == 1L ? new BasicCode(10) : new PoolCode(20, this.pool.addLong(val)));
        this.addCode(code, 2);
    }

    public void emitFloatConstant(float val) {
        Code code = val == 0.0f ? (1.0f / val > 0.0f ? new BasicCode(11) : new LDCCode(this.pool.addFloat(val))) : (val == 1.0f ? new BasicCode(12) : (val == 2.0f ? new BasicCode(13) : new LDCCode(this.pool.addFloat(val))));
        this.addCode(code, 1);
    }

    public void emitDoubleConstant(double val) {
        Code code = val == 0.0 ? (1.0 / val > 0.0 ? new BasicCode(14) : new PoolCode(20, this.pool.addDouble(val))) : (val == 1.0 ? new BasicCode(15) : new PoolCode(20, this.pool.addDouble(val)));
        this.addCode(code, 2);
    }

    public void emitStringConstant(String val) {
        this.addCode(new LDCCode(this.pool.addString(val)), 1);
    }

    public void emitNEWARRAY(int tyIndex) {
        this.addCode(new ByteCode(-68, (byte)tyIndex), 0);
    }

    public void emitANEWARRAY(RefType componentType) {
        this.addCode(new PoolCode(-67, this.pool.addClass(componentType)), 0);
    }

    public void emitMULTIANEWARRAY(ArrayType arrayType, int dimCount) {
        this.addCode(new PoolByteCode(-59, this.pool.addClass(arrayType), (byte)dimCount), -(dimCount - 1));
    }

    public void emitALOAD(int n) {
        this.emitFrameCode(this.aloads, n, 1);
    }

    public void emitILOAD(int n) {
        this.emitFrameCode(this.iloads, n, 1);
    }

    public void emitLLOAD(int n) {
        this.emitFrameCode(this.lloads, n, 2);
    }

    public void emitFLOAD(int n) {
        this.emitFrameCode(this.floads, n, 1);
    }

    public void emitDLOAD(int n) {
        this.emitFrameCode(this.dloads, n, 2);
    }

    public void emitASTORE(int n) {
        this.emitFrameCode(this.astores, n, -1);
    }

    public void emitISTORE(int n) {
        this.emitFrameCode(this.istores, n, -1);
    }

    public void emitLSTORE(int n) {
        this.emitFrameCode(this.lstores, n, -2);
    }

    public void emitFSTORE(int n) {
        this.emitFrameCode(this.fstores, n, -1);
    }

    public void emitDSTORE(int n) {
        this.emitFrameCode(this.dstores, n, -2);
    }

    public void emitFrameCode(byte[] insts, int n, int delta) {
        if (n <= 3) {
            this.addCode(new BasicCode(insts[n]), delta);
        } else {
            this.addCode(new FrameCode(insts[4], n), delta);
        }
    }

    public void emitIINC(int n, int incr) {
        this.addCode(new IncCode(n, incr), 0);
    }

    public String toString() {
        return "(st/fr " + this.maxStack + " " + this.maxFrame + ") " + this.attributes;
    }

    public void emitStackSize() {
        this.addCode(new BasicCode(0));
        this.addCode(new ByteCode(16, (byte)this.getStackSize()));
        this.addCode(new BasicCode(87));
        this.addCode(new BasicCode(0));
    }

    public void displayInstructions(int indent) {
        List<Code> codes = this.isResolved() ? Arrays.asList(this.codea) : this.codes;
        int i = 0;
        int len = codes.size() - 1;
        while (i < len) {
            Code c = codes.get(i);
            if (c.isActive()) {
                CodeBuilder.between(indent, false);
                if (c.getLabels().size() != 0) {
                    String s = c.getLabels().get(0) + " ";
                    System.err.print(s);
                    int p = 4 - s.length();
                    while (p > 0) {
                        System.err.print(" ");
                        --p;
                    }
                } else {
                    System.err.print("    ");
                }
                System.err.print(c);
            }
            ++i;
        }
        int i2 = 0;
        int len2 = this.starts.size();
        while (i2 < len2) {
            CodeBuilder.between(indent, false);
            String name = this.names.get(i2) == null ? "any" : this.names.get(i2).toString();
            System.err.print("(throwing " + name + " from " + this.starts.get(i2) + " to " + this.ends.get(i2) + " goto " + this.handlers.get(i2) + ")");
            ++i2;
        }
    }

    public void display(int indent, boolean inline) {
        System.err.print("(stack " + this.maxStack + ") (locals " + this.maxFrame + ")");
        CodeBuilder.between(indent, inline);
        this.attributes.display(indent, inline);
        if (!inline) {
            this.displayInstructions(indent);
        }
    }

    static void between(int indent, boolean inline) {
        if (inline) {
            System.err.print(" ");
        } else {
            System.err.println();
            int s = indent;
            while (s >= 0) {
                System.err.print(" ");
                --s;
            }
        }
    }

    private static String debugString(byte b) {
        switch (b) {
            case 0: {
                return "NOP";
            }
            case 1: {
                return "ACONST_NULL";
            }
            case 2: {
                return "ICONST_M1";
            }
            case 3: {
                return "ICONST_0";
            }
            case 4: {
                return "ICONST_1";
            }
            case 5: {
                return "ICONST_2";
            }
            case 6: {
                return "ICONST_3";
            }
            case 7: {
                return "ICONST_4";
            }
            case 8: {
                return "ICONST_5";
            }
            case 9: {
                return "LCONST_0";
            }
            case 10: {
                return "LCONST_1";
            }
            case 11: {
                return "FCONST_0";
            }
            case 12: {
                return "FCONST_1";
            }
            case 13: {
                return "FCONST_2";
            }
            case 14: {
                return "DCONST_0";
            }
            case 15: {
                return "DCONST_1";
            }
            case 26: {
                return "ILOAD_0";
            }
            case 27: {
                return "ILOAD_1";
            }
            case 28: {
                return "ILOAD_2";
            }
            case 29: {
                return "ILOAD_3";
            }
            case 30: {
                return "LLOAD_0";
            }
            case 31: {
                return "LLOAD_1";
            }
            case 32: {
                return "LLOAD_2";
            }
            case 33: {
                return "LLOAD_3";
            }
            case 34: {
                return "FLOAD_0";
            }
            case 35: {
                return "FLOAD_1";
            }
            case 36: {
                return "FLOAD_2";
            }
            case 37: {
                return "FLOAD_3";
            }
            case 38: {
                return "DLOAD_0";
            }
            case 39: {
                return "DLOAD_1";
            }
            case 40: {
                return "DLOAD_2";
            }
            case 41: {
                return "DLOAD_3";
            }
            case 42: {
                return "ALOAD_0";
            }
            case 43: {
                return "ALOAD_1";
            }
            case 44: {
                return "ALOAD_2";
            }
            case 45: {
                return "ALOAD_3";
            }
            case 46: {
                return "IALOAD";
            }
            case 47: {
                return "LALOAD";
            }
            case 48: {
                return "FALOAD";
            }
            case 49: {
                return "DALOAD";
            }
            case 50: {
                return "AALOAD";
            }
            case 51: {
                return "BALOAD";
            }
            case 52: {
                return "CALOAD";
            }
            case 53: {
                return "SALOAD";
            }
            case 59: {
                return "ISTORE_0";
            }
            case 60: {
                return "ISTORE_1";
            }
            case 61: {
                return "ISTORE_2";
            }
            case 62: {
                return "ISTORE_3";
            }
            case 63: {
                return "LSTORE_0";
            }
            case 64: {
                return "LSTORE_1";
            }
            case 65: {
                return "LSTORE_2";
            }
            case 66: {
                return "LSTORE_3";
            }
            case 67: {
                return "FSTORE_0";
            }
            case 68: {
                return "FSTORE_1";
            }
            case 69: {
                return "FSTORE_2";
            }
            case 70: {
                return "FSTORE_3";
            }
            case 71: {
                return "DSTORE_0";
            }
            case 72: {
                return "DSTORE_1";
            }
            case 73: {
                return "DSTORE_2";
            }
            case 74: {
                return "DSTORE_3";
            }
            case 75: {
                return "ASTORE_0";
            }
            case 76: {
                return "ASTORE_1";
            }
            case 77: {
                return "ASTORE_2";
            }
            case 78: {
                return "ASTORE_3";
            }
            case 79: {
                return "IASTORE";
            }
            case 80: {
                return "LASTORE";
            }
            case 81: {
                return "FASTORE";
            }
            case 82: {
                return "DASTORE";
            }
            case 83: {
                return "AASTORE";
            }
            case 84: {
                return "BASTORE";
            }
            case 85: {
                return "CASTORE";
            }
            case 86: {
                return "SASTORE";
            }
            case 87: {
                return "POP";
            }
            case 88: {
                return "POP2";
            }
            case 89: {
                return "DUP";
            }
            case 90: {
                return "DUP_X1";
            }
            case 91: {
                return "DUP_X2";
            }
            case 92: {
                return "DUP2";
            }
            case 93: {
                return "DUP2_X1";
            }
            case 94: {
                return "DUP2_X2";
            }
            case 95: {
                return "SWAP";
            }
            case 96: {
                return "IADD";
            }
            case 97: {
                return "LADD";
            }
            case 98: {
                return "FADD";
            }
            case 99: {
                return "DADD";
            }
            case 100: {
                return "ISUB";
            }
            case 101: {
                return "LSUB";
            }
            case 102: {
                return "FSUB";
            }
            case 103: {
                return "DSUB";
            }
            case 104: {
                return "IMUL";
            }
            case 105: {
                return "LMUL";
            }
            case 106: {
                return "FMUL";
            }
            case 107: {
                return "DMUL";
            }
            case 108: {
                return "IDIV";
            }
            case 109: {
                return "LDIV";
            }
            case 110: {
                return "FDIV";
            }
            case 111: {
                return "DDIV";
            }
            case 112: {
                return "IREM";
            }
            case 113: {
                return "LREM";
            }
            case 114: {
                return "FREM";
            }
            case 115: {
                return "DREM";
            }
            case 116: {
                return "INEG";
            }
            case 117: {
                return "LNEG";
            }
            case 118: {
                return "FNEG";
            }
            case 119: {
                return "DNEG";
            }
            case 120: {
                return "ISHL";
            }
            case 121: {
                return "LSHL";
            }
            case 122: {
                return "ISHR";
            }
            case 123: {
                return "LSHR";
            }
            case 124: {
                return "IUSHR";
            }
            case 125: {
                return "LUSHR";
            }
            case 126: {
                return "IAND";
            }
            case 127: {
                return "LAND";
            }
            case -128: {
                return "IOR";
            }
            case -127: {
                return "LOR";
            }
            case -126: {
                return "IXOR";
            }
            case -125: {
                return "LXOR";
            }
            case -123: {
                return "I2L";
            }
            case -122: {
                return "I2F";
            }
            case -121: {
                return "I2D";
            }
            case -120: {
                return "L2I";
            }
            case -119: {
                return "L2F";
            }
            case -118: {
                return "L2D";
            }
            case -117: {
                return "F2I";
            }
            case -116: {
                return "F2L";
            }
            case -115: {
                return "F2D";
            }
            case -114: {
                return "D2I";
            }
            case -113: {
                return "D2L";
            }
            case -112: {
                return "D2F";
            }
            case -111: {
                return "I2B";
            }
            case -110: {
                return "I2C";
            }
            case -109: {
                return "I2S";
            }
            case -108: {
                return "LCMP";
            }
            case -107: {
                return "FCMPL";
            }
            case -106: {
                return "FCMPG";
            }
            case -105: {
                return "DCMPL";
            }
            case -104: {
                return "DCMPG";
            }
            case -84: {
                return "IRETURN";
            }
            case -83: {
                return "LRETURN";
            }
            case -82: {
                return "FRETURN";
            }
            case -81: {
                return "DRETURN";
            }
            case -80: {
                return "ARETURN";
            }
            case -79: {
                return "RETURN";
            }
            case -66: {
                return "ARRAYLENGTH";
            }
            case -65: {
                return "ATHROW";
            }
            case -62: {
                return "MONITORENTER";
            }
            case -61: {
                return "MONITOREXIT";
            }
            case 16: {
                return "BIPUSH";
            }
            case -68: {
                return "NEWARRAY";
            }
            case 21: {
                return "ILOAD";
            }
            case 22: {
                return "LLOAD";
            }
            case 23: {
                return "FLOAD";
            }
            case 24: {
                return "DLOAD";
            }
            case 25: {
                return "ALOAD";
            }
            case 54: {
                return "ISTORE";
            }
            case 55: {
                return "LSTORE";
            }
            case 56: {
                return "FSTORE";
            }
            case 57: {
                return "DSTORE";
            }
            case 58: {
                return "ASTORE";
            }
            case -87: {
                return "RET";
            }
            case 17: {
                return "SIPUSH";
            }
            case 18: {
                return "LDC";
            }
            case 19: {
                return "LDC_W";
            }
            case 20: {
                return "LDC2_W";
            }
            case -78: {
                return "GETSTATIC";
            }
            case -77: {
                return "PUTSTATIC";
            }
            case -76: {
                return "GETFIELD";
            }
            case -75: {
                return "PUTFIELD";
            }
            case -74: {
                return "INVOKEVIRTUAL";
            }
            case -73: {
                return "INVOKESPECIAL";
            }
            case -72: {
                return "INVOKESTATIC";
            }
            case -71: {
                return "INVOKEINTERFACE";
            }
            case -67: {
                return "ANEWARRAY";
            }
            case -69: {
                return "NEW";
            }
            case -64: {
                return "CHECKCAST";
            }
            case -63: {
                return "INSTANCEOF";
            }
            case -59: {
                return "MULTIANEWARRAY";
            }
            case -103: {
                return "IFEQ";
            }
            case -102: {
                return "IFNE";
            }
            case -101: {
                return "IFLT";
            }
            case -100: {
                return "IFGE";
            }
            case -99: {
                return "IFGT";
            }
            case -98: {
                return "IFLE";
            }
            case -97: {
                return "IF_ICMPEQ";
            }
            case -96: {
                return "IF_ICMPNE";
            }
            case -95: {
                return "IF_ICMPLT";
            }
            case -94: {
                return "IF_ICMPGE";
            }
            case -93: {
                return "IF_ICMPGT";
            }
            case -92: {
                return "IF_ICMPLE";
            }
            case -91: {
                return "IF_ACMPEQ";
            }
            case -90: {
                return "IF_ACMPNE";
            }
            case -58: {
                return "IFNULL";
            }
            case -57: {
                return "IFNONNULL";
            }
            case -89: {
                return "GOTO";
            }
            case -88: {
                return "JSR";
            }
            case -56: {
                return "GOTO_W";
            }
            case -55: {
                return "JSR_W";
            }
            case -86: {
                return "TABLESWITCH";
            }
            case -85: {
                return "LOOKUPSWITCH";
            }
            case -124: {
                return "IINC";
            }
            case -60: {
                return "WIDE";
            }
            case -70: {
                return "XXXUNUSEDXXX1";
            }
            case -54: {
                return "BREAKPOINT";
            }
            case -2: {
                return "IMPDEP1";
            }
            case -1: {
                return "IMPDEP2";
            }
        }
        throw new RuntimeException("weird bytecode");
    }

    public static class LookupSwitchCode
    extends Code {
        int padBytes = 0;
        int[] keys;
        Label[] cases;
        Label defaultCase;

        LookupSwitchCode(int[] keys, Label[] cases, Label defaultCase) {
            this.keys = keys;
            this.cases = cases;
            this.defaultCase = defaultCase;
        }

        int resolveBest(int pc) {
            this.pc = pc;
            this.padBytes = -pc % 4 + 3;
            return pc + 1 + this.padBytes + 4 + 4 + 8 * this.cases.length;
        }

        void writeTo(DataOutputStream stream) throws IOException {
            stream.writeByte(-85);
            int i = this.padBytes;
            while (i > 0) {
                stream.writeByte(0);
                --i;
            }
            this.defaultCase.writeRelativeInt(this.pc, stream);
            stream.writeInt(this.cases.length);
            int i2 = 0;
            while (i2 < this.cases.length) {
                stream.writeInt(this.keys[i2]);
                this.cases[i2].writeRelativeInt(this.pc, stream);
                ++i2;
            }
        }

        public String toString() {
            return "lookupswitch";
        }

        boolean jumps() {
            return true;
        }
    }

    public static class TableSwitchCode
    extends Code {
        int padBytes = 0;
        int min;
        int max;
        Label[] cases;
        Label defaultCase;

        TableSwitchCode(int min, int max, Label[] cases, Label defaultCase) {
            this.min = min;
            this.max = max;
            this.cases = cases;
            this.defaultCase = defaultCase;
        }

        int resolveBest(int pc) {
            this.pc = pc;
            this.padBytes = -pc % 4 + 3;
            return pc + 1 + this.padBytes + 4 + 4 + 4 + 4 * this.cases.length;
        }

        void writeTo(DataOutputStream stream) throws IOException {
            stream.writeByte(-86);
            int i = this.padBytes;
            while (i > 0) {
                stream.writeByte(0);
                --i;
            }
            this.defaultCase.writeRelativeInt(this.pc, stream);
            stream.writeInt(this.min);
            stream.writeInt(this.max);
            int i2 = 0;
            while (i2 < this.cases.length) {
                this.cases[i2].writeRelativeInt(this.pc, stream);
                ++i2;
            }
        }

        public String toString() {
            return "tableswitch";
        }

        boolean jumps() {
            return true;
        }
    }

    static class PoolByteCode
    extends Code {
        byte code;
        Constant constant;
        byte data;

        PoolByteCode(byte code, Constant constant, byte data) {
            this.code = code;
            this.constant = constant;
            this.data = data;
        }

        int resolveBest(int pc) {
            this.pc = pc;
            return pc + 4;
        }

        void writeTo(DataOutputStream stream) throws IOException {
            stream.writeByte(this.code);
            this.constant.writeIndex(stream);
            stream.writeByte(this.data);
        }

        public String toString() {
            return CodeBuilder.debugString(this.code) + " " + this.constant + " " + this.data;
        }
    }

    static class LDCCode
    extends Code {
        Constant constant;

        LDCCode(Constant constant) {
            this.constant = constant;
            constant.makePopular();
        }

        int resolveBest(int pc) {
            this.pc = pc;
            return pc + (Asserts.isUByte(this.constant.getIndex()) ? 2 : 3);
        }

        void writeTo(DataOutputStream stream) throws IOException {
            if (Asserts.isUByte(this.constant.getIndex())) {
                stream.writeByte(18);
                this.constant.writeBriefIndex(stream);
            } else {
                stream.writeByte(19);
                this.constant.writeIndex(stream);
            }
        }

        public String toString() {
            return "LDC " + this.constant + (Asserts.isUByte(this.constant.getIndex()) ? "" : " (!!WIDE!!)");
        }
    }

    static class InvokeInterfaceCode
    extends Code {
        Constant constant;
        int arglen;

        InvokeInterfaceCode(Constant constant, int arglen) {
            this.constant = constant;
            this.arglen = arglen;
        }

        int resolveBest(int pc) {
            this.pc = pc;
            return pc + 5;
        }

        void writeTo(DataOutputStream stream) throws IOException {
            stream.writeByte(-71);
            this.constant.writeIndex(stream);
            stream.writeByte((byte)this.arglen);
            stream.writeByte(0);
        }

        public String toString() {
            return "INVOKEINTERFACE (args " + this.arglen + ") " + this.constant;
        }
    }

    static class PoolCode
    extends Code {
        byte code;
        Constant constant;

        PoolCode(byte code, Constant constant) {
            this.code = code;
            this.constant = constant;
        }

        int resolveBest(int pc) {
            this.pc = pc;
            return pc + 3;
        }

        void writeTo(DataOutputStream stream) throws IOException {
            stream.writeByte(this.code);
            this.constant.writeIndex(stream);
        }

        public String toString() {
            return CodeBuilder.debugString(this.code) + " " + this.constant;
        }
    }

    static class ShortCode
    extends Code {
        byte code;
        short data;

        ShortCode(byte code, short data) {
            this.code = code;
            this.data = data;
        }

        int resolveBest(int pc) {
            this.pc = pc;
            return pc + 3;
        }

        void writeTo(DataOutputStream stream) throws IOException {
            stream.writeByte(this.code);
            stream.writeShort(this.data);
        }

        public String toString() {
            return CodeBuilder.debugString(this.code) + " " + this.data;
        }
    }

    static class ByteCode
    extends Code {
        byte code;
        byte data;

        ByteCode(byte code, byte data) {
            this.code = code;
            this.data = data;
        }

        int resolveBest(int pc) {
            this.pc = pc;
            return pc + 2;
        }

        void writeTo(DataOutputStream stream) throws IOException {
            stream.writeByte(this.code);
            stream.writeByte(this.data);
        }

        public String toString() {
            return CodeBuilder.debugString(this.code) + " " + this.data;
        }
    }

    static class ReturnCode
    extends BasicCode {
        ReturnCode(byte code) {
            super(code);
        }

        boolean jumps() {
            return true;
        }
    }

    static class BasicCode
    extends Code {
        byte code;

        BasicCode(byte code) {
            this.code = code;
        }

        int resolveBest(int pc) {
            this.pc = pc;
            return pc + 1;
        }

        void writeTo(DataOutputStream stream) throws IOException {
            stream.writeByte(this.code);
        }

        public String toString() {
            return CodeBuilder.debugString(this.code);
        }
    }

    static class FrameCode
    extends Code {
        byte code;
        int loc;
        int size;

        FrameCode(byte code, int loc) {
            this.code = code;
            this.loc = loc;
            this.size = Asserts.isUByte(loc) ? 2 : 4;
        }

        int resolveBest(int pc) {
            this.pc = pc;
            return pc + this.size;
        }

        void writeTo(DataOutputStream stream) throws IOException {
            if (this.size == 4) {
                stream.writeByte(-60);
                stream.writeByte(this.code);
                stream.writeShort(this.loc);
            } else {
                stream.writeByte(this.code);
                stream.writeByte(this.loc);
            }
        }

        public String toString() {
            return (this.size == 4 ? "WIDE " : "") + CodeBuilder.debugString(this.code) + " " + this.loc;
        }
    }

    static class IncCode
    extends Code {
        int loc;
        int val;
        int size;

        IncCode(int loc, int val) {
            this.loc = loc;
            this.val = val;
            this.size = Asserts.isUByte(loc) && Asserts.isByte(val) ? 3 : 6;
        }

        int resolveBest(int pc) {
            this.pc = pc;
            return pc + this.size;
        }

        void writeTo(DataOutputStream stream) throws IOException {
            if (this.size == 6) {
                stream.writeByte(-60);
                stream.writeByte(-124);
                stream.writeShort(this.loc);
                stream.writeShort(this.val);
            } else {
                stream.writeByte(-124);
                stream.writeByte(this.loc);
                stream.writeByte(this.val);
            }
        }

        public String toString() {
            return (this.size == 6 ? "WIDE IINC " : "IINC ") + this.loc + " " + this.val;
        }
    }

    static class JsrCode
    extends Code {
        Label dest;
        boolean small = true;

        JsrCode(Label dest) {
            this.dest = dest;
        }

        Label getDest() {
            return this.dest;
        }

        int resolveBest(int pc) {
            this.pc = pc;
            return pc + 3;
        }

        int resolveWorst(int pc) {
            this.small = false;
            this.pc = pc;
            return pc + 5;
        }

        void writeTo(DataOutputStream stream) throws IOException {
            if (this.small) {
                stream.writeByte(-88);
                this.dest.writeRelativeShort(this.pc, stream);
            } else {
                stream.writeByte(-55);
                this.dest.writeRelativeInt(this.pc, stream);
            }
        }

        public String toString() {
            return "JSR " + this.dest;
        }
    }

    static class JumpCode
    extends Code {
        boolean active = true;
        Label dest;
        boolean small = true;

        boolean isActive() {
            return this.active;
        }

        JumpCode(Label dest) {
            this.dest = dest;
        }

        Label getDest() {
            return this.dest;
        }

        void setDest(Label dest) {
            this.dest = dest;
        }

        int resolveBest(int pc) {
            this.pc = pc;
            return this.active ? pc + 3 : pc;
        }

        int resolveWorst(int pc) {
            this.small = false;
            this.pc = pc;
            return this.active ? pc + 5 : pc;
        }

        void writeTo(DataOutputStream stream) throws IOException {
            if (!this.active) {
                return;
            }
            if (this.small) {
                stream.writeByte(-89);
                this.dest.writeRelativeShort(this.pc, stream);
            } else {
                stream.writeByte(-56);
                this.dest.writeRelativeInt(this.pc, stream);
            }
        }

        public String toString() {
            return "GOTO " + this.dest;
        }

        boolean jumps() {
            return this.active;
        }

        void notifyNonLive() {
            this.active = false;
        }

        Code getRealNext() {
            return this.active ? this : this.dest.getTarget();
        }

        void resolve(Code next) {
            Code target = this.dest.getTarget();
            if (target != this) {
                Iterator i = this.getLabels().iterator();
                while (i.hasNext()) {
                    Label l = (Label)i.next();
                    if (l.isAnchored()) continue;
                    i.remove();
                    l.setTarget(target);
                }
            }
            if (next == target) {
                this.active = false;
            }
        }
    }

    static class BranchCode
    extends Code {
        byte tcode;
        byte fcode;
        Label tdest;
        Label fdest;
        boolean oneArmed;
        boolean arm;
        boolean small = true;

        BranchCode(byte tcode, byte fcode, Label tdest, Label fdest) {
            this.tcode = tcode;
            this.tdest = tdest;
            this.fcode = fcode;
            this.fdest = fdest;
        }

        void resolve(Code next) {
            if (this.tdest.getTarget() == next) {
                this.oneArmed = true;
                this.arm = false;
            } else if (this.fdest.getTarget() == next) {
                this.oneArmed = true;
                this.arm = true;
            } else {
                this.oneArmed = false;
            }
        }

        boolean jumps() {
            return true;
        }

        int resolveBest(int pc) {
            this.pc = pc;
            return pc + (this.oneArmed ? 3 : 6);
        }

        int resolveWorst(int pc) {
            this.small = false;
            this.pc = pc;
            return pc + (this.oneArmed ? 8 : 13);
        }

        void writeTo(DataOutputStream stream) throws IOException {
            if (this.small) {
                if (!this.oneArmed) {
                    stream.writeByte(this.tcode);
                    this.tdest.writeRelativeShort(this.pc, stream);
                    stream.writeByte(-89);
                    this.fdest.writeRelativeShort(this.pc + 3, stream);
                } else if (this.arm) {
                    stream.writeByte(this.tcode);
                    this.tdest.writeRelativeShort(this.pc, stream);
                } else {
                    stream.writeByte(this.fcode);
                    this.fdest.writeRelativeShort(this.pc, stream);
                }
            } else if (!this.oneArmed) {
                stream.writeByte(this.tcode);
                stream.writeShort(8);
                stream.writeByte(-56);
                this.fdest.writeRelativeInt(this.pc + 3, stream);
                stream.writeByte(-56);
                this.tdest.writeRelativeInt(this.pc + 8, stream);
            } else if (this.arm) {
                stream.writeByte(this.fcode);
                stream.writeShort(8);
                stream.writeByte(-56);
                this.tdest.writeRelativeInt(this.pc + 3, stream);
            } else {
                stream.writeByte(this.tcode);
                stream.writeShort(8);
                stream.writeByte(-56);
                this.fdest.writeRelativeInt(this.pc + 3, stream);
            }
        }

        public String toString() {
            if (!this.oneArmed) {
                return CodeBuilder.debugString(this.tcode) + " " + this.tdest + " else " + this.fdest;
            }
            if (this.arm) {
                return CodeBuilder.debugString(this.tcode) + " " + this.tdest + " ";
            }
            return CodeBuilder.debugString(this.fcode) + " " + this.fdest + " ";
        }
    }

    static class SentinelCode
    extends Code {
        SentinelCode() {
        }

        int resolveBest(int pc) {
            this.setPc(pc);
            return pc;
        }

        void writeTo(DataOutputStream stream) {
        }

        public String toString() {
            return "SENTINEL";
        }

        boolean isActive() {
            return false;
        }
    }

    static class TooWideJumpException
    extends RuntimeException {
        TooWideJumpException() {
        }
    }

    private static final class LineNumber {
        ClassfileBuilder.SourceFile fileInfo;
        Label pc;
        int line;
        LineNumber next;

        LineNumber(ClassfileBuilder.SourceFile fileInfo, Label pc, int line, LineNumber next) {
            this.fileInfo = fileInfo;
            this.pc = pc;
            this.line = line;
            this.next = next;
        }
    }

    private static final class LocalVar {
        Label start;
        Label end;
        Constant name;
        Constant descriptor;
        int index;
        LocalVar next;

        LocalVar(Label start, Label end, Constant name, Constant descriptor, int index, LocalVar next) {
            this.start = start;
            this.end = end;
            this.name = name;
            this.descriptor = descriptor;
            this.index = index;
            this.next = next;
        }

        public String toString() {
            return "(" + this.start + " " + this.end + " " + this.name + " " + this.descriptor + " " + this.index + "):" + this.next;
        }
    }
}

