/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.aspectj.compiler.base.CompilerObject;
import org.aspectj.compiler.base.JavaCompiler;
import org.aspectj.compiler.base.ast.CompilationUnit;
import org.aspectj.compiler.base.ast.ConstructorDec;
import org.aspectj.compiler.base.ast.Decs;
import org.aspectj.compiler.base.ast.DummySourceLocation;
import org.aspectj.compiler.base.ast.FieldDec;
import org.aspectj.compiler.base.ast.Formals;
import org.aspectj.compiler.base.ast.MethodDec;
import org.aspectj.compiler.base.ast.Modifiers;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.TypeDec;
import org.aspectj.compiler.base.ast.TypeDs;
import org.aspectj.compiler.base.ast.VarDec;
import org.aspectj.compiler.base.parser.SourceInfo;
import org.aspectj.compiler.crosscuts.ast.EmptyPcd;
import org.aspectj.compiler.crosscuts.ast.PointcutDec;
import org.aspectj.compiler.crosscuts.joinpoints.JpPlanner;
import org.aspectj.compiler.crosscuts.joinpoints.TopJpPlanner;
import org.aspectj.compiler.crosscuts.joinpoints.TypeDecPlanner;

public class World
extends CompilerObject {
    private List compilationUnits = new ArrayList();
    private List files = new LinkedList();
    private ArrayList codeDecs = new ArrayList();
    public final SourceLocation source = new DummySourceLocation(this.getCompiler());
    public final CompilationUnit missingCompilationUnit = new CompilationUnit(this.source, null, null, new Decs(this.source), new SourceInfo(null, null), true);
    public final FieldDec FIELD_DEC_NOT_FOUND;
    public final FieldDec FIELD_NOT_FOUND;
    public final VarDec VAR_DEC_NOT_FOUND;
    public final MethodDec METHOD_DEC_NOT_FOUND;
    public final ConstructorDec CONSTRUCTOR_DEC_NOT_FOUND;
    public final PointcutDec POINTCUT_DEC_NOT_FOUND;
    public final PointcutDec POINTCUT_NOT_FOUND;
    private int labelCount;
    private List sourceTypes;
    private LinkedList buildingTypeGraph;
    private List jpPlanners;
    private List staticJpPlanners;
    private Collection typePlanners;
    public boolean collectedTypeDecPlanners;
    public Map calleeSideCallPoints;
    private Map sourceToOutput;
    private Map outputToSource;

    public List getFiles() {
        return this.files;
    }

    public void cleanup() {
        this.files = new LinkedList();
        this.codeDecs = new ArrayList();
        this.compilationUnits = new ArrayList();
    }

    public World(JavaCompiler compiler) {
        super(compiler);
        this.FIELD_NOT_FOUND = this.FIELD_DEC_NOT_FOUND = new FieldDec(this.source, new Modifiers(this.source, 1), this.getTypeManager().anyType.makeTypeD(), "not$found", null);
        this.VAR_DEC_NOT_FOUND = new VarDec(this.source, this.getTypeManager().anyType.makeTypeD(), "not$found", null);
        this.METHOD_DEC_NOT_FOUND = new MethodDec(this.source, new Modifiers(this.source, 0), this.getTypeManager().anyType.makeTypeD(), "not$found", new Formals(this.source), new TypeDs(this.source), null);
        this.CONSTRUCTOR_DEC_NOT_FOUND = new ConstructorDec(this.source, new Modifiers(this.source, 0), new Formals(this.source), new TypeDs(this.source), null);
        this.POINTCUT_NOT_FOUND = this.POINTCUT_DEC_NOT_FOUND = new PointcutDec(this.source, new Modifiers(this.source, 0), "NOT_FOUND", null, null, new EmptyPcd(this.source));
        this.labelCount = 0;
        this.sourceTypes = new LinkedList();
        this.buildingTypeGraph = new LinkedList();
        this.jpPlanners = new LinkedList();
        this.staticJpPlanners = new LinkedList();
        this.typePlanners = new LinkedList();
        this.collectedTypeDecPlanners = false;
        this.calleeSideCallPoints = new HashMap();
        this.sourceToOutput = new HashMap();
        this.outputToSource = new HashMap();
    }

    public Enumeration enumerateCompilationUnits() {
        return new CompilationUnitEnumerator();
    }

    public List getCompilationUnits() {
        return this.compilationUnits;
    }

    public void addCompilationUnit(CompilationUnit cu) {
        this.compilationUnits.add(cu);
    }

    public Enumeration enumerateFiles() {
        return new FileEnumerator();
    }

    public void addFile(String filename) {
        if (this.files.contains(filename)) {
            return;
        }
        this.files.add(filename);
    }

    public String genLabel() {
        return "aj$label" + this.labelCount++;
    }

    public List getTypes() {
        ArrayList types = new ArrayList();
        Enumeration en = this.enumerateCompilationUnits();
        while (en.hasMoreElements()) {
            CompilationUnit cu = (CompilationUnit)en.nextElement();
            types.addAll(cu.getDefinedTypes());
        }
        return types;
    }

    public void addSourceType(Type type) {
        this.sourceTypes.add(type);
        this.getTypeManager().addType(type);
    }

    public Iterator sourceTypesIterator() {
        return new Iterator(){
            int index = 0;

            public boolean hasNext() {
                return this.index < World.this.sourceTypes.size();
            }

            public Object next() {
                return World.this.sourceTypes.get(this.index++);
            }

            public void remove() {
                throw new RuntimeException("can't remove from this");
            }
        };
    }

    public void pushBuildingTypeGraph(TypeDec td) {
        this.buildingTypeGraph.addLast(td);
    }

    public void popBuildingTypeGraph() {
        this.buildingTypeGraph.removeLast();
    }

    public LinkedList getBuildingTypeGraph() {
        return this.buildingTypeGraph;
    }

    public void addJpPlanner(JpPlanner planner) {
        if (planner.isStaticPlanner()) {
            this.staticJpPlanners.add(new TopJpPlanner(planner));
        } else {
            this.jpPlanners.add(new TopJpPlanner(planner));
        }
    }

    public List getJpPlanners() {
        return this.jpPlanners;
    }

    public List getStaticJpPlanners() {
        return this.staticJpPlanners;
    }

    public void addTypeDecPlanner(TypeDecPlanner planner) {
        if (!this.typePlanners.contains(planner)) {
            this.typePlanners.add(planner);
        }
    }

    public void runTypeDecPlanners(TypeDec typeDec, int phase) {
        if (!typeDec.fromSource()) {
            return;
        }
        Iterator i = this.typePlanners.iterator();
        while (i.hasNext()) {
            TypeDecPlanner planner = (TypeDecPlanner)i.next();
            planner.plan(typeDec, phase);
        }
    }

    public Map getSourceToOutputLineMap() {
        return this.sourceToOutput;
    }

    public Map getOutputToSourceLineMap() {
        return this.sourceToOutput;
    }

    public void clearState() {
        this.sourceToOutput = null;
        this.outputToSource = null;
    }

    private class FileEnumerator
    implements Enumeration {
        int idx = 0;

        private FileEnumerator() {
        }

        public boolean hasMoreElements() {
            return this.idx < World.this.files.size();
        }

        public Object nextElement() {
            return World.this.files.get(this.idx++);
        }
    }

    private class CompilationUnitEnumerator
    implements Enumeration {
        int idx = 0;

        private CompilationUnitEnumerator() {
        }

        public boolean hasMoreElements() {
            return this.idx < World.this.compilationUnits.size();
        }

        public Object nextElement() {
            return World.this.compilationUnits.get(this.idx++);
        }
    }
}

