/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import org.aspectj.compiler.base.ByteCodeCleanupPass;
import org.aspectj.compiler.base.CodeWriter;
import org.aspectj.compiler.base.FlowCheckerPass;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Stmt;
import org.aspectj.compiler.base.ast.TestStmt;
import org.aspectj.compiler.base.bcg.CodeBuilder;
import org.aspectj.compiler.base.bcg.Label;

public class WhileStmt
extends TestStmt {
    protected Expr test;
    protected Stmt body;

    public boolean isBreakable() {
        return true;
    }

    public boolean isContinuable() {
        return true;
    }

    public void unparse(CodeWriter writer) {
        writer.writeKeyword("while");
        writer.optionalSpace();
        writer.parenExpr(this.test);
        writer.write(this.body);
    }

    public void checkSpec() {
        this.body.requireStmt();
        super.checkSpec();
    }

    public void walkFlow(FlowCheckerPass w) {
        FlowCheckerPass.Set enteringPossiblyAssigned = w.popPossiblyAssigned();
        w.processBoolean(this.getTest());
        FlowCheckerPass.Vars p = w.getVars();
        FlowCheckerPass.Vars tv = p.getTrue();
        FlowCheckerPass.Vars fv = p.getFalse();
        w.setLive(!this.getTest().isConstantFalse());
        w.setVars(tv);
        w.enterContext(this);
        w.process(this.getBody());
        w.leaveContext();
        FlowCheckerPass.Vars v = w.getVars();
        FlowCheckerPass.Vars cv = w.getContinueVars(this);
        FlowCheckerPass.Vars bv = w.getBreakVars(this);
        FlowCheckerPass.Set loopPossiblyAssigned = w.popPossiblyAssigned();
        w.checkLoopingFinals(this, loopPossiblyAssigned.inter(enteringPossiblyAssigned), v.join(cv));
        w.mergePossiblyAssigned(enteringPossiblyAssigned);
        w.mergePossiblyAssigned(loopPossiblyAssigned);
        w.setLive(!this.getTest().isConstantTrue() || w.isBroken(this));
        w.setVars(fv.join(bv));
    }

    public void walkCleanup(ByteCodeCleanupPass w) {
        if (this.getTest().isConstantFalse()) {
            return;
        }
        w.enterContext(this);
        w.process(this.getBody());
        w.leaveContext();
        w.setLive(!this.getTest().isConstantTrue() || w.isBroken(this));
    }

    public ASTObject postCleanup(ByteCodeCleanupPass w) {
        if (this.getTest().isConstantFalse()) {
            return this.getAST().makeEmptyStmt().setSource(this);
        }
        return this;
    }

    protected void cgStmt(CodeBuilder cb) {
        Label startLab = cb.genLabel();
        Label testLab = cb.genLabel();
        Label endLab = cb.genLabel();
        cb.emitJump(testLab);
        cb.emitLabel(startLab);
        cb.enterNonWindingContext(this, endLab, testLab);
        this.body.cgTop(cb);
        cb.leaveContext();
        cb.emitLabel(testLab);
        this.test.cgTest(cb, startLab, endLab);
        cb.emitLabel(endLab);
    }

    public Expr getTest() {
        return this.test;
    }

    public void setTest(Expr _test) {
        if (_test != null) {
            _test.setParent(this);
        }
        this.test = _test;
    }

    public Stmt getBody() {
        return this.body;
    }

    public void setBody(Stmt _body) {
        if (_body != null) {
            _body.setParent(this);
        }
        this.body = _body;
    }

    public WhileStmt(SourceLocation location, Expr _test, Stmt _body) {
        super(location);
        this.setTest(_test);
        this.setBody(_body);
    }

    protected WhileStmt(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        WhileStmt ret = new WhileStmt(this.getSourceLocation());
        ret.preCopy(walker, this);
        if (this.test != null) {
            ret.setTest((Expr)walker.process(this.test));
        }
        if (this.body != null) {
            ret.setBody((Stmt)walker.process(this.body));
        }
        return ret;
    }

    public ASTObject getChildAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return this.test;
            }
            case 1: {
                return this.body;
            }
        }
        return super.getChildAt(childIndex);
    }

    public String getChildNameAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return "test";
            }
            case 1: {
                return "body";
            }
        }
        return super.getChildNameAt(childIndex);
    }

    public void setChildAt(int childIndex, ASTObject child) {
        switch (childIndex) {
            case 0: {
                this.setTest((Expr)child);
                return;
            }
            case 1: {
                this.setBody((Stmt)child);
                return;
            }
        }
        super.setChildAt(childIndex, child);
    }

    public int getChildCount() {
        return 2;
    }

    public String getDefaultDisplayName() {
        return "WhileStmt()";
    }
}

