/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import org.aspectj.compiler.base.AssignmentCheckerPass;
import org.aspectj.compiler.base.CodeWriter;
import org.aspectj.compiler.base.FlowCheckerPass;
import org.aspectj.compiler.base.LocalClassPass;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.AssignableExpr;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.FieldDec;
import org.aspectj.compiler.base.ast.FormalDec;
import org.aspectj.compiler.base.ast.IntType;
import org.aspectj.compiler.base.ast.LiteralExpr;
import org.aspectj.compiler.base.ast.MovingWalker;
import org.aspectj.compiler.base.ast.NameType;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.VarDec;
import org.aspectj.compiler.base.bcg.CodeBuilder;

public class VarExpr
extends AssignableExpr {
    protected VarDec varDec;

    protected Type discoverType() {
        return this.getVarDec().getType();
    }

    public Expr makeReference() {
        return this.getAST().makeVar(this.getVarDec());
    }

    public final boolean canBeCopied() {
        return true;
    }

    public String getId() {
        return this.varDec.getId();
    }

    public ASTObject postMove(MovingWalker walker) {
        return walker.moveVarExpr(this);
    }

    public void unparse(CodeWriter writer) {
        writer.write(this.varDec.getId());
    }

    public void walkFlow(FlowCheckerPass w) {
        VarDec dec = this.getVarDec();
        if (!(dec instanceof FormalDec) && !w.getVars().isDefinitelyAssigned(this.getVarDec())) {
            this.showError("Variable " + this.getId() + " might not have a value");
        }
    }

    public ASTObject postAssignmentCheck(AssignmentCheckerPass walker) {
        if (this.isLhs()) {
            return this;
        }
        Expr initExpr = this.varDec.getInitializer();
        if (initExpr != null && this.varDec.isFinal() && initExpr instanceof LiteralExpr && !this.getType().isObject()) {
            return this.varDec.getType().foldCast((LiteralExpr)initExpr).setSource(this);
        }
        return this;
    }

    public void walkAnalysis(LocalClassPass.AnalysisWalker walker) {
        walker.processVarExpr(this);
    }

    public ASTObject postThreading(LocalClassPass.ThreadingWalker walker) {
        Object o = walker.lookup(this.getVarDec());
        if (o == null) {
            return this;
        }
        if (o instanceof FieldDec) {
            FieldDec fieldDec = (FieldDec)o;
            return this.getAST().makeGet(this.getAST().makePrimary((NameType)fieldDec.getDeclaringType(), (NameType)this.getLexicalType(), false, !this.isInConstructorCallExpr()), fieldDec);
        }
        return this.getAST().makeVar((FormalDec)o);
    }

    protected void cgEffect(CodeBuilder cb) {
    }

    protected void cgLvalue(CodeBuilder cb) {
    }

    protected void cgLtoRvalue(CodeBuilder cb) {
        this.getType().emitLoad(cb, this.getVarDec().getFrameLoc());
    }

    protected void cgAssignment(CodeBuilder cb) {
        this.getType().emitStore(cb, this.getVarDec().getFrameLoc());
    }

    protected void cgDupLvalue(CodeBuilder cb) {
    }

    protected void cgDupRvalue(CodeBuilder cb) {
        this.getType().emitDup(cb);
    }

    protected boolean isIncable() {
        return this.getType() instanceof IntType && this.getVarDec().getFrameLoc() < 255;
    }

    public VarDec getVarDec() {
        return this.varDec;
    }

    public void setVarDec(VarDec _varDec) {
        this.varDec = _varDec;
    }

    public VarExpr(SourceLocation location, VarDec _varDec) {
        super(location);
        this.setVarDec(_varDec);
    }

    protected VarExpr(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        VarExpr ret = new VarExpr(this.getSourceLocation());
        ret.preCopy(walker, this);
        ret.varDec = this.varDec;
        return ret;
    }

    public String getDefaultDisplayName() {
        return "VarExpr(varDec: " + this.varDec + ")";
    }
}

