/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import org.aspectj.compiler.base.AssignmentCheckerPass;
import org.aspectj.compiler.base.CodeWriter;
import org.aspectj.compiler.base.FlowCheckerPass;
import org.aspectj.compiler.base.FrameLocPass;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.ArrayInitializer;
import org.aspectj.compiler.base.ast.ArrayType;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Dec;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.Exprs;
import org.aspectj.compiler.base.ast.Modifiers;
import org.aspectj.compiler.base.ast.ScopeWalker;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.TypeD;
import org.aspectj.compiler.base.bcg.CodeBuilder;

public class VarDec
extends Dec {
    private int frameLoc;
    protected Modifiers modifiers;
    protected TypeD typeD;
    protected String id;
    protected Expr initializer;

    public String getKind() {
        return "var";
    }

    public void checkSpec() {
        if (this.typeD.getType().isVoid()) {
            this.typeD.showError("void type not allowed here");
        }
    }

    public boolean isBlank() {
        return this.getInitializer() == null;
    }

    public void walkFlow(FlowCheckerPass w) {
        w.setVars(w.getVars().addUnassigned(this));
        if (this.getInitializer() != null) {
            w.process(this.getInitializer());
            FlowCheckerPass.Vars v = w.getVars();
            if (this.isFinal() && !v.isDefinitelyUnassigned(this)) {
                w.showVarError(this, this, "Final variable " + this.getId() + " may already be assigned");
            }
            w.setVars(v.addAssigned(this));
        }
    }

    public void preAssignmentCheck(AssignmentCheckerPass walker) {
        Expr rhs = this.getInitializer();
        if (rhs != null && rhs instanceof ArrayInitializer) {
            ArrayInitializer ai = (ArrayInitializer)rhs;
            Type ty = this.getTypeD().getType();
            if (!(ty instanceof ArrayType)) {
                this.showError("Not of array type");
                this.setInitializer(null);
            } else {
                ArrayType arrayType = (ArrayType)ty;
                this.setInitializer(this.getAST().makeNewArray(arrayType, ai));
            }
        }
    }

    public ASTObject postAssignmentCheck(AssignmentCheckerPass walker) {
        this.checkAssignmentType();
        return this;
    }

    protected void checkAssignmentType() {
        Type ty = this.getType();
        Expr init = this.getInitializer();
        if (init != null && !init.isAssignableTo(ty)) {
            this.showTypeError(init.getType(), ty);
        }
    }

    public void preScope(ScopeWalker walker) {
        walker.addVarDec(this);
    }

    public boolean isIntroduced() {
        if (this.isField()) {
            return super.isIntroduced();
        }
        return false;
    }

    public boolean isField() {
        return false;
    }

    public boolean inStaticContext() {
        return this.getParent().inStaticContext();
    }

    public Type getType() {
        return this.getTypeD().getType();
    }

    public Expr getExpr() {
        return null;
    }

    public String toShortString() {
        return this.getTypeD().toShortString() + " " + this.getId();
    }

    public void unparse(CodeWriter writer, boolean isStmt, boolean showType) {
        if (showType) {
            this.writeModifiers(writer);
            writer.write(this.typeD);
            writer.requiredSpace();
            writer.write(this.getBytecodeId());
        } else {
            writer.write(this.getBytecodeId());
        }
        if (!writer.isOnlySignatures() && this.initializer != null) {
            writer.writeOp("=");
            if (this.initializer instanceof Exprs) {
                writer.write("{ ");
            }
            writer.write(this.initializer);
            if (this.initializer instanceof Exprs) {
                writer.write(" }");
            }
        }
        if (!writer.isOnlySignatures() && isStmt) {
            writer.closeStmt();
        }
    }

    public void unparse(CodeWriter writer) {
        this.unparse(writer, true, true);
    }

    public void walkFrameLoc(FrameLocPass walker) {
        this.setFrameLoc(walker.allocate(this.getType().getSlotCount()));
    }

    public String getDescriptor() {
        return this.getType().getDescriptor();
    }

    protected void cgStmt(CodeBuilder cb) {
        cb.enterVar(this);
        if (this.initializer != null) {
            Type ty = this.getType();
            this.initializer.cgValue(cb, ty);
            ty.emitStore(cb, this.frameLoc);
        }
    }

    public int getFrameLoc() {
        return this.frameLoc;
    }

    void setFrameLoc(int frameLoc) {
        this.frameLoc = frameLoc;
    }

    public VarDec(SourceLocation location, TypeD typeD, String id, Expr initializer) {
        this(location, new Modifiers(location, 0), typeD, id, initializer);
    }

    public Modifiers getModifiers() {
        return this.modifiers;
    }

    public void setModifiers(Modifiers _modifiers) {
        if (_modifiers != null) {
            _modifiers.setParent(this);
        }
        this.modifiers = _modifiers;
    }

    public TypeD getTypeD() {
        return this.typeD;
    }

    public void setTypeD(TypeD _typeD) {
        if (_typeD != null) {
            _typeD.setParent(this);
        }
        this.typeD = _typeD;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String _id) {
        this.id = _id;
    }

    public Expr getInitializer() {
        return this.initializer;
    }

    public void setInitializer(Expr _initializer) {
        if (_initializer != null) {
            _initializer.setParent(this);
        }
        this.initializer = _initializer;
    }

    public VarDec(SourceLocation location, Modifiers _modifiers, TypeD _typeD, String _id, Expr _initializer) {
        super(location);
        this.setModifiers(_modifiers);
        this.setTypeD(_typeD);
        this.setId(_id);
        this.setInitializer(_initializer);
    }

    protected VarDec(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        VarDec ret = new VarDec(this.getSourceLocation());
        ret.preCopy(walker, this);
        if (this.modifiers != null) {
            ret.setModifiers((Modifiers)walker.process(this.modifiers));
        }
        if (this.typeD != null) {
            ret.setTypeD((TypeD)walker.process(this.typeD));
        }
        ret.id = this.id;
        if (this.initializer != null) {
            ret.setInitializer((Expr)walker.process(this.initializer));
        }
        return ret;
    }

    public ASTObject getChildAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return this.modifiers;
            }
            case 1: {
                return this.typeD;
            }
            case 2: {
                return this.initializer;
            }
        }
        return super.getChildAt(childIndex);
    }

    public String getChildNameAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return "modifiers";
            }
            case 1: {
                return "typeD";
            }
            case 2: {
                return "initializer";
            }
        }
        return super.getChildNameAt(childIndex);
    }

    public void setChildAt(int childIndex, ASTObject child) {
        switch (childIndex) {
            case 0: {
                this.setModifiers((Modifiers)child);
                return;
            }
            case 1: {
                this.setTypeD((TypeD)child);
                return;
            }
            case 2: {
                this.setInitializer((Expr)child);
                return;
            }
        }
        super.setChildAt(childIndex, child);
    }

    public int getChildCount() {
        return 3;
    }

    public String getDefaultDisplayName() {
        return "VarDec(id: " + this.id + ")";
    }
}

