/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import org.aspectj.compiler.base.AssignmentCheckerPass;
import org.aspectj.compiler.base.CodeWriter;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.BitNotOpExpr;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.LiteralExpr;
import org.aspectj.compiler.base.ast.LogNotOpExpr;
import org.aspectj.compiler.base.ast.MinusOpExpr;
import org.aspectj.compiler.base.ast.PlusOpExpr;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.bcg.CodeBuilder;

public abstract class UnopExpr
extends Expr {
    protected String op;
    protected Expr rand1;

    protected void bindNamesSelf() {
    }

    public ASTObject postAssignmentCheck(AssignmentCheckerPass walker) {
        return this.tryToFold();
    }

    private ASTObject tryToFold() {
        if (this.getLiftType().isAnyType()) {
            return this;
        }
        if (this.rand1 instanceof LiteralExpr) {
            return this.halfFold(this.getLiftType(), (LiteralExpr)this.rand1).setSource(this);
        }
        return this;
    }

    protected abstract Type getLiftType();

    protected abstract LiteralExpr halfFold(Type var1, LiteralExpr var2);

    public static UnopExpr build(SourceLocation source, String op, Expr rand1) {
        if (op.equals("+")) {
            return new PlusOpExpr(source, op, rand1);
        }
        if (op.equals("-")) {
            return new MinusOpExpr(source, op, rand1);
        }
        if (op.equals("~")) {
            return new BitNotOpExpr(source, op, rand1);
        }
        if (op.equals("!")) {
            return new LogNotOpExpr(source, op, rand1);
        }
        throw new RuntimeException("strange unary op: " + op);
    }

    protected Type discoverType() {
        return this.getRand1().getType();
    }

    public void unparse(CodeWriter writer) {
        writer.write(this.getOp());
        writer.write(this.getRand1());
    }

    public void showOperatorTypeError(Type a) {
        if (a.isAnyType()) {
            return;
        }
        this.showError("operator " + this.op + " cannot be applied to " + a.getString());
    }

    protected void cgEffect(CodeBuilder cb) {
        this.rand1.cgEffect(cb);
    }

    public String getOp() {
        return this.op;
    }

    public void setOp(String _op) {
        this.op = _op;
    }

    public Expr getRand1() {
        return this.rand1;
    }

    public void setRand1(Expr _rand1) {
        if (_rand1 != null) {
            _rand1.setParent(this);
        }
        this.rand1 = _rand1;
    }

    public UnopExpr(SourceLocation location, String _op, Expr _rand1) {
        super(location);
        this.setOp(_op);
        this.setRand1(_rand1);
    }

    protected UnopExpr(SourceLocation source) {
        super(source);
    }

    public ASTObject getChildAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return this.rand1;
            }
        }
        return super.getChildAt(childIndex);
    }

    public String getChildNameAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return "rand1";
            }
        }
        return super.getChildNameAt(childIndex);
    }

    public void setChildAt(int childIndex, ASTObject child) {
        switch (childIndex) {
            case 0: {
                this.setRand1((Expr)child);
                return;
            }
        }
        super.setChildAt(childIndex, child);
    }

    public int getChildCount() {
        return 1;
    }

    public String getDefaultDisplayName() {
        return "UnopExpr(op: " + this.op + ")";
    }
}

