/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import org.aspectj.compiler.base.CodeWriter;
import org.aspectj.compiler.base.NameHygienePass;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.ScopeWalker;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.TypeDec;

public abstract class TypeD
extends ASTObject {
    private static final int UNQUALIFIED = 1;
    private static final int FULLY_QUALIFIED = 0;
    private static final int NULL_TRICK = 2;
    private int unparseRule;
    private boolean checkedQualification = false;

    public abstract Type getType();

    public String getString() {
        return this.getType().getString();
    }

    public String toShortString() {
        return this.getType().toShortString();
    }

    public void checkSpec() {
        if (this.fromSource() && this.getType() != null && !this.getType().isAnyType() && !this.getType().isMissing() && this.getType().getTypeDec() != null && !this.getType().getTypeDec().isAccessible(this)) {
            this.showError("can't access " + this.getType().getTypeDec().toShortString());
        }
    }

    public boolean isEquivalent(TypeD other) {
        return this.getType().isEquivalent(other.getType());
    }

    void makePublic(TypeDec typeDec) {
        if (typeDec == null) {
            return;
        }
        typeDec.getModifiers().setPublic(true);
        if (typeDec.getEnclosingTypeDec() != null) {
            this.makePublic(typeDec.getEnclosingTypeDec());
        }
    }

    void makeAccessible(Type type, ASTObject fromWhere) {
        if (type.isAccessible(fromWhere, true)) {
            return;
        }
        this.getCompiler().showMessage("  fixing access to type: " + type.toShortString());
        this.makePublic(type.getTypeDec());
    }

    public ASTObject postScope(ScopeWalker walker) {
        Type checkType;
        if (!(walker instanceof NameHygienePass)) {
            return this;
        }
        NameHygienePass pass = (NameHygienePass)walker;
        if (this.checkedQualification) {
            this.unparseRule = 0;
            return this;
        }
        this.checkedQualification = true;
        this.makeAccessible(this.getType(), this);
        this.unparseRule = this.getType().getTypeDec() != null && this.getType().getTypeDec().hasGlobalName() ? (pass.canUseUnqualifiedName(checkType = this.getType().getOutermostType(), this) ? 1 : (pass.mustUseNullTrick(checkType, this) ? 2 : 0)) : 0;
        return this;
    }

    public void unparse(CodeWriter writer) {
        this.unparse(writer, false);
    }

    public void unparse(CodeWriter writer, boolean inExprPosition) {
        Type type = this.getType();
        int realUnparseRule = this.unparseRule;
        if (writer.isOnlySignatures() || !this.checkedQualification) {
            // empty if block
        }
        if (!inExprPosition && realUnparseRule == 2) {
            realUnparseRule = 0;
        }
        switch (realUnparseRule) {
            case 1: {
                writer.write(this.getType().getExtendedId().replace('$', '.'));
                break;
            }
            case 0: {
                writer.write(this.getType().getString());
                break;
            }
            case 2: {
                writer.write("((");
                writer.write(this.getType().getString());
                writer.write(")null)");
            }
        }
    }

    public TypeD(SourceLocation location) {
        super(location);
    }

    public String getDefaultDisplayName() {
        return "TypeD()";
    }
}

