/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.aspectj.compiler.base.JavaCompiler;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.ArrayType;
import org.aspectj.compiler.base.ast.Constructor;
import org.aspectj.compiler.base.ast.Dec;
import org.aspectj.compiler.base.ast.EqualityTestOpExpr;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.Exprs;
import org.aspectj.compiler.base.ast.Field;
import org.aspectj.compiler.base.ast.LiteralExpr;
import org.aspectj.compiler.base.ast.Method;
import org.aspectj.compiler.base.ast.NumericTestOpExpr;
import org.aspectj.compiler.base.ast.RefType;
import org.aspectj.compiler.base.ast.ResolvedTypeD;
import org.aspectj.compiler.base.ast.SemanticObject;
import org.aspectj.compiler.base.ast.TypeD;
import org.aspectj.compiler.base.ast.TypeDec;
import org.aspectj.compiler.base.bcg.CodeBuilder;
import org.aspectj.compiler.base.bcg.Label;
import org.aspectj.compiler.crosscuts.ast.PointcutSO;

public abstract class Type
extends SemanticObject {
    private ArrayType arrayType = null;
    protected final Set directSubTypes = new HashSet();
    protected final Set directSuperTypes = new HashSet();
    public static final int REF = 0;
    public static final int VOID = 1;
    public static final int BOOLEAN = 4;
    public static final int CHAR = 5;
    public static final int FLOAT = 6;
    public static final int DOUBLE = 7;
    public static final int BYTE = 8;
    public static final int SHORT = 9;
    public static final int INT = 10;
    public static final int LONG = 11;

    public synchronized ArrayType getArrayType() {
        if (this.arrayType == null) {
            this.arrayType = new ArrayType(this.getCompiler(), this);
        }
        return this.arrayType;
    }

    public int getArrayDimCount() {
        return 0;
    }

    public Type getBaseComponentType() {
        return this;
    }

    public void addDirectSuperType(Type superType) {
        if (superType == this) {
            this.getCompiler().showError(this.getTypeDec(), this.getString() + " tries to extend itself");
        }
        this.directSuperTypes.add(superType);
        superType.directSubTypes.add(this);
    }

    public Type(JavaCompiler compiler) {
        super(compiler);
    }

    protected void showNotFoundError(String id, ASTObject fromWhere, String kind) {
        this.getCompiler().showError(fromWhere, "no " + kind + "s on " + this.toShortString());
    }

    public boolean isEffectivelyStatic() {
        return true;
    }

    public void ensureBuiltTypeGraph() {
    }

    public void ensureFinishedSignature() {
    }

    public void buildTypeGraph() {
    }

    public void validateTypeGraph() {
    }

    public void finishTypeIntroductions() {
        this.ensureBuiltTypeGraph();
    }

    public void finish() {
        this.finishTypeIntroductions();
    }

    public Collection getDirectSuperTypes() {
        this.buildTypeGraph();
        return this.directSuperTypes;
    }

    public Collection getDirectSubTypes() {
        this.buildTypeGraph();
        return this.directSubTypes;
    }

    public Type getDeclaringType() {
        return null;
    }

    public TypeDec getTypeDec() {
        return (TypeDec)this.dec;
    }

    public PointcutSO getPointcut(String id, ASTObject fromWhere, boolean showError) {
        if (showError) {
            this.showNotFoundError(id, fromWhere, "pointcut");
        }
        return null;
    }

    public Field getField(String id, ASTObject fromWhere, boolean showError) {
        if (showError) {
            this.showNotFoundError(id, fromWhere, "field");
        }
        return null;
    }

    public Type getInnerType(String id, ASTObject fromWhere, boolean showError) {
        if (showError) {
            this.showNotFoundError(id, fromWhere, "inner type");
        }
        return this.getTypeManager().TYPE_NOT_FOUND;
    }

    public Method getMethod(String id, ASTObject fromWhere, Exprs params, boolean showError) {
        if (showError) {
            this.showNotFoundError(id, fromWhere, "method");
        }
        return null;
    }

    public Constructor getConstructor(ASTObject fromWhere, Exprs params, boolean showError) {
        if (showError) {
            this.showNotFoundError(this.getPrettyString(), fromWhere, "constructor");
        }
        return null;
    }

    public boolean hasMethodNamed(String id) {
        return false;
    }

    public SemanticObject findMatchingSemanticObject(SemanticObject o) {
        return null;
    }

    public Dec findMatchingDec(Dec dec) {
        SemanticObject o = this.findMatchingSemanticObject(dec.getCorrespondingSemanticObject());
        if (o == null) {
            return null;
        }
        return o.getCorrespondingDec();
    }

    public Collection getInheritedMethods() {
        return Collections.EMPTY_LIST;
    }

    public Collection getInheritedMembers() {
        return Collections.EMPTY_LIST;
    }

    public boolean isCloneable() {
        return false;
    }

    public boolean isInterface() {
        return false;
    }

    public boolean isClass() {
        return false;
    }

    public boolean isAspect() {
        return false;
    }

    public boolean isConcrete() {
        return this.isClass();
    }

    public boolean isAbstract() {
        return false;
    }

    public boolean isInnerType() {
        return false;
    }

    public boolean isMissing() {
        return false;
    }

    public boolean isAnonymous() {
        return false;
    }

    public boolean isAssignableFrom(Type other) {
        return other.isSubtypeOf(this);
    }

    public boolean isSubtypeOf(Type other) {
        this.ensureBuiltTypeGraph();
        if (this.isEquivalent(other)) {
            return true;
        }
        Iterator i = this.directSuperTypes.iterator();
        while (i.hasNext()) {
            Type superType = (Type)i.next();
            if (superType.isMissing() || !superType.isSubtypeOf(other)) continue;
            return true;
        }
        return false;
    }

    public boolean isStrictSubtypeOf(Type other) {
        return this != other && this.isSubtypeOf(other);
    }

    public abstract boolean isCoercableTo(Type var1);

    public boolean isMethodConvertableTo(Type other) {
        return other.isAssignableFrom(this);
    }

    public boolean isEquivalent(Type other) {
        return this.isAnyType() || other.isAnyType() || this == other;
    }

    public boolean dominates(Type other) {
        return this.isStrictSubtypeOf(other);
    }

    public TypeD makeTypeD() {
        return new ResolvedTypeD(this.getAST().getSourceLocation(), this);
    }

    public Expr getClassExpr() {
        throw new RuntimeException("internal error: no class expr for " + this);
    }

    public Expr fromObject(Expr expr) {
        return null;
    }

    public Expr makeObject(Expr expr) {
        return expr;
    }

    public Expr getNullExpr() {
        return null;
    }

    public Type getRefType() {
        return this;
    }

    public Type getOutermostType() {
        return this;
    }

    public Type getPrivateCookieType() {
        return this.getOutermostType();
    }

    public Type getPackageCookieType() {
        return this.getOutermostType();
    }

    public boolean isObject() {
        return this == this.getTypeManager().getObjectType();
    }

    public boolean isUncheckedThrowable() {
        if (this.isSubtypeOf(this.getTypeManager().getErrorType())) {
            return true;
        }
        return this.isSubtypeOf(this.getTypeManager().getRuntimeExceptionType());
    }

    public boolean isVoid() {
        return this == this.getTypeManager().voidType;
    }

    public boolean isReferenceType() {
        return this instanceof RefType;
    }

    public boolean isString() {
        return this == this.getTypeManager().getStringType();
    }

    public final boolean isPrimitive() {
        return this.isNumeric() || this.isBoolean() || this.isVoid();
    }

    public final boolean isNumeric() {
        return this.isIntegral() || this == this.getTypeManager().floatType || this == this.getTypeManager().doubleType;
    }

    public final boolean isIntegral() {
        return this == this.getTypeManager().byteType || this == this.getTypeManager().charType || this == this.getTypeManager().shortType || this == this.getTypeManager().intType || this == this.getTypeManager().longType;
    }

    public final boolean isBoolean() {
        return this == this.getTypeManager().booleanType;
    }

    public boolean isAnyType() {
        return false;
    }

    public abstract String toShortString();

    public String getString() {
        return this.toShortString();
    }

    public String getPrettyString() {
        return this.toShortString();
    }

    public String getId() {
        return this.toShortString();
    }

    public String getExtendedId() {
        return this.toShortString();
    }

    public String getSourceExtendedId() {
        return this.toShortString();
    }

    public String getPackageName() {
        return null;
    }

    public Type getOutermostLexicalType() {
        return this;
    }

    public Type getOutermostBytecodeType() {
        return this.getOutermostType();
    }

    public boolean isAccessible(ASTObject fromWhere, boolean inBytecode) {
        if (this.isPrimitive()) {
            return true;
        }
        if (this.getArrayDimCount() > 0) {
            return this.getBaseComponentType().isAccessible(fromWhere, inBytecode);
        }
        return super.isAccessible(fromWhere, inBytecode);
    }

    private static boolean anyParentsInSet(Type type, Set set) {
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            Type testType = (Type)iter.next();
            if (!type.isStrictSubtypeOf(testType)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasMatchingType(Collection c, Type t) {
        Iterator j = c.iterator();
        while (j.hasNext()) {
            Type testType = (Type)j.next();
            if (!t.isSubtypeOf(testType)) continue;
            return true;
        }
        return false;
    }

    public static Set intersect(Set t1, Set t2) {
        HashSet<Type> ret = new HashSet<Type>();
        Iterator i = t1.iterator();
        while (i.hasNext()) {
            Type t = (Type)i.next();
            if (!Type.hasMatchingType(t2, t)) continue;
            ret.add(t);
        }
        Iterator i2 = t2.iterator();
        while (i2.hasNext()) {
            Type t = (Type)i2.next();
            if (!Type.hasMatchingType(t1, t)) continue;
            ret.add(t);
        }
        return ret;
    }

    public static Set filterTopTypes(Set set) {
        HashSet<Type> topSet = new HashSet<Type>();
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            Type testType = (Type)iter.next();
            if (Type.anyParentsInSet(testType, set)) continue;
            topSet.add(testType);
        }
        return topSet;
    }

    public static Set filterSubTypes(Type type, Set set) {
        HashSet<Type> topSet = new HashSet<Type>();
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            Type testType = (Type)iter.next();
            if (testType.isSubtypeOf(type)) {
                topSet.add(testType);
                continue;
            }
            if (!type.isSubtypeOf(testType)) continue;
            topSet.add(type);
        }
        return topSet;
    }

    private void addMySubTypes(Set types) {
        if (types.contains(this)) {
            return;
        }
        types.add(this);
        Iterator i = this.directSubTypes.iterator();
        while (i.hasNext()) {
            Type addType = (Type)i.next();
            addType.addMySubTypes(types);
        }
    }

    public Set getSubTypes() {
        HashSet subTypes = new HashSet();
        this.addMySubTypes(subTypes);
        return subTypes;
    }

    public static Set addSubTypes(Set types) {
        HashSet newTypes = new HashSet();
        Iterator iter = types.iterator();
        while (iter.hasNext()) {
            Type type = (Type)iter.next();
            newTypes.addAll(type.getSubTypes());
        }
        return newTypes;
    }

    private void addMySuperInterfaces(Set types) {
        if (types.contains(this)) {
            return;
        }
        if (this.isInterface()) {
            types.add(this);
        }
        Iterator i = this.directSuperTypes.iterator();
        while (i.hasNext()) {
            Type addType = (Type)i.next();
            addType.addMySuperInterfaces(types);
        }
    }

    public Set getAllSuperInterfaces() {
        HashSet newTypes = new HashSet();
        this.addMySuperInterfaces(newTypes);
        return newTypes;
    }

    public static Set filterConcreteTypes(Set types) {
        HashSet<Type> newTypes = new HashSet<Type>();
        Iterator iter = types.iterator();
        while (iter.hasNext()) {
            Type type = (Type)iter.next();
            if (!type.isConcrete()) continue;
            newTypes.add(type);
        }
        return newTypes;
    }

    public static Set makeTypeSet(Collection typeDecSet) {
        HashSet<Type> ret = new HashSet<Type>();
        Iterator i = typeDecSet.iterator();
        while (i.hasNext()) {
            ret.add(((TypeDec)i.next()).getType());
        }
        return ret;
    }

    final LiteralExpr unsupportedFold() {
        throw new RuntimeException("Unsupported fold on " + this);
    }

    abstract LiteralExpr foldCast(LiteralExpr var1);

    abstract LiteralExpr foldPlusOp(LiteralExpr var1);

    abstract LiteralExpr foldMinusOp(LiteralExpr var1);

    abstract LiteralExpr foldBitNotOp(LiteralExpr var1);

    abstract LiteralExpr foldLogNotOp(LiteralExpr var1);

    abstract LiteralExpr foldAddOp(LiteralExpr var1, LiteralExpr var2);

    abstract LiteralExpr foldNumericOp(String var1, LiteralExpr var2, LiteralExpr var3);

    abstract LiteralExpr foldBitwiseOp(String var1, LiteralExpr var2, LiteralExpr var3);

    abstract LiteralExpr foldShiftOp(String var1, LiteralExpr var2, LiteralExpr var3);

    abstract LiteralExpr foldEqualityTestOp(String var1, LiteralExpr var2, LiteralExpr var3);

    abstract LiteralExpr foldNumericTestOp(String var1, LiteralExpr var2, LiteralExpr var3);

    public int getTypeIndex() {
        return 0;
    }

    void emitMultiNewarray(CodeBuilder cb, int filledDims) {
        throw new RuntimeException("Unsupported emit on " + this);
    }

    void emitPop(CodeBuilder cb) {
        cb.emitPOP();
    }

    void emitDup(CodeBuilder cb) {
        cb.emitDUP();
    }

    void emitDupX1(CodeBuilder cb) {
        cb.emitDUP_X1();
    }

    void emitDupX2(CodeBuilder cb) {
        cb.emitDUP_X2();
    }

    final void unsupportedEmit() {
        throw new RuntimeException("Unsupported emit on " + this);
    }

    abstract void emitAload(CodeBuilder var1);

    abstract void emitAstore(CodeBuilder var1);

    abstract void emitInstanceof(CodeBuilder var1);

    abstract void emitBitNot(CodeBuilder var1);

    abstract void emitLogNot(CodeBuilder var1);

    abstract void emitNewarray(CodeBuilder var1);

    abstract void emitZero(CodeBuilder var1);

    abstract void emitOne(CodeBuilder var1);

    abstract void emitMinusOne(CodeBuilder var1);

    abstract void emitAdd(CodeBuilder var1);

    abstract void emitNeg(CodeBuilder var1);

    abstract void emitNumericOp(CodeBuilder var1, String var2);

    abstract void emitBitwiseOp(CodeBuilder var1, String var2);

    abstract void emitShiftOp(CodeBuilder var1, String var2);

    abstract void emitCast(CodeBuilder var1, Type var2);

    public abstract void emitLoad(CodeBuilder var1, int var2);

    public abstract void emitStore(CodeBuilder var1, int var2);

    public abstract void emitReturn(CodeBuilder var1);

    abstract void emitEqualityCompare(CodeBuilder var1, String var2, Label var3, Label var4);

    abstract void emitNumericCompare(CodeBuilder var1, String var2, Label var3, Label var4);

    boolean hasFastEqualityTestOp() {
        return false;
    }

    void emitFastEqualityTestOp(CodeBuilder cb, EqualityTestOpExpr e, Label t, Label f) {
        throw new RuntimeException("no fast equality op available");
    }

    boolean hasFastNumericTestOp() {
        return false;
    }

    void emitFastNumericTestOp(CodeBuilder cb, NumericTestOpExpr e, Label t, Label f) {
        throw new RuntimeException("no fast numeric op available");
    }

    boolean hasFastIncOp(Expr lhs, int rhs) {
        return false;
    }

    void emitFastIncOp(CodeBuilder cb, Expr lhs, int rhs) {
        throw new RuntimeException("no fast inc op available");
    }

    public String getInternalName() {
        throw new RuntimeException("No internal name for " + this);
    }

    public String getExternalName() {
        return this.getString();
    }

    public List getNamePieces() {
        int nextDot;
        String s = this.getString();
        ArrayList<String> ret = new ArrayList<String>();
        int lastDot = 0;
        while ((nextDot = s.indexOf(46, lastDot)) != -1) {
            ret.add(s.substring(lastDot, nextDot));
            lastDot = nextDot + 1;
        }
        ret.add(s.substring(lastDot));
        return ret;
    }

    public abstract String getDescriptor();

    public int getSlotCount() {
        return 1;
    }
}

