/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import java.util.Iterator;
import java.util.Set;
import org.aspectj.compiler.base.ASTFixerPass;
import org.aspectj.compiler.base.ByteCodeCleanupPass;
import org.aspectj.compiler.base.CodeWriter;
import org.aspectj.compiler.base.ExceptionFinder;
import org.aspectj.compiler.base.FlowCheckerPass;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CatchClause;
import org.aspectj.compiler.base.ast.CatchClauses;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.EmptyStmt;
import org.aspectj.compiler.base.ast.FormalDec;
import org.aspectj.compiler.base.ast.NameType;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Stmt;
import org.aspectj.compiler.base.ast.TryStmt;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.bcg.CodeBuilder;
import org.aspectj.compiler.base.bcg.Label;

public class TryCatchStmt
extends TryStmt {
    protected Stmt body;
    protected CatchClauses catches;

    public void checkSpec() {
        super.checkSpec();
        if (this.catches.size() == 0) {
            this.showError("'try' without 'catch' or 'finally'");
        }
        this.body.requireBlockStmt();
    }

    public void unparse(CodeWriter writer) {
        if (this.catches.size() == 0) {
            writer.write(this.body);
            return;
        }
        writer.writeKeyword("try");
        writer.optionalSpace();
        writer.write(this.body);
        writer.writeChildren(this.catches);
    }

    public ASTObject postFixAST(ASTFixerPass fixer) {
        if (!this.isOptional()) {
            return super.postFixAST(fixer);
        }
        Set exceptions = ExceptionFinder.getPossibleExceptions(this.getBody(), true);
        exceptions.add(this.getTypeManager().getRuntimeExceptionType());
        exceptions.add(this.getTypeManager().getErrorType());
        this.filterCatchClauses(this.catches, exceptions);
        this.setIsOptional(false);
        return super.postFixAST(fixer);
    }

    private void filterCatchClauses(CatchClauses ccs, Set exceptions) {
        int i = 0;
        while (i < ccs.size()) {
            CatchClause cc = ccs.get(i);
            if (!this.possibleCatchClause(cc, exceptions)) {
                ccs.remove(i);
                --i;
            }
            ++i;
        }
    }

    private boolean possibleCatchClause(CatchClause cc, Set exceptions) {
        return this.canThrow(exceptions, cc.getFormal().getType());
    }

    private boolean canThrow(Set types, Type baseType) {
        Iterator iter = types.iterator();
        while (iter.hasNext()) {
            Type checkType = (Type)iter.next();
            if (checkType == null || !checkType.isSubtypeOf(baseType) && !baseType.isSubtypeOf(checkType)) continue;
            return true;
        }
        return false;
    }

    public void walkFlow(FlowCheckerPass w) {
        FlowCheckerPass.Vars beforeV = w.getVars();
        FlowCheckerPass.ESet beforeExns = w.popExns();
        w.enterContext(this);
        w.process(this.getBody());
        w.leaveContext();
        boolean bodyLive = w.isLive();
        FlowCheckerPass.ESet bodyExns = w.popExns();
        FlowCheckerPass.Vars v = w.getVars();
        FlowCheckerPass.Vars tv = w.getTryVars(this);
        FlowCheckerPass.Vars cv = FlowCheckerPass.Vars.makeSets(beforeV.getDa(), v.getDua().inter(tv.getDua()));
        FlowCheckerPass.ESet caughtExns = FlowCheckerPass.ESet.getEmpty();
        FlowCheckerPass.ESet thrownExns = beforeExns;
        FlowCheckerPass.Vars cvExit = v;
        boolean liveSoFar = bodyLive;
        CatchClauses c = this.getCatches();
        if (c != null) {
            int i = 0;
            int len = c.size();
            while (i < len) {
                CatchClause cl = c.get(i);
                NameType exnType = (NameType)cl.getFormal().getType();
                if (!bodyExns.containsSuperOrSub(exnType) && !exnType.isUncheckedThrowable() && exnType != this.getTypeManager().getExceptionType() && exnType != this.getTypeManager().getThrowableType()) {
                    cl.showError("exception " + exnType.getId() + " is never thrown in body of corresponding try statement");
                } else if (caughtExns.containsSuper(exnType)) {
                    cl.showError("exception " + exnType.getId() + " has already been caught");
                } else {
                    w.setLive(true);
                    w.setVars(cv);
                    w.enterContext(this);
                    w.process(cl);
                    w.leaveContext();
                    liveSoFar |= w.isLive();
                    cvExit = cvExit.join(w.getVars());
                    thrownExns = thrownExns.union(w.popExns());
                    caughtExns = caughtExns.add(exnType);
                }
                ++i;
            }
        }
        w.setExns(bodyExns.diff(caughtExns).union(thrownExns).union(beforeExns));
        w.setVars(cvExit);
        w.releasePendingTransfers(this);
        w.setLive(liveSoFar);
    }

    public void walkCleanup(ByteCodeCleanupPass w) {
        boolean bodyLive;
        w.enterContext(this);
        this.setBody((Stmt)w.process(this.getBody()));
        w.leaveContext();
        boolean liveSoFar = bodyLive = w.isLive();
        CatchClauses c = this.getCatches();
        int i = 0;
        int len = c.size();
        while (i < len) {
            CatchClause cl = c.get(i);
            w.setLive(true);
            w.process(cl);
            liveSoFar = liveSoFar || w.isLive();
            ++i;
        }
        w.setLive(liveSoFar);
    }

    public ASTObject postCleanup(ByteCodeCleanupPass walker) {
        if (this.getBody() instanceof EmptyStmt) {
            return this.getAST().makeEmptyStmt().setSource(this);
        }
        return this;
    }

    protected void cgStmt(CodeBuilder cb) {
        Label startBody = cb.genAnchor();
        Label endBody = cb.genAnchor();
        Label end = cb.genLabel();
        cb.emitLabel(startBody);
        this.getBody().cgTop(cb);
        cb.emitLabel(endBody);
        if (this.body.completesNormally()) {
            cb.emitJump(end);
        }
        int i = 0;
        int len = this.catches.size();
        while (i < len) {
            CatchClause clause = this.catches.get(i);
            Label exnStart = cb.genAnchor();
            FormalDec clauseFormal = clause.getFormal();
            Stmt clauseBody = clause.getBody();
            cb.enterBlock();
            cb.enterVar(clauseFormal);
            cb.emitLabel(exnStart);
            cb.pushStack(1);
            cb.emitASTORE(clauseFormal.getFrameLoc());
            clauseBody.cgTop(cb);
            if (clauseBody.completesNormally()) {
                cb.emitJump(end);
            }
            cb.addHandler(startBody, endBody, exnStart, (NameType)clauseFormal.getType());
            cb.exitBlock();
            ++i;
        }
        cb.emitLabel(end);
    }

    public Stmt getBody() {
        return this.body;
    }

    public void setBody(Stmt _body) {
        if (_body != null) {
            _body.setParent(this);
        }
        this.body = _body;
    }

    public CatchClauses getCatches() {
        return this.catches;
    }

    public void setCatches(CatchClauses _catches) {
        if (_catches != null) {
            _catches.setParent(this);
        }
        this.catches = _catches;
    }

    public TryCatchStmt(SourceLocation location, Stmt _body, CatchClauses _catches) {
        super(location);
        this.setBody(_body);
        this.setCatches(_catches);
    }

    protected TryCatchStmt(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        TryCatchStmt ret = new TryCatchStmt(this.getSourceLocation());
        ret.preCopy(walker, this);
        if (this.body != null) {
            ret.setBody((Stmt)walker.process(this.body));
        }
        if (this.catches != null) {
            ret.setCatches((CatchClauses)walker.process(this.catches));
        }
        return ret;
    }

    public ASTObject getChildAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return this.body;
            }
            case 1: {
                return this.catches;
            }
        }
        return super.getChildAt(childIndex);
    }

    public String getChildNameAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return "body";
            }
            case 1: {
                return "catches";
            }
        }
        return super.getChildNameAt(childIndex);
    }

    public void setChildAt(int childIndex, ASTObject child) {
        switch (childIndex) {
            case 0: {
                this.setBody((Stmt)child);
                return;
            }
            case 1: {
                this.setCatches((CatchClauses)child);
                return;
            }
        }
        super.setChildAt(childIndex, child);
    }

    public int getChildCount() {
        return 2;
    }

    public String getDefaultDisplayName() {
        return "TryCatchStmt()";
    }
}

