/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import java.util.Arrays;
import java.util.HashSet;
import org.aspectj.compiler.base.ByteCodeCleanupPass;
import org.aspectj.compiler.base.CodeWriter;
import org.aspectj.compiler.base.FlowCheckerPass;
import org.aspectj.compiler.base.FrameLocPass;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Dec;
import org.aspectj.compiler.base.ast.Decs;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.IntLiteralExpr;
import org.aspectj.compiler.base.ast.IntishType;
import org.aspectj.compiler.base.ast.LiteralExpr;
import org.aspectj.compiler.base.ast.ScopeWalker;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Stmt;
import org.aspectj.compiler.base.ast.Stmts;
import org.aspectj.compiler.base.ast.SwitchClause;
import org.aspectj.compiler.base.ast.SwitchClauses;
import org.aspectj.compiler.base.ast.SwitchStmt;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.VarDec;
import org.aspectj.compiler.base.bcg.CodeBuilder;
import org.aspectj.compiler.base.bcg.Label;

public class SwitchStmt
extends Stmt {
    protected Expr expr;
    protected SwitchClauses clauses;

    public boolean isBreakable() {
        return true;
    }

    public void walkFlow(FlowCheckerPass w) {
        SwitchClauses c = this.getClauses();
        w.process(this.getExpr());
        FlowCheckerPass.Vars v = w.getVars();
        int i = 0;
        int len = c.size();
        while (i < len) {
            v = this.findTopLevelVars(v, c.get(i).getStmts());
            ++i;
        }
        w.setVars(v);
        w.enterContext(this);
        boolean hasDefault = false;
        int i2 = 0;
        int len2 = c.size();
        while (i2 < len2) {
            if (c.get(i2).getLabel() == null) {
                hasDefault = true;
            }
            w.setLive(true);
            w.setVars(v.join(w.getVars()));
            w.process(c.get(i2));
            w.setVars(w.getVars());
            ++i2;
        }
        w.leaveContext();
        if (!hasDefault) {
            w.setVars(w.getVars().join(v));
        }
        FlowCheckerPass.Vars bv = w.getBreakVars(this);
        w.setLive(w.isLive() || !hasDefault || w.isBroken(this));
        w.setVars(w.getVars().join(bv));
    }

    private FlowCheckerPass.Vars findTopLevelVars(FlowCheckerPass.Vars v, Stmts ss) {
        int i = 0;
        int len = ss.size();
        while (i < len) {
            Stmt s = ss.get(i);
            if (s instanceof VarDec) {
                v = v.addUnassigned((VarDec)s);
            } else if (s instanceof Decs) {
                v = this.findTopLevelVars(v, (Decs)s);
            }
            ++i;
        }
        return v;
    }

    private FlowCheckerPass.Vars findTopLevelVars(FlowCheckerPass.Vars v, Decs ds) {
        int i = 0;
        int len = ds.size();
        while (i < len) {
            Dec d = ds.get(i);
            if (d instanceof VarDec) {
                v = v.addUnassigned((VarDec)d);
            }
            ++i;
        }
        return v;
    }

    public void preScope(ScopeWalker walker) {
        walker.pushBlock();
    }

    public ASTObject postScope(ScopeWalker walker) {
        walker.popBlock();
        return this;
    }

    public void checkSpec() {
        Type exprType = this.expr.getType();
        if (!(exprType instanceof IntishType)) {
            this.expr.showTypeError(exprType, this.getTypeManager().intType);
        }
        boolean hasDefault = false;
        HashSet<Integer> seenLabels = new HashSet<Integer>();
        int i = 0;
        int len = this.clauses.size();
        while (i < len) {
            SwitchClause c = this.clauses.get(i);
            Expr label = c.getLabel();
            if (label == null) {
                if (hasDefault) {
                    c.showError("duplicate default label");
                } else {
                    hasDefault = true;
                }
            } else if (label instanceof LiteralExpr) {
                if (!label.isAssignableTo(exprType)) {
                    label.showTypeError(label.getType(), exprType);
                } else if (label instanceof IntLiteralExpr) {
                    Integer intObj = new Integer(((IntLiteralExpr)label).getIntValue());
                    if (seenLabels.contains(intObj)) {
                        label.showError("duplicate label");
                    } else {
                        seenLabels.add(intObj);
                    }
                } else {
                    label.showError("expected int constant");
                }
            } else {
                label.showError("constant expression required");
            }
            ++i;
        }
    }

    public void unparse(CodeWriter writer) {
        writer.writeKeyword("switch");
        writer.requiredSpace();
        writer.parenExpr(this.expr);
        writer.openBlock();
        writer.writeChildren(this.clauses);
        writer.closeBlock();
    }

    public void walkCleanup(ByteCodeCleanupPass w) {
        SwitchClauses c = this.getClauses();
        w.enterContext(this);
        boolean hasDefault = false;
        int i = 0;
        int len = c.size();
        while (i < len) {
            if (c.get(i).getLabel() == null) {
                hasDefault = true;
            }
            w.setLive(true);
            c.get(i).getStmts().walkCleanup(w);
            ++i;
        }
        w.leaveContext();
        w.setLive(w.isLive() || !hasDefault || w.isBroken(this));
    }

    protected void cgStmt(CodeBuilder cb) {
        Label endLab;
        Label defaultLab = endLab = cb.genLabel();
        int len = this.getClauses().size();
        boolean hasCases = false;
        class Pair
        implements Comparable {
            int i;
            Label l;
            private final /* synthetic */ SwitchStmt this$0;

            Pair(SwitchStmt this$0, int i, Label l) {
                this.this$0 = this$0;
                this.i = i;
                this.l = l;
            }

            public int compareTo(Object o) {
                int other = ((Pair)o).i;
                return this.i > other ? 1 : (this.i == other ? 0 : -1);
            }

            public String toString() {
                return "<" + this.i + ", " + "l" + ">";
            }
        }
        Object[] table = new Pair[len];
        Label[] clauseStarts = new Label[len];
        int ti = 0;
        int i = 0;
        while (i < len) {
            Label caseCodeLabel;
            SwitchClause clause = this.getClauses().get(i);
            IntLiteralExpr caseLabel = (IntLiteralExpr)clause.getLabel();
            clauseStarts[i] = caseCodeLabel = cb.genLabel();
            if (caseLabel == null) {
                defaultLab = caseCodeLabel;
            } else {
                hasCases = true;
                table[ti++] = new Pair(this, caseLabel.getIntValue(), caseCodeLabel);
            }
            ++i;
        }
        Arrays.sort(table, 0, ti);
        int[] keys = new int[ti];
        Label[] labels = new Label[ti];
        int i2 = 0;
        while (i2 < ti) {
            keys[i2] = ((Pair)table[i2]).i;
            labels[i2] = ((Pair)table[i2]).l;
            ++i2;
        }
        if (hasCases) {
            this.getExpr().cgValue(cb);
            cb.emitSwitch(keys, labels, defaultLab);
        } else {
            this.getExpr().cgEffect(cb);
        }
        cb.enterNonWindingContext(this, endLab, null);
        int i3 = 0;
        while (i3 < len) {
            Label caseCodeLabel = clauseStarts[i3];
            Stmts caseCode = this.getClauses().get(i3).getStmts();
            cb.emitLabel(caseCodeLabel);
            caseCode.cgStmts(cb);
            ++i3;
        }
        cb.leaveContext();
        cb.emitLabel(endLab);
    }

    public void walkFrameLoc(FrameLocPass walker) {
        int start = walker.getfs();
        super.walkFrameLoc(walker);
        walker.setfs(start);
    }

    public Expr getExpr() {
        return this.expr;
    }

    public void setExpr(Expr _expr) {
        if (_expr != null) {
            _expr.setParent(this);
        }
        this.expr = _expr;
    }

    public SwitchClauses getClauses() {
        return this.clauses;
    }

    public void setClauses(SwitchClauses _clauses) {
        if (_clauses != null) {
            _clauses.setParent(this);
        }
        this.clauses = _clauses;
    }

    public SwitchStmt(SourceLocation location, Expr _expr, SwitchClauses _clauses) {
        super(location);
        this.setExpr(_expr);
        this.setClauses(_clauses);
    }

    protected SwitchStmt(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        SwitchStmt ret = new SwitchStmt(this.getSourceLocation());
        ret.preCopy(walker, this);
        if (this.expr != null) {
            ret.setExpr((Expr)walker.process(this.expr));
        }
        if (this.clauses != null) {
            ret.setClauses((SwitchClauses)walker.process(this.clauses));
        }
        return ret;
    }

    public ASTObject getChildAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return this.expr;
            }
            case 1: {
                return this.clauses;
            }
        }
        return super.getChildAt(childIndex);
    }

    public String getChildNameAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return "expr";
            }
            case 1: {
                return "clauses";
            }
        }
        return super.getChildNameAt(childIndex);
    }

    public void setChildAt(int childIndex, ASTObject child) {
        switch (childIndex) {
            case 0: {
                this.setExpr((Expr)child);
                return;
            }
            case 1: {
                this.setClauses((SwitchClauses)child);
                return;
            }
        }
        super.setChildAt(childIndex, child);
    }

    public int getChildCount() {
        return 2;
    }

    public String getDefaultDisplayName() {
        return "SwitchStmt()";
    }
}

