/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import org.aspectj.compiler.base.CodeWriter;
import org.aspectj.compiler.base.InnerInfoPass;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CallExpr;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.FieldAccessExpr;
import org.aspectj.compiler.base.ast.NameType;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.bcg.CodeBuilder;

public class SuperExpr
extends Expr {
    public final Type discoverType() {
        return this.getThisType().getSuperClassType();
    }

    public NameType getThisType() {
        return (NameType)this.getDeclaringType();
    }

    public void unparse(CodeWriter writer) {
        if (this.inAllowedPosition()) {
            writer.writeKeyword("super");
        } else {
            writer.writeKeyword("this");
        }
    }

    public void checkSpec() {
        super.checkSpec();
        if (!this.inAllowedPosition()) {
            this.showError("bad identifier");
        }
    }

    public boolean inAllowedPosition() {
        SuperExpr self = this;
        ASTObject parent = this.getParent();
        return parent instanceof Expr && (parent instanceof CallExpr ? ((CallExpr)parent).getExpr() == self : parent instanceof FieldAccessExpr && ((FieldAccessExpr)parent).getExpr() == self);
    }

    public void postInnerInfo(InnerInfoPass walker) {
        if (!walker.isAccessibleExactly(this.getThisType())) {
            if (!this.fromSource() && this.getParent().fromSource()) {
                this.getParent().showError("no instance available");
            } else {
                this.showError("no instance available");
            }
        }
    }

    protected void cgValue(CodeBuilder cb) {
        cb.emitALOAD(0);
    }

    public SuperExpr(SourceLocation location) {
        super(location);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        SuperExpr ret = new SuperExpr(this.getSourceLocation());
        ret.preCopy(walker, this);
        return ret;
    }

    public String getDefaultDisplayName() {
        return "SuperExpr()";
    }
}

