/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import org.aspectj.compiler.base.ByteCodeCleanupPass;
import org.aspectj.compiler.base.CodeWriter;
import org.aspectj.compiler.base.JavaCompiler;
import org.aspectj.compiler.base.ast.AST;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.BlockStmt;
import org.aspectj.compiler.base.ast.BreakStmt;
import org.aspectj.compiler.base.ast.CodeDec;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.EmptyStmt;
import org.aspectj.compiler.base.ast.LabeledStmt;
import org.aspectj.compiler.base.ast.ReturnStmt;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Stmt;
import org.aspectj.compiler.base.ast.TypeDec;
import org.aspectj.compiler.base.ast.Walker;
import org.aspectj.compiler.base.bcg.CodeBuilder;

public class Stmts
extends ASTObject {
    protected int size;
    public Stmt[] children;

    public Stmt getSingleStmt() {
        if (this.size() == 0) {
            return new EmptyStmt(this.getSourceLocation());
        }
        if (this.size() == 1) {
            return this.get(0);
        }
        return new BlockStmt(this.getSourceLocation(), this);
    }

    public BlockStmt makeBlockStmt() {
        if (this.size() == 1 && this.get(0) instanceof BlockStmt) {
            return (BlockStmt)this.get(0);
        }
        return this.getAST().makeBlock(this);
    }

    public Stmts removeReturns() {
        RemoveReturnWalker retWalker = new RemoveReturnWalker(this.getCompiler(), "AJC$BLOCK" + this.size());
        return retWalker.removeReturns(this);
    }

    public void unparse(CodeWriter writer) {
        int N = this.size;
        int lastBeginLine = -1;
        int i = 0;
        while (i < N) {
            Stmt stmt = this.children[i];
            writer.write(this.children[i]);
            writer.newLine();
            ++i;
        }
    }

    public void walkCleanup(ByteCodeCleanupPass walker) {
        int N = this.size;
        int j = 0;
        int i = 0;
        while (i < N) {
            if (!walker.isLive()) break;
            ASTObject s = walker.process(this.get(i));
            if (s != null && !(s instanceof EmptyStmt)) {
                this.set(j++, (Stmt)s);
            }
            ++i;
        }
        int i2 = j;
        while (i2 < N) {
            this.children[i2] = null;
            ++i2;
        }
        this.size = j;
    }

    final void cgStmts(CodeBuilder cb) {
        int i = 0;
        int len = this.size;
        while (i < len) {
            this.children[i].cgTop(cb);
            ++i;
        }
    }

    public Stmts(SourceLocation location, Stmt[] _children) {
        super(location);
        int i = 0;
        while (i < _children.length) {
            if (_children[i] != null) {
                _children[i].setParent(this);
            }
            ++i;
        }
        this.children = _children;
        this.size = _children.length;
    }

    public Stmts(SourceLocation location) {
        this(location, new Stmt[0]);
    }

    public Stmts(SourceLocation location, Stmt child1) {
        this(location, new Stmt[]{child1});
    }

    public Stmts(SourceLocation location, Stmt child1, Stmt child2) {
        this(location, new Stmt[]{child1, child2});
    }

    public Stmts(SourceLocation location, Stmt child1, Stmt child2, Stmt child3) {
        this(location, new Stmt[]{child1, child2, child3});
    }

    public ASTObject copyWalk(CopyWalker walker) {
        int N = this.size;
        Stmt[] copiedChildren = new Stmt[N];
        int newIndex = 0;
        int oldIndex = 0;
        while (oldIndex < N) {
            Stmt newChild = (Stmt)walker.process(this.children[oldIndex]);
            if (newChild != null) {
                copiedChildren[newIndex++] = newChild;
            }
            ++oldIndex;
        }
        Stmts ret = new Stmts(this.getSourceLocation(), copiedChildren);
        ret.size = newIndex;
        ret.setSource(this);
        return ret;
    }

    public ASTObject getChildAt(int childIndex) {
        return this.get(childIndex);
    }

    public void setChildAt(int childIndex, ASTObject child) {
        this.set(childIndex, (Stmt)child);
    }

    public String getChildNameAt(int childIndex) {
        return "stmt" + childIndex;
    }

    public int getChildCount() {
        return this.size;
    }

    public int size() {
        return this.size;
    }

    public Stmt get(int index) {
        if (index >= this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.children[index];
    }

    public void set(int index, Stmt child) {
        if (index >= this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.children[index] = child;
        child.setParent(this);
    }

    public void resize(int newSize) {
        if (newSize > this.children.length) {
            Stmt[] newChildren = new Stmt[this.children.length * 2 + 1];
            System.arraycopy(this.children, 0, newChildren, 0, this.children.length);
            this.children = newChildren;
        }
        this.size = newSize;
    }

    public void addAll(Stmts collection) {
        this.addAll(this.size, collection);
    }

    public void addAll(int index, Stmts collection) {
        int i = 0;
        while (i < collection.size()) {
            this.add(index + i, collection.get(i));
            ++i;
        }
    }

    public void add(Stmt child) {
        this.add(this.size, child);
    }

    public void add(int index, Stmt child) {
        if (child == null) {
            return;
        }
        if (index < 0 || index > this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.resize(this.size + 1);
        int moveIndex = this.size - 1;
        while (moveIndex > index) {
            this.children[moveIndex] = this.children[moveIndex - 1];
            --moveIndex;
        }
        this.children[index] = child;
        child.setParent(this);
    }

    public void remove(int index) {
        if (index < 0 || index > this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        --this.size;
        int moveIndex = index;
        while (moveIndex < this.size) {
            this.children[moveIndex] = this.children[moveIndex + 1];
            ++moveIndex;
        }
    }

    public String getDefaultDisplayName() {
        return "Stmts()";
    }

    static class RemoveReturnWalker
    extends Walker {
        public boolean hasReturn = false;
        public String label;

        public RemoveReturnWalker(JavaCompiler compiler, String label) {
            super(compiler);
            this.label = label;
        }

        public Stmts removeReturns(Stmts stmts) {
            Stmts ret = (Stmts)this.process(stmts);
            if (this.hasReturn) {
                AST ast = this.getAST();
                return ast.makeStmts(new LabeledStmt(ast.getSourceLocation(), this.label, ast.makeBlock(stmts)));
            }
            return ret;
        }

        public ASTObject process(ASTObject node) {
            if (node instanceof TypeDec) {
                return node;
            }
            if (node instanceof CodeDec) {
                return node;
            }
            if (node instanceof ReturnStmt) {
                this.hasReturn = true;
                return new BreakStmt(this.getAST().getSourceLocation(), this.label);
            }
            return super.process(node);
        }
    }
}

