/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import java.io.File;
import org.aspectj.compiler.base.JavaCompiler;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.Comment;
import org.aspectj.compiler.base.ast.CompilationUnit;
import org.aspectj.compiler.base.ast.FormalComment;
import org.aspectj.compiler.base.ast.IntLiteralExpr;

public abstract class SourceLocation {
    public abstract JavaCompiler getCompiler();

    public int getStartPosition() {
        return -1;
    }

    public int getEndPosition() {
        return -1;
    }

    public int getBeginLine() {
        return -1;
    }

    public int getEndLine() {
        return -1;
    }

    public int getBeginColumn() {
        return -1;
    }

    public int getEndColumn() {
        return -1;
    }

    public Comment getComment() {
        return null;
    }

    public void addComment(Comment _comment) {
        throw new RuntimeException("can't add a comment to this source location");
    }

    public void clearComment() {
    }

    public void setFormalComment(String comment) {
        this.addComment(new FormalComment(comment));
    }

    public String getFormalComment() {
        return "";
    }

    public CompilationUnit getCompilationUnit() {
        return this.getCompiler().getWorld().missingCompilationUnit;
    }

    public File getSourceFile() {
        return this.getCompilationUnit().getSourceFile();
    }

    public String getSourceFileName() {
        return this.getCompilationUnit().getSourceCanonicalPath();
    }

    public String getSourceDirectoryName() {
        return this.getCompilationUnit().getSourceDirectory();
    }

    public void showError(String message) {
        this.getCompiler().showError(new IntLiteralExpr(this, 1), message);
    }

    public boolean hasSource() {
        return false;
    }

    public boolean fromSource() {
        return this.hasSource() && this.getCompilationUnit().getDecs() != null;
    }

    public boolean isSynthetic() {
        return true;
    }

    public ASTObject getSourceObject() {
        return null;
    }
}

