/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import org.aspectj.compiler.base.JavaCompiler;
import org.aspectj.compiler.base.ast.ByteType;
import org.aspectj.compiler.base.ast.IntLiteralExpr;
import org.aspectj.compiler.base.ast.IntishType;
import org.aspectj.compiler.base.ast.LiteralExpr;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.bcg.CodeBuilder;

public final class ShortType
extends IntishType {
    protected boolean isAssignableFromOtherType(Type other) {
        return other instanceof ByteType;
    }

    public String getName() {
        return "short";
    }

    public int getTypeIndex() {
        return 9;
    }

    public Type getRefType() {
        return this.getTypeManager().getType("java.lang", "Short");
    }

    public ShortType(JavaCompiler compiler) {
        super(compiler);
    }

    public String getDescriptor() {
        return "S";
    }

    LiteralExpr foldCast(LiteralExpr rand) {
        return new IntLiteralExpr(this.getAST().getSourceLocation(), (Type)this, (short)rand.getIntValue());
    }

    void emitCastFromInt(CodeBuilder cb) {
        cb.emitI2S();
    }

    void emitCastFromFloat(CodeBuilder cb) {
        cb.emitF2I();
        cb.emitI2S();
    }

    void emitCastFromLong(CodeBuilder cb) {
        cb.emitL2I();
        cb.emitI2S();
    }

    void emitCastFromDouble(CodeBuilder cb) {
        cb.emitD2I();
        cb.emitI2S();
    }

    void emitAload(CodeBuilder cb) {
        cb.emitSALOAD();
    }

    void emitAstore(CodeBuilder cb) {
        cb.emitSASTORE();
    }
}

