/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import org.aspectj.compiler.base.CompilerObject;
import org.aspectj.compiler.base.JavaCompiler;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.Dec;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.Exprs;
import org.aspectj.compiler.base.ast.InterfaceDec;
import org.aspectj.compiler.base.ast.Modifiers;
import org.aspectj.compiler.base.ast.Type;

public abstract class SemanticObject
extends CompilerObject {
    protected Dec dec;

    public SemanticObject(JavaCompiler compiler) {
        super(compiler);
    }

    public SemanticObject(Dec dec) {
        super(dec.getCompiler());
        this.dec = dec;
    }

    public String getName() {
        return this.dec.getName();
    }

    public String getId() {
        return this.dec.getId();
    }

    public String getBytecodeId() {
        return this.dec.getBytecodeId();
    }

    public Type getDeclaringType() {
        return this.dec.getDeclaringType();
    }

    public Dec getCorrespondingDec() {
        return this.dec;
    }

    public String getKind() {
        return this.dec.getKind();
    }

    public String toShortString() {
        return this.dec.toShortString();
    }

    public String getDescriptor() {
        return this.dec.getDescriptor();
    }

    public int getStackDelta() {
        return this.dec.getStackDelta();
    }

    public Modifiers getModifiers() {
        return this.dec.getModifiers();
    }

    public boolean isAbstract() {
        return this.dec.isAbstract();
    }

    public boolean isStatic() {
        return this.dec.isStatic();
    }

    public boolean isInherited(Type inType) {
        return this.dec.isInherited(inType);
    }

    public boolean conflictsWith(SemanticObject other) {
        return this.dec.conflictsWith(other.dec);
    }

    public boolean checkOverride(Type inType, SemanticObject other) {
        return this.dec.checkOverride(inType, other.dec);
    }

    public boolean dominates(SemanticObject other) {
        return this.dec.dominates(other.dec);
    }

    public boolean isMoreSpecificThan(SemanticObject other) {
        return this.dec.isMoreSpecificThan(other.dec);
    }

    public boolean isApplicable(Exprs params) {
        return this.dec.isApplicable(params);
    }

    public boolean isAlmostApplicable(Exprs params) {
        return this.dec.isAlmostApplicable(params);
    }

    public boolean isAccessible(ASTObject fromWhere) {
        return this.isAccessible(fromWhere, false);
    }

    public boolean isAccessible(ASTObject fromWhere, boolean inBytecode) {
        if (this.dec == null) {
            System.out.println("no dec: " + this);
            return false;
        }
        return this.dec.isAccessible(fromWhere, inBytecode);
    }

    public void showConflictError(SemanticObject other, String message) {
        this.getCorrespondingDec().showError(this.toShortString() + " conflicts with " + other.toShortString() + ": " + message);
    }

    public Expr updateTargetExpr(Expr expr) {
        if (this.isStatic() && InterfaceDec.isHelperClass(this.getDeclaringType().getTypeDec())) {
            return expr.getAST().makeTypeExpr(this.getDeclaringType());
        }
        return expr;
    }
}

