/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import org.aspectj.compiler.base.JavaCompiler;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CompilationUnit;
import org.aspectj.compiler.base.ast.MethodDec;
import org.aspectj.compiler.base.ast.TypeDec;
import org.aspectj.compiler.base.ast.VarDec;
import org.aspectj.compiler.base.ast.Walker;
import org.aspectj.compiler.base.cst.BlockScope;
import org.aspectj.compiler.base.cst.CUScope;
import org.aspectj.compiler.base.cst.Scope;

public class ScopeWalker
extends Walker {
    public Scope scope;
    private boolean walkBodies = true;

    public static void bindNames(ASTObject node, Scope topScope) {
        new ScopeWalker(node.getCompiler(), topScope).process(node);
    }

    public ScopeWalker(JavaCompiler compiler) {
        super(compiler);
    }

    public ScopeWalker(JavaCompiler compiler, Scope initialScope) {
        this(compiler);
        this.scope = initialScope;
    }

    public void enterCU(CompilationUnit cu) {
        this.scope = new CUScope(this.getCompiler(), null, cu);
    }

    public Scope getScope() {
        return this.scope;
    }

    public void pushBlockScope() {
        this.pushScope(new BlockScope(this.getCompiler(), null));
    }

    public void pushScope(Scope newScope) {
        if (newScope.getStackParent() != null) {
            throw new IllegalArgumentException("can't push a scope that already has a parent");
        }
        newScope.setStackParent(this.scope);
        this.scope = newScope;
    }

    public void popScope() {
        this.scope = this.scope.getStackParent();
    }

    public void pushBlock() {
        if (this.scope instanceof BlockScope) {
            ((BlockScope)this.scope).pushBlock();
        }
    }

    public void popBlock() {
        if (this.scope instanceof BlockScope) {
            ((BlockScope)this.scope).popBlock();
        }
    }

    public void addVarDec(VarDec varDec) {
        if (this.scope instanceof BlockScope) {
            ((BlockScope)this.scope).addVarDec(varDec);
        }
    }

    public void addTypeDec(TypeDec typeDec) {
        if (typeDec.getId().equals("ANONYMOUS")) {
            return;
        }
        if (this.scope instanceof BlockScope) {
            ((BlockScope)this.scope).addTypeDec(typeDec);
        }
    }

    public void addMethodDec(MethodDec methodDec) {
    }

    public ASTObject process(ASTObject object) {
        object.preScope(this);
        object.walkScope(this);
        ASTObject ret = object.postScope(this);
        return ret;
    }

    public boolean walkBodies() {
        return this.walkBodies;
    }

    public void setWalkBodies(boolean b) {
        this.walkBodies = b;
    }

    public boolean walkSignatures() {
        return true;
    }

    public boolean useJavaScopes() {
        return false;
    }
}

