/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import org.aspectj.compiler.base.ASTFixerPass;
import org.aspectj.compiler.base.FlowCheckerPass;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CodeBody;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.VarDec;

public class ReferenceExpr
extends Expr {
    protected Expr value;
    protected VarDec tmpDec;

    public Type discoverType() {
        return this.value.getType();
    }

    public ReferenceExpr(SourceLocation source, Expr value) {
        this(source, value, new VarDec(source, value.getType().makeTypeD(), "tmp", null));
    }

    public Expr makeReference() {
        return this.getAST().makeVar(this.tmpDec);
    }

    public VarDec makeVarDec() {
        this.tmpDec.getModifiers().setFinal(true);
        this.tmpDec.setInitializer(this.value);
        return this.tmpDec;
    }

    public void walkFlow(FlowCheckerPass w) {
        throw new RuntimeException("Unhandled reference expr");
    }

    public ASTObject postFixAST(ASTFixerPass fixer) {
        CodeBody body = this.getEnclosingCodeDec().getBody();
        body.addTemporary(this.tmpDec);
        return this.getAST().makeParen(this.getAST().makeSet(this.tmpDec, this.value));
    }

    public Expr getValue() {
        return this.value;
    }

    public void setValue(Expr _value) {
        if (_value != null) {
            _value.setParent(this);
        }
        this.value = _value;
    }

    public VarDec getTmpDec() {
        return this.tmpDec;
    }

    public void setTmpDec(VarDec _tmpDec) {
        if (_tmpDec != null) {
            _tmpDec.setParent(this);
        }
        this.tmpDec = _tmpDec;
    }

    public ReferenceExpr(SourceLocation location, Expr _value, VarDec _tmpDec) {
        super(location);
        this.setValue(_value);
        this.setTmpDec(_tmpDec);
    }

    protected ReferenceExpr(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        ReferenceExpr ret = new ReferenceExpr(this.getSourceLocation());
        ret.preCopy(walker, this);
        if (this.value != null) {
            ret.setValue((Expr)walker.process(this.value));
        }
        if (this.tmpDec != null) {
            ret.setTmpDec((VarDec)walker.process(this.tmpDec));
        }
        return ret;
    }

    public ASTObject getChildAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return this.value;
            }
            case 1: {
                return this.tmpDec;
            }
        }
        return super.getChildAt(childIndex);
    }

    public String getChildNameAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return "value";
            }
            case 1: {
                return "tmpDec";
            }
        }
        return super.getChildNameAt(childIndex);
    }

    public void setChildAt(int childIndex, ASTObject child) {
        switch (childIndex) {
            case 0: {
                this.setValue((Expr)child);
                return;
            }
            case 1: {
                this.setTmpDec((VarDec)child);
                return;
            }
        }
        super.setChildAt(childIndex, child);
    }

    public int getChildCount() {
        return 2;
    }

    public String getDefaultDisplayName() {
        return "ReferenceExpr()";
    }
}

