/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import org.aspectj.compiler.base.CodeWriter;
import org.aspectj.compiler.base.MemberClassMunger;
import org.aspectj.compiler.base.ast.AST;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CodeDec;
import org.aspectj.compiler.base.ast.ConstructorDec;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.NameType;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.SuperExpr;
import org.aspectj.compiler.base.ast.ThisExpr;
import org.aspectj.compiler.base.ast.TypeD;
import org.aspectj.compiler.base.ast.VarExpr;
import org.aspectj.compiler.base.bcg.CodeBuilder;

public class QualifiedSuperExpr
extends SuperExpr {
    protected TypeD typeD;

    public NameType getThisType() {
        return (NameType)this.typeD.getType();
    }

    public void unparse(CodeWriter writer) {
        writer.write(this.typeD.getType().getId());
        writer.write(".super");
    }

    public ASTObject walkMemberMunger(MemberClassMunger w) {
        NameType targetType;
        AST ast = this.getAST();
        NameType currentType = w.currentType();
        if (currentType == (targetType = (NameType)this.getTypeD().getType())) {
            return ast.forceCast(targetType.getSuperClassType(), ast.makeThis(currentType));
        }
        CodeDec dec = this.getEnclosingCodeDec();
        if (dec instanceof ConstructorDec) {
            ConstructorDec cdec = (ConstructorDec)dec;
            VarExpr seed = ast.makeVar(cdec.getEnclosingInstanceFormal());
            return ast.forceCast(targetType.getSuperClassType(), w.buildExprFromEnclosing(seed, targetType));
        }
        ThisExpr seed = ast.makeThis(currentType);
        return ast.forceCast(targetType.getSuperClassType(), w.buildExprFromThis(seed, targetType));
    }

    protected void cgValue(CodeBuilder cb) {
        throw new RuntimeException("Invalid expression " + this);
    }

    public TypeD getTypeD() {
        return this.typeD;
    }

    public void setTypeD(TypeD _typeD) {
        if (_typeD != null) {
            _typeD.setParent(this);
        }
        this.typeD = _typeD;
    }

    public QualifiedSuperExpr(SourceLocation location, TypeD _typeD) {
        super(location);
        this.setTypeD(_typeD);
    }

    protected QualifiedSuperExpr(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        QualifiedSuperExpr ret = new QualifiedSuperExpr(this.getSourceLocation());
        ret.preCopy(walker, this);
        if (this.typeD != null) {
            ret.setTypeD((TypeD)walker.process(this.typeD));
        }
        return ret;
    }

    public ASTObject getChildAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return this.typeD;
            }
        }
        return super.getChildAt(childIndex);
    }

    public String getChildNameAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return "typeD";
            }
        }
        return super.getChildNameAt(childIndex);
    }

    public void setChildAt(int childIndex, ASTObject child) {
        switch (childIndex) {
            case 0: {
                this.setTypeD((TypeD)child);
                return;
            }
        }
        super.setChildAt(childIndex, child);
    }

    public int getChildCount() {
        return 1;
    }

    public String getDefaultDisplayName() {
        return "QualifiedSuperExpr()";
    }
}

