/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import org.aspectj.compiler.base.CodeWriter;
import org.aspectj.compiler.base.InnerAccessFixer;
import org.aspectj.compiler.base.ast.AST;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.AssignableExpr;
import org.aspectj.compiler.base.ast.BangExpr;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.Exprs;
import org.aspectj.compiler.base.ast.FieldAccessExpr;
import org.aspectj.compiler.base.ast.FieldDec;
import org.aspectj.compiler.base.ast.Formals;
import org.aspectj.compiler.base.ast.IntishType;
import org.aspectj.compiler.base.ast.MethodDec;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.bcg.CodeBuilder;

public class PrefixExpr
extends BangExpr {
    protected String op;

    public ASTObject fixAccessToFieldSet(FieldAccessExpr expr) {
        return this.makeInPlaceSet(expr, this.op.substring(1), this.getAST().makeLiteral(1));
    }

    public void unparse(CodeWriter writer) {
        writer.write(this.op);
        writer.write(this.lhs);
    }

    public void checkSpec() {
        Type ty = this.getType();
        if (ty.isVoid() || !ty.isNumeric() && !ty.isAnyType()) {
            this.showOperatorTypeError(this.op, ty);
        }
    }

    public ASTObject postInnerAccess(InnerAccessFixer w) {
        if (!(this.getLhs() instanceof FieldAccessExpr)) {
            return this;
        }
        FieldAccessExpr lhs = (FieldAccessExpr)this.getLhs();
        Expr q = lhs.getExpr();
        FieldDec dec = lhs.getFieldDec();
        if (w.isAccessible(dec, q)) {
            return this;
        }
        AST ast = this.getAST();
        Type qType = q.getType();
        MethodDec newMethodDec = w.getAccessMethod(qType, dec, this.getOp() + "x", this);
        Exprs newArgs = ast.makeExprs();
        Expr newExpr = w.makeOutsidePrimary(dec.isStatic(), newArgs, q);
        return ast.makeCall(newMethodDec, newExpr, newArgs);
    }

    public MethodDec buildAccessMethod(InnerAccessFixer w) {
        AST ast = this.getAST();
        FieldAccessExpr lhs = (FieldAccessExpr)this.getLhs();
        Expr q = lhs.getExpr();
        Type qType = q.getType();
        FieldDec dec = lhs.getFieldDec();
        Type fieldType = dec.getType();
        Formals newFormals = ast.makeFormals();
        Expr newExpr = w.makeInsidePrimary(dec.isStatic(), newFormals, qType);
        return w.makeAccessMethod(fieldType, newFormals, ast.makePrefix(newExpr, dec, this.getOp()));
    }

    protected void cgValue(CodeBuilder cb) {
        this.cgValueEffect(cb, true);
    }

    protected void cgEffect(CodeBuilder cb) {
        this.cgValueEffect(cb, false);
    }

    private void cgValueEffect(CodeBuilder cb, boolean needsValue) {
        AssignableExpr lhs;
        Type ty = this.getType();
        if (ty.hasFastIncOp(lhs = this.getLhs(), 1)) {
            ty.emitFastIncOp(cb, lhs, this.op.equals("++") ? 1 : -1);
            if (needsValue) {
                lhs.cgValue(cb);
            }
        } else {
            lhs.cgLvalue(cb);
            lhs.cgDupLvalue(cb);
            lhs.cgLtoRvalue(cb);
            ty.emitOne(cb);
            if (this.op.equals("++")) {
                ty.emitAdd(cb);
            } else {
                ty.emitNumericOp(cb, "-");
            }
            if (ty instanceof IntishType) {
                ((IntishType)ty).emitCastFromInt(cb);
            }
            if (needsValue) {
                lhs.cgDupRvalue(cb);
            }
            lhs.cgAssignment(cb);
        }
    }

    public String getOp() {
        return this.op;
    }

    public void setOp(String _op) {
        this.op = _op;
    }

    public PrefixExpr(SourceLocation location, AssignableExpr _lhs, String _op) {
        super(location, _lhs);
        this.setOp(_op);
    }

    protected PrefixExpr(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        PrefixExpr ret = new PrefixExpr(this.getSourceLocation());
        ret.preCopy(walker, this);
        if (this.lhs != null) {
            ret.setLhs((AssignableExpr)walker.process(this.lhs));
        }
        ret.op = this.op;
        return ret;
    }

    public String getDefaultDisplayName() {
        return "PrefixExpr(op: " + this.op + ")";
    }
}

