/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.BinopExpr;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.LiteralExpr;
import org.aspectj.compiler.base.ast.NumericType;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.bcg.CodeBuilder;

public class NumericOpExpr
extends BinopExpr {
    protected Type discoverType() {
        Expr rand1 = this.getRand1();
        Expr rand2 = this.getRand2();
        Type ty1 = rand1.getType();
        Type ty2 = rand2.getType();
        Type anyType = this.getTypeManager().anyType;
        if (ty1.isMissing() || ty2.isMissing()) {
            return anyType;
        }
        if (ty1 instanceof NumericType && ty2 instanceof NumericType) {
            return this.getTypeManager().binaryNumericPromotion(ty1, ty2);
        }
        this.showOperatorTypeError(this.op, ty1, ty2);
        return anyType;
    }

    protected Type getLiftType() {
        return this.getType();
    }

    protected LiteralExpr halfFold(Type type, LiteralExpr lit1, LiteralExpr lit2) {
        return type.foldNumericOp(this.getOp(), lit1, lit2);
    }

    protected void cgValue(CodeBuilder cb) {
        Type liftType = this.getLiftType();
        this.getRand1().cgValue(cb, liftType);
        this.getRand2().cgValue(cb, liftType);
        liftType.emitNumericOp(cb, this.getOp());
    }

    protected void cgOp(CodeBuilder cb, Type ty) {
        ty.emitNumericOp(cb, this.getOp());
    }

    public NumericOpExpr(SourceLocation location, Expr _rand1, String _op, Expr _rand2) {
        super(location, _rand1, _op, _rand2);
    }

    protected NumericOpExpr(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        NumericOpExpr ret = new NumericOpExpr(this.getSourceLocation());
        ret.preCopy(walker, this);
        if (this.rand1 != null) {
            ret.setRand1((Expr)walker.process(this.rand1));
        }
        ret.op = this.op;
        if (this.rand2 != null) {
            ret.setRand2((Expr)walker.process(this.rand2));
        }
        return ret;
    }

    public String getDefaultDisplayName() {
        return "NumericOpExpr(op: " + this.op + ")";
    }
}

