/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import org.aspectj.compiler.base.JavaCompiler;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.RefType;
import org.aspectj.compiler.base.ast.Type;

public class NullType
extends RefType {
    public NullType(JavaCompiler compiler) {
        super(compiler);
    }

    public boolean isSubtypeOf(Type other) {
        return other instanceof RefType;
    }

    public boolean isAssignableFrom(Type other) {
        return other instanceof NullType;
    }

    public boolean isMethodConvertableTo(Type other) {
        return other.isReferenceType();
    }

    public boolean isCoercableTo(Type other) {
        return true;
    }

    protected void showNotFoundError(String id, ASTObject fromWhere, String kind) {
        this.getCompiler().showError(fromWhere, "no " + kind + "s on null");
    }

    public boolean isAnyType() {
        return false;
    }

    public String getString() {
        return "null";
    }

    public String toShortString() {
        return "null";
    }

    public String getDescriptor() {
        throw new RuntimeException("No bytecode type descriptor for Null type");
    }
}

