/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.aspectj.compiler.base.JavaCompiler;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.FieldDec;
import org.aspectj.compiler.base.ast.SOLink;
import org.aspectj.compiler.base.ast.SemanticObject;
import org.aspectj.compiler.base.ast.ThisExpr;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.VarDec;
import org.aspectj.compiler.base.ast.VarExpr;
import org.aspectj.compiler.base.ast.Walker;

public class MovingWalker
extends Walker {
    protected Map remapNodes = new HashMap();
    protected Stack lexicalTypes = new Stack();
    public Type toType;
    public boolean isStatic;

    public MovingWalker(JavaCompiler compiler) {
        super(compiler);
    }

    public MovingWalker(JavaCompiler compiler, Type fromType, Type toType) {
        super(compiler);
        this.toType = toType;
        this.pushLexicalType(fromType);
    }

    public void addMappings(Map map) {
        this.remapNodes.putAll(map);
    }

    public boolean hasToType() {
        return this.toType != null;
    }

    public Type getToType() {
        return this.toType;
    }

    public void addMapping(Object oldObject, Object newObject) {
        this.remapNodes.put(oldObject, newObject);
    }

    public boolean inTopLexicalType() {
        return this.lexicalTypes.size() == 1;
    }

    public boolean hasLexicalType() {
        return this.lexicalTypes.size() > 0;
    }

    public Type getLexicalType() {
        return (Type)this.lexicalTypes.peek();
    }

    public Type getTopLexicalType() {
        return (Type)this.lexicalTypes.get(0);
    }

    public void pushLexicalType(Type t) {
        this.lexicalTypes.push(t);
    }

    public void popLexicalType() {
        this.lexicalTypes.pop();
    }

    public Expr moveThisExpr(ThisExpr thisExpr, Type thisType) {
        Expr ret;
        if (this.hasLexicalType() && thisType == this.getTopLexicalType() && (ret = this.makeThisExpr()) != null) {
            return ret;
        }
        return thisExpr;
    }

    public Expr moveVarExpr(VarExpr var) {
        VarDec ret = (VarDec)this.remapNodes.get(var.getVarDec());
        if (ret != null) {
            if (ret instanceof FieldDec) {
                return this.getAST().makeGet((FieldDec)ret);
            }
            var.setVarDec(ret);
            var.setType(null);
            var.getType();
            return var;
        }
        return this.handleFreeVar(var);
    }

    protected Expr handleFreeVar(VarExpr var) {
        return var;
    }

    protected Expr makeThisExpr() {
        return null;
    }

    public Type moveType(Type type) {
        SemanticObject ret = (SemanticObject)this.remapNodes.get(type);
        if (ret != null && ret instanceof Type) {
            return (Type)ret;
        }
        return type;
    }

    public void moveLink(SOLink link) {
        SemanticObject ret = (SemanticObject)this.remapNodes.get(link.getTarget());
        if (ret != null) {
            link.setTarget(ret);
        }
    }

    public Expr moveLinkExpr(SOLink link) {
        SemanticObject ret = (SemanticObject)this.remapNodes.get(link.getTarget());
        if (ret != null) {
            link.setTarget(ret);
        }
        return (Expr)((Object)link);
    }

    public ASTObject process(ASTObject object) {
        object.preMove(this);
        object.walk(this);
        return object.postMove(this);
    }
}

