/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import org.aspectj.compiler.base.JavaCompiler;
import org.aspectj.compiler.base.ast.AST;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.IntegralType;
import org.aspectj.compiler.base.ast.IntishType;
import org.aspectj.compiler.base.ast.LiteralExpr;
import org.aspectj.compiler.base.ast.NumericType;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.bcg.CodeBuilder;
import org.aspectj.compiler.base.bcg.Label;

public final class LongType
extends IntegralType {
    protected boolean isAssignableFromOtherType(Type other) {
        return other instanceof IntishType;
    }

    public String getName() {
        return "long";
    }

    public int getTypeIndex() {
        return 11;
    }

    public Type getRefType() {
        return this.getTypeManager().getType("java.lang", "Long");
    }

    public Expr getNullExpr() {
        return this.getAST().makeLiteral(0L);
    }

    public LongType(JavaCompiler compiler) {
        super(compiler);
    }

    public String getDescriptor() {
        return "J";
    }

    public int getSlotCount() {
        return 2;
    }

    private LiteralExpr makeLit(long l) {
        return this.getAST().makeLiteral(l);
    }

    private LiteralExpr makeBooleanLit(boolean b) {
        return this.getAST().makeLiteral(b);
    }

    LiteralExpr foldCast(LiteralExpr rand) {
        return this.makeLit(rand.getLongValue());
    }

    LiteralExpr foldPlusOp(LiteralExpr rand) {
        return this.makeLit(rand.getLongValue());
    }

    LiteralExpr foldMinusOp(LiteralExpr rand) {
        return this.makeLit(-rand.getLongValue());
    }

    LiteralExpr foldBitNotOp(LiteralExpr rand) {
        return this.makeLit(rand.getLongValue() ^ 0xFFFFFFFFFFFFFFFFL);
    }

    LiteralExpr foldAddOp(LiteralExpr rand1, LiteralExpr rand2) {
        return this.makeLit(rand1.getLongValue() + rand2.getLongValue());
    }

    LiteralExpr foldNumericOp(String op, LiteralExpr lit1, LiteralExpr lit2) {
        AST ast = this.getAST();
        long a = lit1.getLongValue();
        long b = lit2.getLongValue();
        if (op == "-") {
            return ast.makeLiteral(a - b);
        }
        if (op == "%") {
            return ast.makeLiteral(a % b);
        }
        if (op == "/") {
            return ast.makeLiteral(a / b);
        }
        if (op == "*") {
            return ast.makeLiteral(a * b);
        }
        throw new RuntimeException("bad numeric op " + op);
    }

    LiteralExpr foldBitwiseOp(String op, LiteralExpr lit1, LiteralExpr lit2) {
        AST ast = this.getAST();
        long a = lit1.getLongValue();
        long b = lit2.getLongValue();
        if (op == "&") {
            return ast.makeLiteral(a & b);
        }
        if (op == "|") {
            return ast.makeLiteral(a | b);
        }
        if (op == "^") {
            return ast.makeLiteral(a ^ b);
        }
        throw new RuntimeException("bad bitwise op " + op);
    }

    LiteralExpr foldShiftOp(String op, LiteralExpr lit1, LiteralExpr lit2) {
        AST ast = this.getAST();
        long a = lit1.getLongValue();
        int b = lit2.getIntValue();
        if (op == "<<") {
            return ast.makeLiteral(a << b);
        }
        if (op == ">>") {
            return ast.makeLiteral(a >> b);
        }
        if (op == ">>>") {
            return ast.makeLiteral(a >>> b);
        }
        throw new RuntimeException("bad bitwise op " + op);
    }

    LiteralExpr foldEqualityTestOp(String op, LiteralExpr lit1, LiteralExpr lit2) {
        AST ast = this.getAST();
        long a = lit1.getLongValue();
        long b = lit2.getLongValue();
        if (op == "==") {
            return ast.makeLiteral(a == b);
        }
        if (op == "!=") {
            return ast.makeLiteral(a != b);
        }
        throw new RuntimeException("bad op " + op);
    }

    LiteralExpr foldNumericTestOp(String op, LiteralExpr lit1, LiteralExpr lit2) {
        AST ast = this.getAST();
        long a = lit1.getLongValue();
        long b = lit2.getLongValue();
        if (op == "<") {
            return ast.makeLiteral(a < b);
        }
        if (op == "<=") {
            return ast.makeLiteral(a <= b);
        }
        if (op == ">=") {
            return ast.makeLiteral(a >= b);
        }
        if (op == ">") {
            return ast.makeLiteral(a > b);
        }
        throw new RuntimeException("bad op " + op);
    }

    void emitAdd(CodeBuilder cb) {
        cb.emitLADD();
    }

    void emitNumericOp(CodeBuilder cb, String op) {
        if (op == "-") {
            cb.emitLSUB();
        } else if (op == "%") {
            cb.emitLREM();
        } else if (op == "/") {
            cb.emitLDIV();
        } else if (op == "*") {
            cb.emitLMUL();
        }
    }

    void emitBitwiseOp(CodeBuilder cb, String op) {
        if (op == "&") {
            cb.emitLAND();
        } else if (op == "|") {
            cb.emitLOR();
        } else if (op == "^") {
            cb.emitLXOR();
        }
    }

    void emitShiftOp(CodeBuilder cb, String op) {
        if (op == "<<") {
            cb.emitLSHL();
        } else if (op == ">>") {
            cb.emitLSHR();
        } else if (op == ">>>") {
            cb.emitLUSHR();
        }
    }

    void emitNeg(CodeBuilder cb) {
        cb.emitLNEG();
    }

    public void emitLoad(CodeBuilder cb, int loc) {
        cb.emitLLOAD(loc);
    }

    public void emitStore(CodeBuilder cb, int loc) {
        cb.emitLSTORE(loc);
    }

    public void emitReturn(CodeBuilder cb) {
        cb.emitLRETURN();
    }

    void emitCast(CodeBuilder cb, Type castTo) {
        ((NumericType)castTo).emitCastFromLong(cb);
    }

    void emitCastFromInt(CodeBuilder cb) {
        cb.emitI2L();
    }

    void emitCastFromFloat(CodeBuilder cb) {
        cb.emitF2L();
    }

    void emitCastFromLong(CodeBuilder cb) {
    }

    void emitCastFromDouble(CodeBuilder cb) {
        cb.emitD2L();
    }

    void emitPop(CodeBuilder cb) {
        cb.emitPOP2();
    }

    void emitDup(CodeBuilder cb) {
        cb.emitDUP2();
    }

    void emitDupX1(CodeBuilder cb) {
        cb.emitDUP2_X1();
    }

    void emitDupX2(CodeBuilder cb) {
        cb.emitDUP2_X2();
    }

    void emitZero(CodeBuilder cb) {
        cb.emitLongConstant(0L);
    }

    void emitOne(CodeBuilder cb) {
        cb.emitLongConstant(1L);
    }

    void emitMinusOne(CodeBuilder cb) {
        cb.emitLongConstant(-1L);
    }

    void emitEqualityCompare(CodeBuilder cb, String op, Label t, Label f) {
        cb.emitLCMP();
        if (op == "==") {
            cb.emitIFEQ(t, f);
        } else if (op == "!=") {
            cb.emitIFNE(t, f);
        }
    }

    void emitNumericCompare(CodeBuilder cb, String op, Label t, Label f) {
        cb.emitLCMP();
        if (op == "<") {
            cb.emitIFLT(t, f);
        } else if (op == "<=") {
            cb.emitIFLE(t, f);
        } else if (op == ">=") {
            cb.emitIFGE(t, f);
        } else if (op == ">") {
            cb.emitIFGT(t, f);
        }
    }

    void emitAload(CodeBuilder cb) {
        cb.emitLALOAD();
    }

    void emitAstore(CodeBuilder cb) {
        cb.emitLASTORE();
    }
}

