/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.NumericLiteralExpr;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.bcg.CodeBuilder;
import org.aspectj.compiler.base.bcg.FieldBuilder;

public class LongLiteralExpr
extends NumericLiteralExpr {
    protected long longValue;

    public int getIntValue() {
        return (int)this.longValue;
    }

    public float getFloatValue() {
        return this.longValue;
    }

    public double getDoubleValue() {
        return this.longValue;
    }

    public String getStringValue() {
        return "" + this.longValue;
    }

    public LongLiteralExpr(SourceLocation location, long _longValue) {
        this(location, location.getCompiler().getTypeManager().longType, _longValue + "L", _longValue);
    }

    protected void cgValue(CodeBuilder cb) {
        cb.emitLongConstant(this.longValue);
    }

    public void addConstant(FieldBuilder fb) {
        fb.setConstantValue(this.longValue);
    }

    public boolean isConstantZero() {
        return this.longValue == 0L;
    }

    public long getLongValue() {
        return this.longValue;
    }

    public void setLongValue(long _longValue) {
        this.longValue = _longValue;
    }

    public LongLiteralExpr(SourceLocation location, Type _type, String _value, long _longValue) {
        super(location, _type, _value);
        this.setLongValue(_longValue);
    }

    protected LongLiteralExpr(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        LongLiteralExpr ret = new LongLiteralExpr(this.getSourceLocation());
        ret.preCopy(walker, this);
        ret.type = this.type;
        ret.value = this.value;
        ret.longValue = this.longValue;
        return ret;
    }

    public String getDefaultDisplayName() {
        return "LongLiteralExpr(type: " + this.type + ", " + "value: " + this.value + ", " + "longValue: " + this.longValue + ")";
    }
}

