/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import java.io.IOException;
import org.aspectj.compiler.base.CodeWriter;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.bcg.CodeBuilder;
import org.aspectj.compiler.base.bcg.FieldBuilder;

public abstract class LiteralExpr
extends Expr {
    protected Type type;
    protected String value;

    public abstract String getStringValue();

    public int getIntValue() {
        return 0;
    }

    public long getLongValue() {
        return 0L;
    }

    public float getFloatValue() {
        return 0.0f;
    }

    public double getDoubleValue() {
        return 0.0;
    }

    public boolean getBooleanValue() {
        return false;
    }

    public Type discoverType() {
        return this.type;
    }

    public Expr makeReference() {
        return this;
    }

    public boolean canBeCopied() {
        return true;
    }

    public boolean isUltimatelyLiteral() {
        return true;
    }

    public void unparse(CodeWriter writer) throws IOException {
        writer.write(this.value);
    }

    protected void cgValue(CodeBuilder cb, Type castTo) {
        castTo.foldCast(this).cgValue(cb);
    }

    protected void cgEffect(CodeBuilder cb) {
    }

    public abstract void addConstant(FieldBuilder var1);

    public Type getType() {
        return this.type;
    }

    public void setType(Type _type) {
        this.type = _type;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String _value) {
        this.value = _value;
    }

    public LiteralExpr(SourceLocation location, Type _type, String _value) {
        super(location);
        this.setType(_type);
        this.setValue(_value);
    }

    protected LiteralExpr(SourceLocation source) {
        super(source);
    }

    public String getDefaultDisplayName() {
        return "LiteralExpr(type: " + this.type + ", " + "value: " + this.value + ")";
    }
}

