/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import org.aspectj.compiler.base.AssignmentCheckerPass;
import org.aspectj.compiler.base.ByteCodeCleanupPass;
import org.aspectj.compiler.base.CodeWriter;
import org.aspectj.compiler.base.ast.AST;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.ClassDec;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Dec;
import org.aspectj.compiler.base.ast.Decs;
import org.aspectj.compiler.base.ast.FieldDec;
import org.aspectj.compiler.base.ast.InitializerDec;
import org.aspectj.compiler.base.ast.MethodDec;
import org.aspectj.compiler.base.ast.Modifiers;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.TypeDec;
import org.aspectj.compiler.base.ast.TypeDs;

public class InterfaceDec
extends TypeDec {
    static final String HELPER_CLASS_NAME = "AJC_HELPER_CLASS";

    public String getKind() {
        return "interface";
    }

    public Type getSuperClassType() {
        return this.getTypeManager().getObjectType();
    }

    public boolean isAnonymous() {
        return false;
    }

    public void checkSpec() {
        if (this.isLocal()) {
            this.showError("interface may not be defined in code body");
        }
        super.checkSpec();
    }

    protected void addFieldDec(FieldDec fieldDec) {
        if (fieldDec.fromSource()) {
            fieldDec.getModifiers().setPublic(true);
            fieldDec.getModifiers().setStatic(true);
            fieldDec.getModifiers().setFinal(true);
        }
        super.addFieldDec(fieldDec);
    }

    protected void addMethodDec(MethodDec methodDec) {
        if (methodDec.fromSource()) {
            methodDec.getModifiers().setPublic(true);
            methodDec.getModifiers().setAbstract(true);
        }
        super.addMethodDec(methodDec);
    }

    protected void addTypeDec(TypeDec typeDec) {
        if (typeDec.fromSource()) {
            typeDec.getModifiers().setPublic(true);
            typeDec.getModifiers().setStatic(true);
        }
        super.addTypeDec(typeDec);
    }

    protected void addInitializerDec(InitializerDec dec) {
        if (dec.fromSource()) {
            dec.showError("initializer not allowed in interface");
        }
        super.addInitializerDec(dec);
    }

    public void addToHelperClass(Dec dec) {
        ClassDec helper = this.getHelperClass();
        dec.setDeclaringType(helper.getType());
        helper.getBody().add(dec);
    }

    ClassDec getHelperClass() {
        Decs body = this.getBody();
        int i = 0;
        while (i < body.size()) {
            if (InterfaceDec.isHelperClass(body.get(i))) {
                return (ClassDec)body.get(i);
            }
            ++i;
        }
        ClassDec helper = this.makeHelperClass();
        body.add(helper);
        return helper;
    }

    public static boolean isHelperClass(Dec dec) {
        return dec != null && dec instanceof ClassDec && dec.getName().equals(HELPER_CLASS_NAME);
    }

    ClassDec makeHelperClass() {
        AST ast = this.getAST();
        ClassDec ret = ast.makeClass(ast.makeModifiers(9), HELPER_CLASS_NAME, this.getTypeManager().getObjectType().makeTypeD(), ast.makeTypeDs());
        ret.setEnclosingTypeDec(this);
        FieldDec ref1 = ast.makeField(ast.makeModifiers(26), this.getTypeManager().getObjectType(), "AJC_INNER_REF");
        FieldDec ref2 = ast.makeField(ast.makeModifiers(25), this.getTypeManager().getObjectType(), "AJC_OUTER_REF");
        ret.getBody().add(ref1);
        this.getBody().add(ref2);
        ref1.setInitializer(ast.makeGet(ref2.getField()));
        ref2.setInitializer(ast.makeGet(ref1.getField()));
        return ret;
    }

    public void unparse(CodeWriter writer) {
        writer.write(this.modifiers);
        writer.writeKeyword("interface");
        writer.requiredSpace();
        writer.write(this.id);
        this.writeNames(writer, "extends", this.superInterfaces);
        if (!writer.isOnlySignatures()) {
            writer.optionalSpace();
            writer.openBlock();
            writer.write(this.body);
            writer.closeBlock();
        }
    }

    public boolean isStatic() {
        return true;
    }

    public ASTObject postCleanup(ByteCodeCleanupPass walker) {
        int len = this.getBody().size();
        int i = 0;
        while (i < len) {
            Dec dec = this.getBody().get(i);
            Modifiers m = dec.getModifiers();
            if (dec instanceof FieldDec) {
                m.setPublic(true);
                m.setStatic(true);
                m.setFinal(true);
            } else if (dec instanceof MethodDec) {
                m.setPublic(true);
                m.setAbstract(true);
            }
            ++i;
        }
        return this;
    }

    public ASTObject postAssignmentCheck(AssignmentCheckerPass walker) {
        return this;
    }

    public InterfaceDec(SourceLocation location, Modifiers _modifiers, String _id, TypeDs _superInterfaces, Decs _body) {
        super(location, _modifiers, _id, _superInterfaces, _body);
    }

    protected InterfaceDec(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        InterfaceDec ret = new InterfaceDec(this.getSourceLocation());
        ret.preCopy(walker, this);
        if (this.modifiers != null) {
            ret.setModifiers((Modifiers)walker.process(this.modifiers));
        }
        ret.id = this.id;
        if (this.superInterfaces != null) {
            ret.setSuperInterfaces((TypeDs)walker.process(this.superInterfaces));
        }
        if (this.body != null) {
            ret.setBody((Decs)walker.process(this.body));
        }
        return ret;
    }

    public String getDefaultDisplayName() {
        return "InterfaceDec(id: " + this.id + ")";
    }
}

