/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.ByteType;
import org.aspectj.compiler.base.ast.CharType;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.IntType;
import org.aspectj.compiler.base.ast.NumericLiteralExpr;
import org.aspectj.compiler.base.ast.NumericType;
import org.aspectj.compiler.base.ast.ShortType;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.bcg.CodeBuilder;
import org.aspectj.compiler.base.bcg.FieldBuilder;

public class IntLiteralExpr
extends NumericLiteralExpr {
    protected int intValue;

    public long getLongValue() {
        return this.intValue;
    }

    public float getFloatValue() {
        return this.intValue;
    }

    public double getDoubleValue() {
        return this.intValue;
    }

    public String getStringValue() {
        if (this.getType() instanceof CharType) {
            return "" + (char)this.intValue;
        }
        return "" + this.intValue;
    }

    public IntLiteralExpr(SourceLocation source, int _intValue) {
        this(source, source.getCompiler().getTypeManager().intType, "" + _intValue, _intValue);
    }

    public IntLiteralExpr(SourceLocation source, Type type, int _intValue) {
        this(source, type, IntLiteralExpr.createUsefulString(type, _intValue), _intValue);
    }

    private static String createUsefulString(Type type, int i) {
        if (type instanceof IntType) {
            return "" + i;
        }
        return "((" + type.getString() + ")" + i + ")";
    }

    public boolean isAssignableTo(Type type) {
        if (type instanceof ByteType) {
            return -128 <= this.intValue && this.intValue <= 127;
        }
        if (type instanceof ShortType) {
            return Short.MIN_VALUE <= this.intValue && this.intValue <= Short.MAX_VALUE;
        }
        if (type instanceof CharType) {
            return 0 <= this.intValue && this.intValue <= 65535;
        }
        return type instanceof NumericType;
    }

    protected void cgValue(CodeBuilder cb) {
        cb.emitIntConstant(this.intValue);
    }

    public void addConstant(FieldBuilder fb) {
        fb.setConstantValue(this.intValue);
    }

    public boolean isConstantZero() {
        return this.intValue == 0;
    }

    public int getIntValue() {
        return this.intValue;
    }

    public void setIntValue(int _intValue) {
        this.intValue = _intValue;
    }

    public IntLiteralExpr(SourceLocation location, Type _type, String _value, int _intValue) {
        super(location, _type, _value);
        this.setIntValue(_intValue);
    }

    protected IntLiteralExpr(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        IntLiteralExpr ret = new IntLiteralExpr(this.getSourceLocation());
        ret.preCopy(walker, this);
        ret.type = this.type;
        ret.value = this.value;
        ret.intValue = this.intValue;
        return ret;
    }

    public String getDefaultDisplayName() {
        return "IntLiteralExpr(type: " + this.type + ", " + "value: " + this.value + ", " + "intValue: " + this.intValue + ")";
    }
}

