/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import java.util.Iterator;
import java.util.Set;
import org.aspectj.compiler.base.ByteCodeCleanupPass;
import org.aspectj.compiler.base.CodeWriter;
import org.aspectj.compiler.base.FlowCheckerPass;
import org.aspectj.compiler.base.ForwardReferenceChecker;
import org.aspectj.compiler.base.LocalClassPass;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CodeBody;
import org.aspectj.compiler.base.ast.CodeDec;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Dec;
import org.aspectj.compiler.base.ast.Decs;
import org.aspectj.compiler.base.ast.Formals;
import org.aspectj.compiler.base.ast.InterfaceDec;
import org.aspectj.compiler.base.ast.Modifiers;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.TypeD;
import org.aspectj.compiler.base.ast.TypeDec;
import org.aspectj.compiler.base.ast.TypeDs;
import org.aspectj.compiler.base.bcg.CodeBuilder;
import org.aspectj.compiler.crosscuts.MixinImplementationPass;

public class InitializerDec
extends CodeDec {
    public InitializerDec(SourceLocation location, Modifiers _modifiers, CodeBody _body) {
        this(location, _modifiers, new Formals(location), new TypeDs(location), _body);
    }

    public final void walkFlow(FlowCheckerPass w) {
        this.setupFlowWalker(w);
        w.setLive(true);
        w.process(this.getBody());
        if (!w.isLive()) {
            this.showError("initializer must be able to complete normally");
        }
    }

    public String getId() {
        return this.getModifiers().isStatic() ? "<clinit>" : "<init>";
    }

    public TypeD getResultTypeD() {
        return this.getTypeManager().voidType.makeTypeD();
    }

    public boolean conflictsWith(Dec otherDec) {
        return false;
    }

    public String toShortString() {
        return "{}";
    }

    public String getKind() {
        return "initializer";
    }

    public ASTObject postImplementMixin(MixinImplementationPass fixer) {
        TypeDec inTypeDec = this.getBytecodeTypeDec();
        if (!(inTypeDec instanceof InterfaceDec) || this.getBody() == null || this.isStatic()) {
            return this;
        }
        Set topmostImplementors = Type.filterTopTypes(Type.filterConcreteTypes(inTypeDec.getType().getSubTypes()));
        Iterator i = topmostImplementors.iterator();
        while (i.hasNext()) {
            Type implType = (Type)i.next();
            TypeDec implDec = implType.getTypeDec();
            CodeDec newDec = (CodeDec)fixer.copyToClass(this, implDec);
            Decs decs = implDec.getBody();
            int j = decs.size() - 1;
            while (j >= 0) {
                if (decs.get(j) instanceof InitializerDec) {
                    implDec.getBody().add(j, newDec);
                    break;
                }
                --j;
            }
            if (j >= 0) continue;
            implDec.getBody().add(newDec);
        }
        return null;
    }

    public void unparse(CodeWriter writer) {
        if (this.body == null || this.body.getStmts() == null || this.body.getStmts().size() == 0) {
            return;
        }
        this.writeModifiers(writer);
        writer.write(this.body);
        writer.newLine();
    }

    public void walkForwardReference(ForwardReferenceChecker w) {
        this.walk(w.createInitializerChecker(this.isStatic()));
    }

    public ASTObject postCleanup(ByteCodeCleanupPass walker) {
        if (this.getBody().isEmpty()) {
            return null;
        }
        return super.postCleanup(walker);
    }

    protected void cgCodeMember(CodeBuilder cb) {
        cb.setMaxFrame(this.getFrameSize());
        cb.enterBlock();
        this.getBody().cgTop(cb);
        cb.exitBlock();
    }

    public String getDescriptor() {
        return "()V";
    }

    public int getStackDelta() {
        return 0;
    }

    public void walkAnalysis(LocalClassPass.AnalysisWalker walker) {
        walker.enterCodeDec(this);
        if (this.isStatic()) {
            walker.inCode(true);
        } else {
            walker.inConstructor();
        }
        this.walk(walker);
        walker.leaveCodeDec();
    }

    public String toString() {
        return "InitializerDec(" + (this.isStatic() ? "static" : "non-static") + ")";
    }

    public InitializerDec(SourceLocation location, Modifiers _modifiers, Formals _formals, TypeDs __throws, CodeBody _body) {
        super(location, _modifiers, _formals, __throws, _body);
    }

    protected InitializerDec(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        InitializerDec ret = new InitializerDec(this.getSourceLocation());
        ret.preCopy(walker, this);
        if (this.modifiers != null) {
            ret.setModifiers((Modifiers)walker.process(this.modifiers));
        }
        if (this.formals != null) {
            ret.setFormals((Formals)walker.process(this.formals));
        }
        if (this._throws != null) {
            ret.setThrows((TypeDs)walker.process(this._throws));
        }
        if (this.body != null) {
            ret.setBody((CodeBody)walker.process(this.body));
        }
        return ret;
    }

    public String getDefaultDisplayName() {
        return "InitializerDec()";
    }
}

