/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import org.aspectj.compiler.base.CodeWriter;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Import;
import org.aspectj.compiler.base.ast.SourceLocation;

public class Imports
extends ASTObject {
    protected int size;
    public Import[] children;

    public void unparse(CodeWriter writer) {
        writer.writeChildren(this);
        if (this.size() > 0) {
            writer.newLine();
        }
    }

    public Imports(SourceLocation location, Import[] _children) {
        super(location);
        int i = 0;
        while (i < _children.length) {
            if (_children[i] != null) {
                _children[i].setParent(this);
            }
            ++i;
        }
        this.children = _children;
        this.size = _children.length;
    }

    public Imports(SourceLocation location) {
        this(location, new Import[0]);
    }

    public Imports(SourceLocation location, Import child1) {
        this(location, new Import[]{child1});
    }

    public Imports(SourceLocation location, Import child1, Import child2) {
        this(location, new Import[]{child1, child2});
    }

    public Imports(SourceLocation location, Import child1, Import child2, Import child3) {
        this(location, new Import[]{child1, child2, child3});
    }

    public ASTObject copyWalk(CopyWalker walker) {
        int N = this.size;
        Import[] copiedChildren = new Import[N];
        int newIndex = 0;
        int oldIndex = 0;
        while (oldIndex < N) {
            Import newChild = (Import)walker.process(this.children[oldIndex]);
            if (newChild != null) {
                copiedChildren[newIndex++] = newChild;
            }
            ++oldIndex;
        }
        Imports ret = new Imports(this.getSourceLocation(), copiedChildren);
        ret.size = newIndex;
        ret.setSource(this);
        return ret;
    }

    public ASTObject getChildAt(int childIndex) {
        return this.get(childIndex);
    }

    public void setChildAt(int childIndex, ASTObject child) {
        this.set(childIndex, (Import)child);
    }

    public String getChildNameAt(int childIndex) {
        return "import" + childIndex;
    }

    public int getChildCount() {
        return this.size;
    }

    public int size() {
        return this.size;
    }

    public Import get(int index) {
        if (index >= this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.children[index];
    }

    public void set(int index, Import child) {
        if (index >= this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.children[index] = child;
        child.setParent(this);
    }

    public void resize(int newSize) {
        if (newSize > this.children.length) {
            Import[] newChildren = new Import[this.children.length * 2 + 1];
            System.arraycopy(this.children, 0, newChildren, 0, this.children.length);
            this.children = newChildren;
        }
        this.size = newSize;
    }

    public void addAll(Imports collection) {
        this.addAll(this.size, collection);
    }

    public void addAll(int index, Imports collection) {
        int i = 0;
        while (i < collection.size()) {
            this.add(index + i, collection.get(i));
            ++i;
        }
    }

    public void add(Import child) {
        this.add(this.size, child);
    }

    public void add(int index, Import child) {
        if (child == null) {
            return;
        }
        if (index < 0 || index > this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.resize(this.size + 1);
        int moveIndex = this.size - 1;
        while (moveIndex > index) {
            this.children[moveIndex] = this.children[moveIndex - 1];
            --moveIndex;
        }
        this.children[index] = child;
        child.setParent(this);
    }

    public void remove(int index) {
        if (index < 0 || index > this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        --this.size;
        int moveIndex = index;
        while (moveIndex < this.size) {
            this.children[moveIndex] = this.children[moveIndex + 1];
            ++moveIndex;
        }
    }

    public String getDefaultDisplayName() {
        return "Imports()";
    }
}

