/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import org.aspectj.compiler.base.JavaCompiler;
import org.aspectj.compiler.base.ast.AST;
import org.aspectj.compiler.base.ast.DoubleType;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.FloatLiteralExpr;
import org.aspectj.compiler.base.ast.LiteralExpr;
import org.aspectj.compiler.base.ast.NumericType;
import org.aspectj.compiler.base.ast.RealType;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.bcg.CodeBuilder;
import org.aspectj.compiler.base.bcg.Label;

public final class FloatType
extends RealType {
    protected boolean isAssignableFromOtherType(Type other) {
        return other instanceof NumericType && !(other instanceof DoubleType);
    }

    public String getName() {
        return "float";
    }

    public int getTypeIndex() {
        return 6;
    }

    public Type getRefType() {
        return this.getTypeManager().getType("java.lang", "Float");
    }

    public Expr getNullExpr() {
        return new FloatLiteralExpr(this.getAST().getSourceLocation(), 0.0f);
    }

    public FloatType(JavaCompiler compiler) {
        super(compiler);
    }

    public String getDescriptor() {
        return "F";
    }

    private LiteralExpr makeLit(float f) {
        return new FloatLiteralExpr(this.getAST().getSourceLocation(), f);
    }

    private LiteralExpr makeBooleanLit(boolean b) {
        return this.getAST().makeLiteral(b);
    }

    LiteralExpr foldCast(LiteralExpr rand) {
        return this.makeLit(rand.getFloatValue());
    }

    strictfp LiteralExpr foldPlusOp(LiteralExpr rand) {
        return this.makeLit(rand.getFloatValue());
    }

    strictfp LiteralExpr foldMinusOp(LiteralExpr rand) {
        return this.makeLit(-rand.getFloatValue());
    }

    strictfp LiteralExpr foldAddOp(LiteralExpr rand1, LiteralExpr rand2) {
        return this.makeLit(rand1.getFloatValue() + rand2.getFloatValue());
    }

    strictfp LiteralExpr foldNumericOp(String op, LiteralExpr lit1, LiteralExpr lit2) {
        AST ast = this.getAST();
        float a = lit1.getFloatValue();
        float b = lit2.getFloatValue();
        if (op == "-") {
            return ast.makeLiteral(a - b);
        }
        if (op == "%") {
            return ast.makeLiteral(a % b);
        }
        if (op == "/") {
            return ast.makeLiteral(a / b);
        }
        if (op == "*") {
            return ast.makeLiteral(a * b);
        }
        throw new RuntimeException("bad numeric op " + op);
    }

    LiteralExpr foldEqualityTestOp(String op, LiteralExpr lit1, LiteralExpr lit2) {
        AST ast = this.getAST();
        float a = lit1.getFloatValue();
        float b = lit2.getFloatValue();
        if (op == "==") {
            return ast.makeLiteral(a == b);
        }
        if (op == "!=") {
            return ast.makeLiteral(a != b);
        }
        throw new RuntimeException("bad op " + op);
    }

    LiteralExpr foldNumericTestOp(String op, LiteralExpr lit1, LiteralExpr lit2) {
        AST ast = this.getAST();
        float a = lit1.getFloatValue();
        float b = lit2.getFloatValue();
        if (op == "<") {
            return ast.makeLiteral(a < b);
        }
        if (op == "<=") {
            return ast.makeLiteral(a <= b);
        }
        if (op == ">=") {
            return ast.makeLiteral(a >= b);
        }
        if (op == ">") {
            return ast.makeLiteral(a > b);
        }
        throw new RuntimeException("bad op " + op);
    }

    void emitAdd(CodeBuilder cb) {
        cb.emitFADD();
    }

    void emitNumericOp(CodeBuilder cb, String op) {
        if (op == "-") {
            cb.emitFSUB();
        } else if (op == "%") {
            cb.emitFREM();
        } else if (op == "/") {
            cb.emitFDIV();
        } else if (op == "*") {
            cb.emitFMUL();
        }
    }

    void emitNeg(CodeBuilder cb) {
        cb.emitFNEG();
    }

    public void emitLoad(CodeBuilder cb, int loc) {
        cb.emitFLOAD(loc);
    }

    public void emitStore(CodeBuilder cb, int loc) {
        cb.emitFSTORE(loc);
    }

    public void emitReturn(CodeBuilder cb) {
        cb.emitFRETURN();
    }

    void emitCast(CodeBuilder cb, Type castTo) {
        ((NumericType)castTo).emitCastFromFloat(cb);
    }

    void emitCastFromInt(CodeBuilder cb) {
        cb.emitI2F();
    }

    void emitCastFromFloat(CodeBuilder cb) {
    }

    void emitCastFromLong(CodeBuilder cb) {
        cb.emitL2F();
    }

    void emitCastFromDouble(CodeBuilder cb) {
        cb.emitD2F();
    }

    void emitZero(CodeBuilder cb) {
        cb.emitFloatConstant(0.0f);
    }

    void emitOne(CodeBuilder cb) {
        cb.emitFloatConstant(1.0f);
    }

    void emitMinusOne(CodeBuilder cb) {
        cb.emitFloatConstant(-1.0f);
    }

    void emitEqualityCompare(CodeBuilder cb, String op, Label t, Label f) {
        cb.emitFCMPL();
        if (op == "==") {
            cb.emitIFEQ(t, f);
        } else if (op == "!=") {
            cb.emitIFNE(t, f);
        }
    }

    void emitNumericCompare(CodeBuilder cb, String op, Label t, Label f) {
        if (op == "<") {
            cb.emitFCMPG();
            cb.emitIFLT(t, f);
        } else if (op == "<=") {
            cb.emitFCMPG();
            cb.emitIFLE(t, f);
        } else if (op == ">=") {
            cb.emitFCMPL();
            cb.emitIFGE(t, f);
        } else if (op == ">") {
            cb.emitFCMPL();
            cb.emitIFGT(t, f);
        }
    }

    void emitAload(CodeBuilder cb) {
        cb.emitFALOAD();
    }

    void emitAstore(CodeBuilder cb) {
        cb.emitFASTORE();
    }
}

