/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import java.io.IOException;
import org.aspectj.compiler.base.CodeWriter;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.Formals;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.bcg.CodeBuilder;

public class Exprs
extends Expr {
    protected int size;
    public Expr[] children;

    public Type discoverType() {
        return this.getTypeManager().voidType;
    }

    public Exprs(SourceLocation source, int n) {
        this(source, new Expr[n]);
    }

    public void unparse(CodeWriter writer) throws IOException {
        writer.writeChildrenWithCommas(this);
    }

    void cgValues(CodeBuilder cb, Formals fs) {
        int i = 0;
        int len = this.size;
        while (i < len) {
            this.children[i].cgValue(cb, fs.get(i).getType());
            ++i;
        }
    }

    void cgEffects(CodeBuilder cb) {
        int i = 0;
        int len = this.size;
        while (i < len) {
            this.children[i].cgEffect(cb);
            ++i;
        }
    }

    public Exprs(SourceLocation location, Expr[] _children) {
        super(location);
        int i = 0;
        while (i < _children.length) {
            if (_children[i] != null) {
                _children[i].setParent(this);
            }
            ++i;
        }
        this.children = _children;
        this.size = _children.length;
    }

    public Exprs(SourceLocation location) {
        this(location, new Expr[0]);
    }

    public Exprs(SourceLocation location, Expr child1) {
        this(location, new Expr[]{child1});
    }

    public Exprs(SourceLocation location, Expr child1, Expr child2) {
        this(location, new Expr[]{child1, child2});
    }

    public Exprs(SourceLocation location, Expr child1, Expr child2, Expr child3) {
        this(location, new Expr[]{child1, child2, child3});
    }

    public ASTObject copyWalk(CopyWalker walker) {
        int N = this.size;
        Expr[] copiedChildren = new Expr[N];
        int newIndex = 0;
        int oldIndex = 0;
        while (oldIndex < N) {
            Expr newChild = (Expr)walker.process(this.children[oldIndex]);
            if (newChild != null) {
                copiedChildren[newIndex++] = newChild;
            }
            ++oldIndex;
        }
        Exprs ret = new Exprs(this.getSourceLocation(), copiedChildren);
        ret.size = newIndex;
        ret.setSource(this);
        return ret;
    }

    public ASTObject getChildAt(int childIndex) {
        return this.get(childIndex);
    }

    public void setChildAt(int childIndex, ASTObject child) {
        this.set(childIndex, (Expr)child);
    }

    public String getChildNameAt(int childIndex) {
        return "expr" + childIndex;
    }

    public int getChildCount() {
        return this.size;
    }

    public int size() {
        return this.size;
    }

    public Expr get(int index) {
        if (index >= this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.children[index];
    }

    public void set(int index, Expr child) {
        if (index >= this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.children[index] = child;
        child.setParent(this);
    }

    public void resize(int newSize) {
        if (newSize > this.children.length) {
            Expr[] newChildren = new Expr[this.children.length * 2 + 1];
            System.arraycopy(this.children, 0, newChildren, 0, this.children.length);
            this.children = newChildren;
        }
        this.size = newSize;
    }

    public void addAll(Exprs collection) {
        this.addAll(this.size, collection);
    }

    public void addAll(int index, Exprs collection) {
        int i = 0;
        while (i < collection.size()) {
            this.add(index + i, collection.get(i));
            ++i;
        }
    }

    public void add(Expr child) {
        this.add(this.size, child);
    }

    public void add(int index, Expr child) {
        if (child == null) {
            return;
        }
        if (index < 0 || index > this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.resize(this.size + 1);
        int moveIndex = this.size - 1;
        while (moveIndex > index) {
            this.children[moveIndex] = this.children[moveIndex - 1];
            --moveIndex;
        }
        this.children[index] = child;
        child.setParent(this);
    }

    public void remove(int index) {
        if (index < 0 || index > this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        --this.size;
        int moveIndex = index;
        while (moveIndex < this.size) {
            this.children[moveIndex] = this.children[moveIndex + 1];
            ++moveIndex;
        }
    }

    public String getDefaultDisplayName() {
        return "Exprs()";
    }
}

