/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.BinopExpr;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.LiteralExpr;
import org.aspectj.compiler.base.ast.RefType;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.bcg.CodeBuilder;
import org.aspectj.compiler.base.bcg.Label;

public class EqualityTestOpExpr
extends BinopExpr {
    protected Type discoverType() {
        Type ty1 = this.getRand1().getType();
        Type ty2 = this.getRand2().getType();
        if (ty1 instanceof RefType && ty2 instanceof RefType) {
            if (!ty1.isCoercableTo(ty2) && !ty2.isCoercableTo(ty1)) {
                this.showError("incomparable types: " + ty1.getString() + " and " + ty2.getString());
            }
        } else if (!(!(ty1 instanceof RefType) && !(ty2 instanceof RefType) && (ty1.isBoolean() && ty2.isBoolean() || ty1.isNumeric() && ty2.isNumeric()))) {
            this.showOperatorTypeError(this.op, ty1, ty2);
        }
        return this.getTypeManager().booleanType;
    }

    protected Type getLiftType() {
        Type ty1 = this.getRand1().getType();
        Type ty2 = this.getRand2().getType();
        if (ty1.isBoolean() && ty2.isBoolean()) {
            return this.getTypeManager().booleanType;
        }
        if (ty1.isNumeric() && ty2.isNumeric()) {
            return this.getTypeManager().binaryNumericPromotion(ty1, ty2);
        }
        if (ty1 instanceof RefType && ty2 instanceof RefType) {
            return this.getTypeManager().getObjectType();
        }
        this.showOperatorTypeError(this.op, ty1, ty2);
        return this.getTypeManager().anyType;
    }

    protected LiteralExpr halfFold(Type type, LiteralExpr lit1, LiteralExpr lit2) {
        return type.foldEqualityTestOp(this.getOp(), lit1, lit2);
    }

    protected void cgTest(CodeBuilder cb, Label t, Label f) {
        Type liftType = this.getLiftType();
        if (liftType.hasFastEqualityTestOp()) {
            liftType.emitFastEqualityTestOp(cb, this, t, f);
        } else {
            this.getRand1().cgValue(cb, liftType);
            this.getRand2().cgValue(cb, liftType);
            liftType.emitEqualityCompare(cb, this.getOp(), t, f);
        }
    }

    protected void cgOp(CodeBuilder cb, Type ty) {
        throw new RuntimeException("Attempt to generate code for effect op " + this.getOp());
    }

    public EqualityTestOpExpr(SourceLocation location, Expr _rand1, String _op, Expr _rand2) {
        super(location, _rand1, _op, _rand2);
    }

    protected EqualityTestOpExpr(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        EqualityTestOpExpr ret = new EqualityTestOpExpr(this.getSourceLocation());
        ret.preCopy(walker, this);
        if (this.rand1 != null) {
            ret.setRand1((Expr)walker.process(this.rand1));
        }
        ret.op = this.op;
        if (this.rand2 != null) {
            ret.setRand2((Expr)walker.process(this.rand2));
        }
        return ret;
    }

    public String getDefaultDisplayName() {
        return "EqualityTestOpExpr(op: " + this.op + ")";
    }
}

