/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.aspectj.compiler.base.ast.LabeledStmt;
import org.aspectj.compiler.base.ast.Stmt;
import org.aspectj.compiler.base.ast.WindingStmt;

public final class ControlContext {
    private List context = new ArrayList();

    public void enter(Stmt s) {
        this.context.add(s);
    }

    public void exit() {
        this.context.remove(this.context.size() - 1);
    }

    public Stmt getBreakTarget(String label) {
        return this.getTarget(label, true);
    }

    public Stmt getContinueTarget(String label) {
        return this.getTarget(label, false);
    }

    public boolean isLabelUsed(String label) {
        int i = this.context.size() - 1;
        while (i >= 0) {
            Object s = this.context.get(i);
            if (s instanceof LabeledStmt && label.equals(((LabeledStmt)s).getLabel())) {
                return true;
            }
            --i;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private Stmt getTarget(String target, boolean isBreak) {
        block8: {
            i = this.context.size() - 1;
            if (target != null) ** GOTO lbl25
            if (!isBreak) ** GOTO lbl15
            while (i >= 0) {
                s = (Stmt)this.context.get(i);
                if (s.isBreakable()) {
                    return s;
                }
                --i;
            }
            break block8;
lbl-1000:
            // 1 sources

            {
                s = (Stmt)this.context.get(i);
                if (s.isContinuable()) {
                    return s;
                }
                --i;
lbl15:
                // 2 sources

                ** while (i >= 0)
            }
lbl16:
            // 1 sources

            break block8;
lbl-1000:
            // 1 sources

            {
                s = (Stmt)this.context.get(i);
                if (s instanceof LabeledStmt && target.equals(((LabeledStmt)s).getLabel())) {
                    if (isBreak) {
                        return s;
                    }
                    if ((s = ((LabeledStmt)s).getStmt()).isContinuable()) {
                        return s;
                    }
                    throw new UnsupportedOperationException();
                }
                --i;
lbl25:
                // 2 sources

                ** while (i >= 0)
            }
        }
        throw new NoSuchElementException();
    }

    public Iterator getWindsUntil(final Stmt end) {
        return new Iterator(){
            private int i;
            private boolean live;
            {
                this.i = ControlContext.this.context.size() - 1;
                this.live = true;
                this.search();
            }

            private void search() {
                while (this.i >= 0) {
                    Object o = ControlContext.this.context.get(this.i);
                    if (o == end) break;
                    if (o instanceof WindingStmt) {
                        return;
                    }
                    --this.i;
                }
                this.live = false;
            }

            public boolean hasNext() {
                return this.live;
            }

            public Object next() {
                if (!this.live) {
                    throw new NoSuchElementException();
                }
                Object o = ControlContext.this.context.get(this.i--);
                this.search();
                return o;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

