/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import org.aspectj.compiler.base.ASTFixerPass;
import org.aspectj.compiler.base.CodeWriter;
import org.aspectj.compiler.base.FlowCheckerPass;
import org.aspectj.compiler.base.InnerAccessFixer;
import org.aspectj.compiler.base.InnerInfoPass;
import org.aspectj.compiler.base.LocalClassPass;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.Constructor;
import org.aspectj.compiler.base.ast.ConstructorDec;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.Exprs;
import org.aspectj.compiler.base.ast.NameType;
import org.aspectj.compiler.base.ast.ScopeWalker;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.ThisExpr;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.TypeDs;
import org.aspectj.compiler.base.bcg.CodeBuilder;

public class ConstructorCallExpr
extends Expr {
    protected Expr enclosingInstanceExpr;
    protected boolean isSuper;
    protected Exprs args;
    protected Constructor constructor;

    public ConstructorDec getConstructorDec() {
        return (ConstructorDec)this.constructor.getCorrespondingDec();
    }

    public void setConstructorDec(ConstructorDec md) {
        this.setConstructor((Constructor)md.getCorrespondingSemanticObject());
    }

    public boolean inStaticContext() {
        return true;
    }

    public void checkSpec() {
        if (this.getEnclosingInstanceExpr() != null) {
            NameType enclosingTy;
            Type exprTy;
            NameType ty = (NameType)this.getConstructorDec().getDeclaringType();
            if (!ty.isInner()) {
                this.showError("Class " + ty.getId() + " is not an inner class");
            }
            if (!(exprTy = this.getEnclosingInstanceExpr().getType()).isSubtypeOf(enclosingTy = ty.getEnclosingType())) {
                this.showTypeError(exprTy, enclosingTy);
            }
        }
        super.checkSpec();
    }

    public void walkFlow(FlowCheckerPass w) {
        w.process(this.getEnclosingInstanceExpr());
        w.process(this.getArgs());
        if (this.getConstructor().getThrows() != null) {
            TypeDs ts = this.getConstructor().getThrows();
            int i = 0;
            int len = ts.size();
            while (i < len) {
                w.setExns(w.getExns().add((NameType)ts.get(i).getType()));
                ++i;
            }
        }
    }

    public ASTObject postScope(ScopeWalker walker) {
        if (this.constructor != null) {
            return this;
        }
        Type myType = this.getDeclaringType();
        if (this.isSuper) {
            myType = myType.getTypeDec().getSuperClassType();
        }
        this.constructor = myType.getConstructor(this, this.args, true);
        return this;
    }

    public Type discoverType() {
        return this.getTypeManager().voidType;
    }

    public void fixForIntroductions() {
        Expr extraArg = null;
        if (this.constructor != null) {
            extraArg = this.constructor.getExtraArgExpr();
        }
        if (extraArg != null) {
            this.args.add(extraArg);
        }
    }

    public ASTObject postFixAST(ASTFixerPass fixer) {
        this.fixForIntroductions();
        return super.postFixAST(fixer);
    }

    public void unparse(CodeWriter writer) {
        if (this.getEnclosingInstanceExpr() != null && this.isSuper) {
            writer.write(this.getEnclosingInstanceExpr());
            writer.write(".");
        }
        if (this.isSuper) {
            writer.writeKeyword("super");
        } else {
            writer.writeKeyword("this");
        }
        writer.openParen('(');
        writer.write(this.args);
        writer.closeParen(')');
        writer.closeStmt();
    }

    public ASTObject postInnerAccess(InnerAccessFixer w) {
        ConstructorDec dec = this.getConstructorDec();
        if (!w.isAccessible(dec, this)) {
            dec.getModifiers().setPrivate(false);
        }
        return this;
    }

    public void walkAnalysis(LocalClassPass.AnalysisWalker walker) {
        walker.inConstructorCall();
        this.walk(walker);
    }

    public void preThreading(LocalClassPass.ThreadingWalker walker) {
        if (this.getConstructorDec() == null) {
            this.showWarning("no constructor dec bound: " + this);
            this.getParent().getParent().display(2);
            return;
        }
        walker.addArgs(this.getArgs(), this.getConstructorDec().getDeclaringType().getTypeDec());
    }

    public void walkInnerInfo(InnerInfoPass w) {
        int context = w.inCCall();
        super.walkInnerInfo(w);
        w.restoreContext(context);
    }

    public void postInnerInfo(InnerInfoPass w) {
        if (this.getConstructor() == null) {
            return;
        }
        NameType target = (NameType)this.getConstructor().getDeclaringType();
        if (InnerInfoPass.isInner(target) && this.getEnclosingInstanceExpr() == null) {
            NameType enclosingTarget = target.getEnclosingType();
            if (!w.isAccessible(enclosingTarget)) {
                this.showError("no enclosing instance available");
            } else {
                this.setEnclosingInstanceExpr(this.getAST().makeEnclosingPrimary(enclosingTarget, w.currentType()));
            }
        }
    }

    protected void cgValue(CodeBuilder cb) {
        throw new RuntimeException("should only be called in effect context " + this);
    }

    protected void cgEffect(CodeBuilder cb) {
        cb.enterLocation(this.getSourceLocation());
        Constructor dec = this.getInternalConstructor();
        NameType declaringType = (NameType)dec.getDeclaringType();
        cb.emitALOAD(0);
        if (this.getEnclosingInstanceExpr() != null) {
            this.getEnclosingInstanceExpr().cgValue(cb, dec.getEnclosingInstanceFormal().getType());
            if (!(this.getEnclosingInstanceExpr() instanceof ThisExpr)) {
                cb.emitDUP();
                cb.emitINVOKEVIRTUAL(this.getTypeManager().getObjectType(), "getClass", "()Ljava/lang/Class;", 0);
                cb.emitPOP();
            }
        }
        this.getArgs().cgValues(cb, dec.getFormals());
        cb.emitINVOKESPECIAL(declaringType, "<init>", dec.getDescriptor(), dec.getStackDelta());
    }

    public Constructor getInternalConstructor() {
        if (this.constructor != null) {
            return this.constructor;
        }
        Type myType = this.getDeclaringType();
        if (this.isSuper) {
            myType = myType.getTypeDec().getSuperClassType();
        }
        this.constructor = myType.getConstructor(this, this.args, true);
        return this.constructor;
    }

    public ConstructorCallExpr(SourceLocation source, boolean _isSuper, Exprs _args) {
        this(source, null, _isSuper, _args, null);
    }

    public ConstructorCallExpr(SourceLocation location, boolean _isSuper, Exprs _args, Constructor _constructor) {
        this(location, null, _isSuper, _args, _constructor);
    }

    public Expr getEnclosingInstanceExpr() {
        return this.enclosingInstanceExpr;
    }

    public void setEnclosingInstanceExpr(Expr _enclosingInstanceExpr) {
        if (_enclosingInstanceExpr != null) {
            _enclosingInstanceExpr.setParent(this);
        }
        this.enclosingInstanceExpr = _enclosingInstanceExpr;
    }

    public boolean getIsSuper() {
        return this.isSuper;
    }

    public void setIsSuper(boolean _isSuper) {
        this.isSuper = _isSuper;
    }

    public Exprs getArgs() {
        return this.args;
    }

    public void setArgs(Exprs _args) {
        if (_args != null) {
            _args.setParent(this);
        }
        this.args = _args;
    }

    public Constructor getConstructor() {
        return this.constructor;
    }

    public void setConstructor(Constructor _constructor) {
        this.constructor = _constructor;
    }

    public ConstructorCallExpr(SourceLocation location, Expr _enclosingInstanceExpr, boolean _isSuper, Exprs _args, Constructor _constructor) {
        super(location);
        this.setEnclosingInstanceExpr(_enclosingInstanceExpr);
        this.setIsSuper(_isSuper);
        this.setArgs(_args);
        this.setConstructor(_constructor);
    }

    protected ConstructorCallExpr(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        ConstructorCallExpr ret = new ConstructorCallExpr(this.getSourceLocation());
        ret.preCopy(walker, this);
        if (this.enclosingInstanceExpr != null) {
            ret.setEnclosingInstanceExpr((Expr)walker.process(this.enclosingInstanceExpr));
        }
        ret.isSuper = this.isSuper;
        if (this.args != null) {
            ret.setArgs((Exprs)walker.process(this.args));
        }
        ret.constructor = this.constructor;
        return ret;
    }

    public ASTObject getChildAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return this.enclosingInstanceExpr;
            }
            case 1: {
                return this.args;
            }
        }
        return super.getChildAt(childIndex);
    }

    public String getChildNameAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return "enclosingInstanceExpr";
            }
            case 1: {
                return "args";
            }
        }
        return super.getChildNameAt(childIndex);
    }

    public void setChildAt(int childIndex, ASTObject child) {
        switch (childIndex) {
            case 0: {
                this.setEnclosingInstanceExpr((Expr)child);
                return;
            }
            case 1: {
                this.setArgs((Exprs)child);
                return;
            }
        }
        super.setChildAt(childIndex, child);
    }

    public int getChildCount() {
        return 2;
    }

    public String getDefaultDisplayName() {
        return "ConstructorCallExpr(isSuper: " + this.isSuper + ", " + "constructor: " + this.constructor + ")";
    }
}

