/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.base.ast;

import org.aspectj.compiler.base.FlowCheckerPass;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.LiteralExpr;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.bcg.CodeBuilder;
import org.aspectj.compiler.base.bcg.FieldBuilder;
import org.aspectj.compiler.base.bcg.Label;

public class BooleanLiteralExpr
extends LiteralExpr {
    protected boolean booleanValue;

    public boolean isConstantTrue() {
        return this.getBooleanValue();
    }

    public boolean isConstantFalse() {
        return !this.getBooleanValue();
    }

    public String getStringValue() {
        return this.value;
    }

    public BooleanLiteralExpr(SourceLocation source, boolean _booleanValue) {
        this(source, source.getCompiler().getTypeManager().booleanType, "" + _booleanValue, _booleanValue);
    }

    public void walkFlow(FlowCheckerPass w) {
        if (this.getBooleanValue()) {
            w.setVars(w.getVars(), FlowCheckerPass.getAllVars());
        } else {
            w.setVars(FlowCheckerPass.getAllVars(), w.getVars());
        }
    }

    protected void cgTest(CodeBuilder cb, Label tdest, Label fdest) {
        cb.emitJump(this.getBooleanValue() ? tdest : fdest);
    }

    protected void cgValue(CodeBuilder cb) {
        cb.emitIntConstant(this.booleanValue ? 1 : 0);
    }

    public void addConstant(FieldBuilder fb) {
        fb.setConstantValue(this.booleanValue);
    }

    public boolean getBooleanValue() {
        return this.booleanValue;
    }

    public void setBooleanValue(boolean _booleanValue) {
        this.booleanValue = _booleanValue;
    }

    public BooleanLiteralExpr(SourceLocation location, Type _type, String _value, boolean _booleanValue) {
        super(location, _type, _value);
        this.setBooleanValue(_booleanValue);
    }

    protected BooleanLiteralExpr(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        BooleanLiteralExpr ret = new BooleanLiteralExpr(this.getSourceLocation());
        ret.preCopy(walker, this);
        ret.type = this.type;
        ret.value = this.value;
        ret.booleanValue = this.booleanValue;
        return ret;
    }

    public String getDefaultDisplayName() {
        return "BooleanLiteralExpr(type: " + this.type + ", " + "value: " + this.value + ", " + "booleanValue: " + this.booleanValue + ")";
    }
}

